/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.simplequarry.cfg;

import com.zeitheron.hammercore.cfg.HCModConfigurations;
import com.zeitheron.hammercore.cfg.IConfigReloadListener;
import com.zeitheron.hammercore.cfg.fields.ModConfigPropertyInt;
import com.zeitheron.hammercore.internal.variables.IVariable;
import com.zeitheron.hammercore.internal.variables.VariableRefreshEvent;
import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.net.internal.PacketUpdateDirtyVariables;
import com.zeitheron.hammercore.net.transport.NetTransport;
import java.util.Collections;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.zeith.simplequarry.SimpleQuarry;

@Mod.EventBusSubscriber
@HCModConfigurations(modid="simplequarry")
public class ConfigsSQ
implements IConfigReloadListener {
    @ModConfigPropertyInt(name="Fuel Quarry Mine Tick Rate", category="Gameplay", defaultValue=10, min=1, max=65536, comment="How frequently the Fuel Quarry will mine blocks?")
    public static int FUEL_QUARRY_TICK_RATE;
    public static Configuration cfgs;
    private static OptionalDouble bpcOverride;
    private static OptionalInt pqrOverride;

    public static void updateVariable() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagCompound lst = new NBTTagCompound();
        SimpleQuarry.SYNC_CONFIGS.set((Object)nbt);
        SimpleQuarry.LOG.info("Updated server configs: " + nbt);
    }

    @SubscribeEvent
    public static void updateVar(VariableRefreshEvent evt) {
        IVariable var = evt.getVariable();
        if (var == SimpleQuarry.SYNC_CONFIGS) {
            SimpleQuarry.LOG.info("Accepted server configs: " + var.get());
            NBTTagCompound data = (NBTTagCompound)SimpleQuarry.SYNC_CONFIGS.get();
            bpcOverride = OptionalDouble.of(data.func_74760_g("BPC"));
            pqrOverride = OptionalInt.of(data.func_74762_e("QuarryRecipe"));
        }
    }

    public void reloadCustom(Configuration cfgs) {
        ConfigsSQ.cfgs = cfgs;
        Side effSide = FMLCommonHandler.instance().getEffectiveSide();
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && (effSide.isServer() || effSide.isClient() && server instanceof IntegratedServer)) {
            server.func_152344_a(() -> {
                ConfigsSQ.updateVariable();
                NetTransport.wrap((IPacket)new PacketUpdateDirtyVariables(Collections.singletonMap(SimpleQuarry.SYNC_CONFIGS.getId(), SimpleQuarry.SYNC_CONFIGS))).sendToAll();
            });
        }
    }

    static {
        bpcOverride = OptionalDouble.empty();
        pqrOverride = OptionalInt.empty();
    }
}

