/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.tconstruct;

import com.blamejared.ModTweaker;
import com.blamejared.compat.tconstruct.recipes.MeltingRecipeTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseAction;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.events.TinkerRegisterEvent;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.tconstruct.Melting")
@ZenRegister
@ModOnly(value="tconstruct")
public class Melting {
    public static final Multimap<ILiquidStack, IItemStack> REMOVED_RECIPES = LinkedListMultimap.create();
    public static final List<EntityEntry> REMOVED_ENTITIES = new LinkedList<EntityEntry>();
    public static final Map<EntityEntry, FluidStack> ADDED_ENTITIES = new LinkedHashMap<EntityEntry, FluidStack>();
    private static boolean init = false;

    private static void init() {
        if (!init) {
            MinecraftForge.EVENT_BUS.register((Object)new Melting());
            init = true;
        }
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack output, IIngredient input, @Optional int temp) {
        Melting.init();
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toFluid((ILiquidStack)output), input, temp));
    }

    @ZenMethod
    public static void addEntityMelting(IEntityDefinition entity, ILiquidStack stack) {
        Melting.init();
        ModTweaker.LATE_ADDITIONS.add((IAction)new AddEntityMelting((EntityEntry)entity.getInternal(), InputHelper.toFluid((ILiquidStack)stack)));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack output, @Optional IItemStack input) {
        Melting.init();
        CraftTweakerAPI.apply((IAction)new Remove(output, input));
    }

    @ZenMethod
    public static void removeEntityMelting(IEntityDefinition entity) {
        Melting.init();
        CraftTweakerAPI.apply((IAction)new RemoveEntityMelting((EntityEntry)entity.getInternal()));
    }

    @SubscribeEvent
    public void onTinkerRegister(TinkerRegisterEvent.MeltingRegisterEvent event) {
        if (event.getRecipe() instanceof MeltingRecipeTweaker) {
            return;
        }
        for (Map.Entry ent : REMOVED_RECIPES.entries()) {
            if (!((MeltingRecipe)event.getRecipe()).getResult().isFluidEqual((FluidStack)((ILiquidStack)ent.getKey()).getInternal())) continue;
            if (ent.getValue() != null) {
                if (!((MeltingRecipe)event.getRecipe()).input.matches(NonNullList.func_191197_a((int)1, (Object)((ItemStack)((IItemStack)ent.getValue()).getInternal()))).isPresent()) continue;
                event.setCanceled(true);
                continue;
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onTinkerRegister(TinkerRegisterEvent.EntityMeltingRegisterEvent event) {
        boolean remove = true;
        for (Map.Entry<EntityEntry, FluidStack> entry : ADDED_ENTITIES.entrySet()) {
            if (!((Class)event.getRecipe()).equals(entry.getKey().getEntityClass())) continue;
            remove = false;
            event.setNewFluidStack(entry.getValue());
        }
        if (remove) {
            for (EntityEntry entity : REMOVED_ENTITIES) {
                if (!entity.getEntityClass().equals(event.getRecipe())) continue;
                event.setCanceled(true);
            }
        }
    }

    private static class RemoveEntityMelting
    extends BaseAction {
        private EntityEntry entity;

        protected RemoveEntityMelting(EntityEntry input) {
            super("EntityMelting");
            this.entity = input;
        }

        public void apply() {
            REMOVED_ENTITIES.add(this.entity);
        }

        protected String getRecipeInfo() {
            if (this.entity == null) {
                return "null";
            }
            return this.entity.getName();
        }
    }

    private static class Remove
    extends BaseAction {
        private ILiquidStack output;
        private IItemStack input;

        protected Remove(ILiquidStack output, IItemStack input) {
            super("Melting");
            this.output = output;
            this.input = input;
        }

        public void apply() {
            REMOVED_RECIPES.put((Object)this.output, (Object)this.input);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((IIngredient)this.output);
        }
    }

    private static class AddEntityMelting
    extends BaseAction {
        private EntityEntry entity;
        private FluidStack output;

        public AddEntityMelting(EntityEntry entity, FluidStack input) {
            super("EntityMelting");
            this.entity = entity;
            this.output = input;
        }

        public void apply() {
            TinkerRegistry.registerEntityMelting((Class)this.entity.getEntityClass(), (FluidStack)this.output);
            ADDED_ENTITIES.put(this.entity, this.output);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((FluidStack)this.output);
        }
    }

    private static class Add
    extends BaseAction {
        private final FluidStack output;
        private final IIngredient ingredient;
        private final int temp;

        public Add(FluidStack output, IIngredient ingredient, int temp) {
            super("Melting");
            this.output = output;
            this.temp = temp;
            this.ingredient = ingredient;
        }

        public void apply() {
            List validIngredients = this.ingredient.getItems().stream().map(CraftTweakerMC::getItemStack).collect(Collectors.toList());
            if (validIngredients.isEmpty()) {
                CraftTweakerAPI.logInfo((String)("Could not find matching items for " + this.ingredient.toString() + ". Ignoring Melting recipe for " + this.output.getLocalizedName()));
                return;
            }
            RecipeMatch rm = validIngredients.size() == 1 && ((ItemStack)validIngredients.get(0)).func_77960_j() != Short.MAX_VALUE ? RecipeMatch.ofNBT((ItemStack)((ItemStack)validIngredients.get(0)), (int)this.output.amount) : RecipeMatch.of(validIngredients, (int)this.output.amount);
            if (this.temp == 0) {
                TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipeTweaker(rm, this.output));
            } else {
                TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipeTweaker(rm, this.output, this.temp));
            }
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((FluidStack)this.output);
        }
    }
}

