/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.tcomplement.highoven;

import com.blamejared.compat.mantle.RecipeMatchIIngredient;
import com.blamejared.mtlib.helpers.InputHelper;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.mc1120.item.MCItemStack;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import knightminer.tcomplement.library.events.TCompRegisterEvent;
import knightminer.tcomplement.library.steelworks.IMixRecipe;
import knightminer.tcomplement.library.steelworks.MixAdditive;
import knightminer.tcomplement.library.steelworks.MixRecipe;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.mantle.util.RecipeMatch;
import stanhebben.zenscript.annotations.NotNull;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.tcomplement.highoven.MixRecipeManager")
@ZenRegister
@ModOnly(value="tcomplement")
public class MixRecipeManager {
    private FluidStack input;
    private FluidStack output;
    private List<AbstractMap.SimpleEntry<RecipeMatch, MixAdditive>> additives;
    private Map<MixAdditive, List<IIngredient>> removedAdditives;

    public MixRecipeManager(ILiquidStack output, ILiquidStack input) {
        this.input = InputHelper.toFluid((ILiquidStack)input);
        this.output = InputHelper.toFluid((ILiquidStack)output);
        this.additives = new LinkedList<AbstractMap.SimpleEntry<RecipeMatch, MixAdditive>>();
        this.removedAdditives = new HashMap<MixAdditive, List<IIngredient>>(MixAdditive.values().length, 1.0f);
        for (MixAdditive type : MixAdditive.values()) {
            this.removedAdditives.put(type, new LinkedList());
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @ZenMethod
    public MixRecipeManager addOxidizer(@NotNull IIngredient oxidizer, int consumeChance) {
        this.additives.add(new AbstractMap.SimpleEntry<RecipeMatchIIngredient, MixAdditive>(new RecipeMatchIIngredient(oxidizer, consumeChance), MixAdditive.OXIDIZER));
        return this;
    }

    @ZenMethod
    public MixRecipeManager addReducer(@NotNull IIngredient reducer, int consumeChance) {
        this.additives.add(new AbstractMap.SimpleEntry<RecipeMatchIIngredient, MixAdditive>(new RecipeMatchIIngredient(reducer, consumeChance), MixAdditive.REDUCER));
        return this;
    }

    @ZenMethod
    public MixRecipeManager addPurifier(@NotNull IIngredient purifier, int consumeChance) {
        this.additives.add(new AbstractMap.SimpleEntry<RecipeMatchIIngredient, MixAdditive>(new RecipeMatchIIngredient(purifier, consumeChance), MixAdditive.PURIFIER));
        return this;
    }

    @ZenMethod
    public MixRecipeManager removeOxidizer(IIngredient oxidizer) {
        if (oxidizer != null && this.removedAdditives.get(MixAdditive.OXIDIZER) != null) {
            this.removedAdditives.get(MixAdditive.OXIDIZER).add(oxidizer);
        } else {
            this.removedAdditives.put(MixAdditive.OXIDIZER, null);
        }
        return this;
    }

    @ZenMethod
    public MixRecipeManager removeReducer(IIngredient reducer) {
        if (reducer != null && this.removedAdditives.get(MixAdditive.REDUCER) != null) {
            this.removedAdditives.get(MixAdditive.REDUCER).add(reducer);
        } else {
            this.removedAdditives.put(MixAdditive.REDUCER, null);
        }
        return this;
    }

    @ZenMethod
    public MixRecipeManager removePurifier(IIngredient purifier) {
        if (purifier != null && this.removedAdditives.get(MixAdditive.PURIFIER) != null) {
            this.removedAdditives.get(MixAdditive.PURIFIER).add(purifier);
        } else {
            this.removedAdditives.put(MixAdditive.PURIFIER, null);
        }
        return this;
    }

    @SubscribeEvent
    public void onHighOvenMixRegister(TCompRegisterEvent.HighOvenMixRegisterEvent event) {
        if (((IMixRecipe)event.getRecipe()).matches(this.input, this.output)) {
            this.additives.forEach(entry -> ((IMixRecipe)event.getRecipe()).addAdditive((MixAdditive)entry.getValue(), (RecipeMatch)entry.getKey()));
        }
    }

    @SubscribeEvent
    public void onHighOvenAdditiveRegister(TCompRegisterEvent.HighOvenMixAdditiveEvent event) {
        if (((MixRecipe)event.getRecipe()).matches(this.input, this.output)) {
            List<IIngredient> removals = this.removedAdditives.get(event.getType());
            if (removals != null) {
                for (IIngredient removal : removals) {
                    for (ItemStack additive : event.getAdditive().getInputs()) {
                        if (!removal.matches((IItemStack)new MCItemStack(additive))) continue;
                        event.setCanceled(true);
                        return;
                    }
                }
            } else {
                event.setCanceled(true);
            }
        }
    }
}

