/*
 * Decompiled with CFR 0.152.
 */
package presents.common.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemLingeringPotion;
import net.minecraft.item.ItemSplashPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import presents.Presents;
import presents.common.entity.EntityPresentPrimed;
import presents.common.misc.PotionHelper;
import presents.common.tileentity.TileEntityPresentEmpty;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TileEntityPresent
extends TileEntityPresentEmpty
implements IInventory {
    private ResourceLocation lootTable;
    private String playerName;
    private long lootTableSeed;
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
    private NBTTagCompound fireworks;
    private int ribbonColor = 0xF9FFFE;

    public void setRibbonColor(int color) {
        this.ribbonColor = color;
        this.func_70296_d();
    }

    public int getRibbonColor() {
        return this.ribbonColor;
    }

    public void setLootTable(ResourceLocation lootTable, long lootTableSeed) {
        this.lootTable = lootTable;
        this.lootTableSeed = lootTableSeed;
        this.func_70296_d();
    }

    private void fillWithLoot(@Nullable EntityPlayer player) {
        if (this.lootTable != null) {
            LootTable loottable = this.field_145850_b.func_184146_ak().func_186521_a(this.lootTable);
            this.lootTable = null;
            Random random = this.lootTableSeed == 0L ? new Random() : new Random(this.lootTableSeed);
            LootContext.Builder builder = new LootContext.Builder((WorldServer)this.field_145850_b);
            if (player != null) {
                builder.func_186469_a(player.func_184817_da()).func_186470_a(player);
            }
            loottable.func_186460_a((IInventory)this, random, builder.func_186471_a());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean makeFireworks() {
        if (this.fireworks == null) {
            if (this.lootTable != null && this.lootTable.equals((Object)Presents.LOOTTABLE_PRESENT_SPECIAL)) {
                this.fireworks = new NBTTagCompound();
                Random random = this.lootTableSeed == 0L ? new Random() : new Random(this.lootTableSeed);
                this.fireworks.func_74757_a("Flicker", random.nextInt(3) == 0);
                this.fireworks.func_74757_a("Trail", random.nextInt(3) == 0);
                this.fireworks.func_74774_a("Type", (byte)random.nextInt(5));
                this.fireworks.func_74783_a("Colors", new int[]{ItemDye.field_150922_c[random.nextInt(15)], ItemDye.field_150922_c[random.nextInt(15)]});
                this.fireworks.func_74783_a("FadeColors", new int[]{ItemDye.field_150922_c[random.nextInt(15)], ItemDye.field_150922_c[random.nextInt(15)]});
            } else {
                return false;
            }
        }
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList tagList = new NBTTagList();
        tagList.func_74742_a((NBTBase)this.fireworks);
        compound.func_74782_a("Explosions", (NBTBase)tagList);
        this.field_145850_b.func_92088_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.3, 0.0, compound);
        return true;
    }

    public void spawnItems(@Nullable EntityPlayer player) {
        this.fillWithLoot(player);
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            if (!this.dispenseItem(stack) && stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150335_W)) {
                EntityPresentPrimed presentPrimed = new EntityPresentPrimed(this.field_145850_b, (float)this.field_174879_c.func_177958_n() + 0.5f, this.field_174879_c.func_177956_o(), (float)this.field_174879_c.func_177952_p() + 0.5f, (EntityLivingBase)player, this.getColor(), this.getRibbonColor());
                this.field_145850_b.func_72838_d((Entity)presentPrimed);
                this.field_145850_b.func_184148_a(null, presentPrimed.field_70165_t, presentPrimed.field_70163_u, presentPrimed.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
                continue;
            }
            if (stack.func_77973_b() instanceof ItemLingeringPotion || stack.func_77973_b() instanceof ItemSplashPotion) {
                PotionHelper.spawnPotion(stack, this.field_145850_b, this.field_174879_c);
                continue;
            }
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)stack);
        }
    }

    private boolean dispenseItem(ItemStack stack) {
        IBehaviorDispenseItem dispenseBehavior = (IBehaviorDispenseItem)BlockDispenser.field_149943_a.func_82594_a((Object)stack.func_77973_b());
        if (dispenseBehavior instanceof BehaviorProjectileDispense || dispenseBehavior == BlockDispenser.field_149943_a.func_82594_a((Object)Items.field_151063_bx) || dispenseBehavior == BlockDispenser.field_149943_a.func_82594_a((Object)Items.field_151152_bP) || dispenseBehavior == BlockDispenser.field_149943_a.func_82594_a((Object)Items.field_151059_bz)) {
            VirtualDispenser dispenser = new VirtualDispenser(this.field_174879_c, this.field_145850_b, stack);
            dispenseBehavior.func_82482_a((IBlockSource)dispenser, stack);
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        if (this.fireworks != null) {
            compound.func_74782_a("Explosion", (NBTBase)this.fireworks);
        }
        if (this.lootTable != null) {
            compound.func_74778_a("LootTable", this.lootTable.toString());
        }
        if (this.lootTableSeed != 0L) {
            compound.func_74772_a("LootTableSeed", this.lootTableSeed);
        }
        compound.func_74768_a("RibbonColor", this.ribbonColor);
        if (this.playerName != null) {
            compound.func_74778_a("PlayerName", this.playerName);
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        if (compound.func_74764_b("Explosion")) {
            this.fireworks = compound.func_74775_l("Explosion");
        }
        if (compound.func_74764_b("LootTable")) {
            this.lootTable = new ResourceLocation(compound.func_74779_i("LootTable"));
            this.lootTableSeed = compound.func_74763_f("LootTableSeed");
        }
        if (compound.func_74764_b("RibbonColor")) {
            this.ribbonColor = compound.func_74762_e("RibbonColor");
        }
        if (compound.func_74764_b("PlayerName")) {
            this.playerName = compound.func_74779_i("PlayerName");
        }
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound updateTag = super.func_189517_E_();
        if (this.fireworks != null) {
            updateTag.func_74782_a("Explosion", (NBTBase)this.fireworks);
        }
        if (this.lootTable != null) {
            updateTag.func_74778_a("LootTable", this.lootTable.toString());
        }
        if (this.lootTableSeed != 0L) {
            updateTag.func_74772_a("LootTableSeed", this.lootTableSeed);
        }
        updateTag.func_74768_a("RibbonColor", this.ribbonColor);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound updateTag) {
        super.handleUpdateTag(updateTag);
        if (updateTag.func_74764_b("Explosion")) {
            this.fireworks = updateTag.func_74775_l("Explosion");
        }
        if (updateTag.func_74764_b("LootTable")) {
            this.lootTable = new ResourceLocation(updateTag.func_74779_i("LootTable"));
            this.lootTableSeed = updateTag.func_74763_f("LootTableSeed");
        }
        if (updateTag.func_74764_b("RibbonColor")) {
            this.ribbonColor = updateTag.func_74762_e("RibbonColor");
            this.func_145831_w().func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ((ItemStack)this.inventory.get(index)).func_77979_a(count);
    }

    public ItemStack func_70304_b(int index) {
        return (ItemStack)this.inventory.remove(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return "present";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    private class VirtualDispenser
    implements IBlockSource {
        private final BlockPos pos;
        private final World world;
        private final TileEntityDispenser dispenser;

        VirtualDispenser(BlockPos pos, World world, ItemStack stack) {
            this.pos = pos;
            this.world = world;
            this.dispenser = new TileEntityDispenser();
            this.dispenser.func_146019_a(stack);
        }

        public double func_82615_a() {
            return (double)this.pos.func_177958_n() + 0.5;
        }

        public double func_82617_b() {
            return (double)this.pos.func_177956_o() + 0.5;
        }

        public double func_82616_c() {
            return (double)this.pos.func_177952_p() + 0.5;
        }

        public BlockPos func_180699_d() {
            return this.pos;
        }

        public IBlockState func_189992_e() {
            return Blocks.field_150367_z.func_176223_P().func_177226_a((IProperty)BlockDispenser.field_176441_a, (Comparable)EnumFacing.UP);
        }

        public <T extends TileEntity> T func_150835_j() {
            return (T)this.dispenser;
        }

        public World func_82618_k() {
            return this.world;
        }
    }
}

