/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.proxy;

import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import cofh.core.render.IModelRegister;
import cofh.thermaldynamics.duct.entity.EntityTransport;
import cofh.thermaldynamics.duct.entity.RenderTransport;
import cofh.thermaldynamics.duct.tiles.TileDuctFluid;
import cofh.thermaldynamics.duct.tiles.TileDuctItem;
import cofh.thermaldynamics.proxy.EventHandlerClient;
import cofh.thermaldynamics.proxy.Proxy;
import cofh.thermaldynamics.render.RenderDuct;
import cofh.thermaldynamics.render.RenderDuctFluids;
import cofh.thermaldynamics.render.RenderDuctItems;
import cofh.thermaldynamics.util.TickHandlerClient;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ProxyClient
extends Proxy {
    public static EnumBlockRenderType renderType;
    private static List<IModelRegister> modelRegisters;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)EventHandlerClient.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)TickHandlerClient.INSTANCE);
        RenderingRegistry.registerEntityRenderingHandler(EntityTransport.class, RenderTransport::new);
        for (IModelRegister register : modelRegisters) {
            register.registerModels();
        }
    }

    @Override
    public void initialize(FMLInitializationEvent event) {
        super.initialize(event);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctItem.Basic.Transparent.class, (TileEntitySpecialRenderer)RenderDuctItems.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctItem.Fast.Transparent.class, (TileEntitySpecialRenderer)RenderDuctItems.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctItem.Energy.Transparent.class, (TileEntitySpecialRenderer)RenderDuctItems.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctItem.EnergyFast.Transparent.class, (TileEntitySpecialRenderer)RenderDuctItems.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctFluid.Basic.Transparent.class, (TileEntitySpecialRenderer)RenderDuctFluids.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctFluid.Super.Transparent.class, (TileEntitySpecialRenderer)RenderDuctFluids.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctFluid.Hardened.Transparent.class, (TileEntitySpecialRenderer)RenderDuctFluids.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctFluid.Energy.Transparent.class, (TileEntitySpecialRenderer)RenderDuctFluids.INSTANCE);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        renderType = BlockRenderingRegistry.createRenderType((String)"thermaldynamics");
        BlockRenderingRegistry.registerRenderer((EnumBlockRenderType)renderType, (ICCBlockRenderer)RenderDuct.INSTANCE);
    }

    @Override
    public boolean addIModelRegister(IModelRegister register) {
        return modelRegisters.add(register);
    }

    static {
        modelRegisters = new ArrayList<IModelRegister>();
    }
}

