/*
 * Decompiled with CFR 0.152.
 */
package com.gibraltar.strait.proxy;

import com.gibraltar.strait.feature.Feature;
import com.gibraltar.strait.feature.FrameFeature;
import java.io.File;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class CommonProxy {
    public static Configuration config;
    public static File configFile;
    protected ArrayList features;

    public void preInit(FMLPreInitializationEvent event) {
        configFile = event.getSuggestedConfigurationFile();
        System.out.println(configFile);
        config = new Configuration(configFile);
        config.load();
        this.features = new ArrayList();
        this.features.add(new FrameFeature());
        this.forEachFeature(feature -> feature.loadConfig(config));
        if (config.hasChanged()) {
            config.save();
        }
        this.forEachFeature(feature -> {
            if (feature.enabled) {
                feature.preInit(event);
            }
        });
        config.save();
    }

    public void init(FMLInitializationEvent event) {
        this.forEachFeature(feature -> {
            if (feature.enabled) {
                feature.init(event);
            }
        });
    }

    protected void forEachFeature(Consumer<Feature> action) {
        this.features.forEach(action);
    }

    public boolean isFeatureEnabled(Class clazz) {
        boolean enabled = false;
        for (int i = 0; i < this.features.size(); ++i) {
            Feature feature = (Feature)this.features.get(i);
            if (!clazz.isInstance(feature)) continue;
            enabled = feature.enabled;
        }
        return enabled;
    }
}

