/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.world.gen;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.api.world.ChunkProviderBase;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockBasicMoon;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.perlin.NoiseModule;
import micdoodle8.mods.galacticraft.core.perlin.generator.Billowed;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.world.gen.EnumCraterSize;
import micdoodle8.mods.galacticraft.core.world.gen.MapGenVillageMoon;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonConfiguration;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.MapGenDungeon;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomBoss;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomTreasure;
import micdoodle8.mods.galacticraft.planets.asteroids.ConfigManagerAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.SpecialAsteroidBlock;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.SpecialAsteroidBlockHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;

public class ChunkProviderMoon
extends ChunkProviderBase {
    public static final IBlockState BLOCK_TOP = GCBlocks.blockMoon.func_176223_P().func_177226_a(BlockBasicMoon.BASIC_TYPE_MOON, (Comparable)((Object)BlockBasicMoon.EnumBlockBasicMoon.MOON_TURF));
    public static final IBlockState BLOCK_FILL = GCBlocks.blockMoon.func_176223_P().func_177226_a(BlockBasicMoon.BASIC_TYPE_MOON, (Comparable)((Object)BlockBasicMoon.EnumBlockBasicMoon.MOON_DIRT));
    public static final IBlockState BLOCK_LOWER = GCBlocks.blockMoon.func_176223_P().func_177226_a(BlockBasicMoon.BASIC_TYPE_MOON, (Comparable)((Object)BlockBasicMoon.EnumBlockBasicMoon.MOON_STONE));
    private static final int CRATER_PROB = 300;
    private static final int MID_HEIGHT = 63;
    private static final int CHUNK_SIZE_X = 16;
    private static final int CHUNK_SIZE_Y = 128;
    private static final int CHUNK_SIZE_Z = 16;
    private static final int MAX_ASTEROID_SKEW = 8;
    private static final int MAX_ASTEROID_RADIUS = 25;
    private static final int MIN_ASTEROID_RADIUS = 5;
    private static final int MIN_ASTEROID_Y = 70;
    private static final int MAX_ASTEROID_Y = 208;
    private static final int ASTEROID_CHANCE = 800;
    private static final int ASTEROID_CORE_CHANCE = 2;
    private static final int ASTEROID_SHELL_CHANCE = 2;
    private static final int RANDOM_BLOCK_FADE_SIZE = 32;
    private static final int NOISE_OFFSET_SIZE = 256;
    private static final float MIN_HOLLOW_SIZE = 0.6f;
    private static final float MAX_HOLLOW_SIZE = 0.8f;
    private static final float HOLLOW_LAVA_SIZE = 0.12f;
    private static final int HOLLOW_CHANCE = 10;
    private static final int MIN_RADIUS_FOR_HOLLOW = 15;
    private static final int GLOWSTONE_CHANCE = 20;
    private static final int TALL_GRASS_CHANCE = 2;
    final Block ASTEROID_STONE = AsteroidBlocks.blockBasic;
    final byte ASTEROID_STONE_META_0 = 0;
    final byte ASTEROID_STONE_META_1 = 1;
    final byte ASTEROID_STONE_META_2 = (byte)2;
    final Block LIGHT = Blocks.field_150426_aN;
    final byte LIGHT_META = 0;
    final Block DIRT = Blocks.field_150346_d;
    final byte DIRT_META = 0;
    final Block GRASS = Blocks.field_150349_c;
    final byte GRASS_META = 0;
    private final Random rand;
    private final NoiseModule noiseGen1;
    private final NoiseModule noiseGen2;
    private final NoiseModule noiseGen3;
    private final NoiseModule noiseGen4;
    private final World world;
    private final MapGenVillageMoon villageGenerator = new MapGenVillageMoon();
    private final MapGenDungeon dungeonGeneratorMoon = new MapGenDungeon(new DungeonConfiguration(GCBlocks.blockMoon.func_176223_P().func_177226_a(BlockBasicMoon.BASIC_TYPE_MOON, (Comparable)((Object)BlockBasicMoon.EnumBlockBasicMoon.MOON_DUNGEON_BRICK)), 25, 8, 16, 5, 6, RoomBoss.class, RoomTreasure.class));
    private final Biome[] biomesForGeneration = new Biome[]{BiomeAdaptive.biomeDefault};
    private final NoiseModule asteroidTurbulance;
    private final NoiseModule asteroidDensity;
    private final LinkedList<AsteroidData> largeAsteroids = new LinkedList();
    private final SpecialAsteroidBlockHandler coreHandler;
    private final SpecialAsteroidBlockHandler shellHandler;
    private final NoiseModule asteroidSkewX;
    private final NoiseModule asteroidSkewY;
    private final NoiseModule asteroidSkewZ;
    BlockTallGrass.EnumType GRASS_TYPE = BlockTallGrass.EnumType.GRASS;
    Boolean alreadySet = false;
    private int largeAsteroidsLastChunkX;
    private int largeAsteroidsLastChunkZ;
    private int largeCount = 0;

    public ChunkProviderMoon(World par1World, long par2, boolean par4) {
        this.world = par1World;
        this.rand = new Random(par2);
        this.noiseGen1 = new Gradient(this.rand.nextLong(), 4, 0.25f);
        this.noiseGen2 = new Gradient(this.rand.nextLong(), 4, 0.25f);
        this.noiseGen3 = new Gradient(this.rand.nextLong(), 1, 0.25f);
        this.noiseGen4 = new Gradient(this.rand.nextLong(), 1, 0.25f);
        this.asteroidDensity = new Billowed(this.rand.nextLong(), 2, 0.25f);
        this.asteroidDensity.setFrequency(0.009f);
        this.asteroidDensity.amplitude = 0.6f;
        this.coreHandler = new SpecialAsteroidBlockHandler();
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, this.ASTEROID_STONE_META_2, 5, 0.3));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, this.ASTEROID_STONE_META_1, 7, 0.3));
        this.getClass();
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 0, 11, 0.25));
        if (!ConfigManagerAsteroids.disableAluminumGen) {
            this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 3, 5, 0.2));
        }
        if (!ConfigManagerAsteroids.disableIlmeniteGen) {
            this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 4, 4, 0.15));
        }
        if (!ConfigManagerAsteroids.disableIronGen) {
            this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 5, 3, 0.2));
        }
        if (ConfigManagerCore.enableSiliconOreGen) {
            this.coreHandler.addBlock(new SpecialAsteroidBlock(GCBlocks.basicBlock, 8, 2, 0.15));
        }
        this.coreHandler.addBlock(new SpecialAsteroidBlock(GCBlocks.basicBlock, 12, 2, 0.13));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(Blocks.field_150482_ag, 0, 1, 0.1));
        this.shellHandler = new SpecialAsteroidBlockHandler();
        this.getClass();
        this.shellHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 0, 1, 0.15));
        this.shellHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, this.ASTEROID_STONE_META_1, 3, 0.15));
        this.shellHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, this.ASTEROID_STONE_META_2, 1, 0.15));
        this.asteroidSkewX = new Gradient(this.rand.nextLong(), 1, 1.0f);
        this.asteroidSkewX.amplitude = 8.0f;
        this.asteroidSkewX.frequencyX = 0.005f;
        this.asteroidSkewY = new Gradient(this.rand.nextLong(), 1, 1.0f);
        this.asteroidSkewY.amplitude = 8.0f;
        this.asteroidSkewY.frequencyY = 0.005f;
        this.asteroidSkewZ = new Gradient(this.rand.nextLong(), 1, 1.0f);
        this.asteroidSkewZ.amplitude = 8.0f;
        this.asteroidSkewZ.frequencyZ = 0.005f;
        this.asteroidTurbulance = new Gradient(this.rand.nextLong(), 1, 0.2f);
        this.asteroidTurbulance.setFrequency(0.08f);
        this.asteroidTurbulance.amplitude = 0.5f;
    }

    public void setBlocksInChunk(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.noiseGen1.setFrequency(0.0125f);
        this.noiseGen2.setFrequency(0.015f);
        this.noiseGen3.setFrequency(0.01f);
        this.noiseGen4.setFrequency(0.02f);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double d = this.noiseGen1.getNoise(x + chunkX * 16, z + chunkZ * 16) * 8.0f;
                double d2 = this.noiseGen2.getNoise(x + chunkX * 16, z + chunkZ * 16) * 24.0f;
                double d3 = (double)this.noiseGen3.getNoise(x + chunkX * 16, z + chunkZ * 16) - 0.1;
                double yDev = (d3 *= 4.0) < 0.0 ? d : (d3 > 1.0 ? d2 : d + (d2 - d) * d3);
                for (int y = 0; y < 128; ++y) {
                    if (!((double)y < 63.0 + yDev)) continue;
                    primer.func_177855_a(x, y, z, BLOCK_LOWER);
                }
            }
        }
    }

    private IBlockState getRandomBlock(int percent) {
        int foo = this.rand.nextInt(100);
        if (foo >= percent) {
            return Blocks.field_150403_cj.func_176223_P();
        }
        return GCBlocks.blockMoon.func_176203_a(4);
    }

    private IBlockState getRandomBlock() {
        int foo = this.rand.nextInt(100);
        if (this.rand.nextInt(100) >= 90) {
            return Blocks.field_150403_cj.func_176223_P();
        }
        return GCBlocks.blockMoon.func_176203_a(4);
    }

    private void asteroid_big(ChunkPrimer primer, int x, int y, int z) {
        int percent = 80;
        primer.func_177855_a(x, y - 2, z, this.getRandomBlock(percent));
        primer.func_177855_a(x, y - 1, z, this.getRandomBlock(percent));
        primer.func_177855_a(x + 1, y - 1, z, this.getRandomBlock(percent));
        primer.func_177855_a(x, y - 1, z + 1, this.getRandomBlock(percent));
        primer.func_177855_a(x - 1, y - 1, z, this.getRandomBlock(percent));
        primer.func_177855_a(x, y - 1, z - 1, this.getRandomBlock(percent));
        primer.func_177855_a(x, y, z, this.getRandomBlock(percent));
        primer.func_177855_a(x + 1, y, z, this.getRandomBlock(percent));
        primer.func_177855_a(x + 2, y, z, this.getRandomBlock(percent));
        primer.func_177855_a(x, y, z + 1, this.getRandomBlock(percent));
        primer.func_177855_a(x, y, z + 2, this.getRandomBlock(percent));
        primer.func_177855_a(x - 1, y, z, this.getRandomBlock(percent));
        primer.func_177855_a(x - 2, y, z, this.getRandomBlock(percent));
        primer.func_177855_a(x, y, z - 1, this.getRandomBlock(percent));
        primer.func_177855_a(x, y, z - 2, this.getRandomBlock(percent));
        primer.func_177855_a(x + 1, y, z + 1, this.getRandomBlock(percent));
        primer.func_177855_a(x + 1, y, z - 1, this.getRandomBlock(percent));
        primer.func_177855_a(x - 1, y, z + 1, this.getRandomBlock(percent));
        primer.func_177855_a(x - 1, y, z - 1, this.getRandomBlock(percent));
        primer.func_177855_a(x, y + 1, z, this.getRandomBlock(percent));
        primer.func_177855_a(x + 1, y + 1, z, this.getRandomBlock(percent));
        primer.func_177855_a(x, y + 1, z + 1, this.getRandomBlock(percent));
        primer.func_177855_a(x - 1, y + 1, z, this.getRandomBlock(percent));
        primer.func_177855_a(x, y + 1, z - 1, this.getRandomBlock(percent));
        primer.func_177855_a(x, y + 2, z, this.getRandomBlock(percent));
    }

    private void asteroid_medium(ChunkPrimer primer, int x, int y, int z) {
        int percent = 80;
        primer.func_177855_a(x, y - 1, z, this.getRandomBlock(percent));
        primer.func_177855_a(x, y, z, this.getRandomBlock(percent));
        primer.func_177855_a(x + 1, y, z, this.getRandomBlock(percent));
        primer.func_177855_a(x, y, z + 1, this.getRandomBlock(percent));
        primer.func_177855_a(x - 1, y, z, this.getRandomBlock(percent));
        primer.func_177855_a(x, y, z - 1, this.getRandomBlock(percent));
        primer.func_177855_a(x, y + 1, z, this.getRandomBlock(percent));
    }

    private void asteroid_square(ChunkPrimer primer, int x, int y, int z) {
        primer.func_177855_a(x, y, z, this.getRandomBlock());
        primer.func_177855_a(x + 1, y, z, this.getRandomBlock());
        primer.func_177855_a(x + 1, y, z + 1, this.getRandomBlock());
        primer.func_177855_a(x, y, z + 1, this.getRandomBlock());
        primer.func_177855_a(x, y + 1, z, this.getRandomBlock());
        primer.func_177855_a(x + 1, y + 1, z, this.getRandomBlock());
        primer.func_177855_a(x + 1, y + 1, z + 1, this.getRandomBlock());
        primer.func_177855_a(x, y + 1, z + 1, this.getRandomBlock());
    }

    private void asteroid_single(ChunkPrimer primer, int x, int y, int z) {
        primer.func_177855_a(x, y, z, this.getRandomBlock());
    }

    public void replaceBlocksForBiome(int par1, int par2, ChunkPrimer primer, Biome[] par4ArrayOfBiome) {
        int var5 = 20;
        Random random = new Random();
        int rand = random.nextInt(100);
        for (int foo = 0; foo < 16; ++foo) {
            int ax = random.nextInt(16);
            int az = random.nextInt(16);
            int ay = random.nextInt(170) + 80;
            if (ax > 2 && ax < 14 && az > 2 && az < 14) {
                if (rand <= 5) {
                    this.asteroid_medium(primer, ax, ay, az);
                    continue;
                }
                if (rand <= 20) {
                    this.asteroid_square(primer, ax, ay, az);
                    continue;
                }
                this.asteroid_single(primer, ax, ay, az);
                continue;
            }
            this.asteroid_single(primer, ax, ay, az);
        }
        for (int var8 = 0; var8 < 16; ++var8) {
            for (int var9 = 0; var9 < 16; ++var9) {
                int var12 = (int)((double)this.noiseGen4.getNoise(var8 + par1 * 16, var9 * par2 * 16) / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int var13 = -1;
                IBlockState state0 = BLOCK_TOP;
                IBlockState state1 = BLOCK_FILL;
                for (int var16 = 127; var16 >= 0; --var16) {
                    int index = this.getIndex(var8, var16, var9);
                    if (var16 <= this.rand.nextInt(5)) {
                        primer.func_177855_a(var8, var16, var9, Blocks.field_150357_h.func_176223_P());
                        continue;
                    }
                    IBlockState var18 = primer.func_177856_a(var8, var16, var9);
                    if (Blocks.field_150350_a == var18) {
                        var13 = -1;
                        continue;
                    }
                    if (var18 != BLOCK_LOWER) continue;
                    if (var13 == -1) {
                        if (var12 <= 0) {
                            state0 = Blocks.field_150350_a.func_176223_P();
                            state1 = BLOCK_LOWER;
                        } else if (var16 >= 36 && var16 <= 21) {
                            state0 = BLOCK_FILL;
                        }
                        var13 = var12;
                        if (var16 >= 19) {
                            primer.func_177855_a(var8, var16, var9, state0);
                            continue;
                        }
                        if (var16 >= 19 || var16 < 18) continue;
                        primer.func_177855_a(var8, var16, var9, state1);
                        continue;
                    }
                    if (var13 <= 0) continue;
                    --var13;
                    primer.func_177855_a(var8, var16, var9, state1);
                }
            }
        }
    }

    private float randFromPointPos(int x, int z) {
        int n = x + z * 57;
        n ^= n << 13;
        n = n * (n * n * 15731 + 789221) + 1376312589 & 0x3FFFFFFF;
        return 1.0f - (float)n / 1.0737418E9f;
    }

    public void generateTerrain(int chunkX, int chunkZ, ChunkPrimer primer, boolean flagDataOnly) {
        this.largeAsteroids.clear();
        this.largeCount = 0;
        Random random = new Random();
        int asteroidChance = 800;
        int rangeY = 138;
        int rangeSize = 20;
        for (int i = chunkX - 3; i < chunkX + 3; ++i) {
            int minX = i * 16;
            int maxX = minX + 16;
            for (int k = chunkZ - 3; k < chunkZ + 3; ++k) {
                int minZ = k * 16;
                int maxZ = minZ + 16;
                for (int x = minX; x < maxX; x += 2) {
                    for (int z = minZ; z < maxZ; z += 2) {
                        if (!((double)this.randFromPointPos(x, z) < ((double)this.asteroidDensity.getNoise(x, z) + 0.4) / 800.0)) continue;
                        random.setSeed(x + z * 3067);
                        int y = random.nextInt(138) + 70;
                        int size = random.nextInt(20) + 5;
                        this.generateAsteroid(random, x, y, z, chunkX << 4, chunkZ << 4, size, primer, flagDataOnly);
                        ++this.largeCount;
                    }
                }
            }
        }
    }

    private final double clamp(double x, double min, double max) {
        if (x < min) {
            x = min;
        } else if (x > max) {
            x = max;
        }
        return x;
    }

    private float randFromPoint(int x, int y, int z) {
        int n = x + z * 57 + y * 571;
        n ^= n << 13;
        n = n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE;
        return 1.0f - (float)n / 1.0737418E9f;
    }

    private final void setOtherAxisFrequency(float frequency) {
        this.asteroidSkewX.frequencyY = frequency;
        this.asteroidSkewX.frequencyZ = frequency;
        this.asteroidSkewY.frequencyX = frequency;
        this.asteroidSkewY.frequencyZ = frequency;
        this.asteroidSkewZ.frequencyX = frequency;
        this.asteroidSkewZ.frequencyY = frequency;
    }

    private final int getTerrainHeightFor(float yMod, int asteroidY, int asteroidSize) {
        return (int)((float)(asteroidY - asteroidSize / 4) + yMod * 1.5f);
    }

    private void generateAsteroid(Random rand, int asteroidX, int asteroidY, int asteroidZ, int chunkX, int chunkZ, int size, ChunkPrimer primer, boolean flagDataOnly) {
        int distanceX;
        int indexXZ;
        int indexXY;
        int x;
        SpecialAsteroidBlock core = this.coreHandler.getBlock(rand, size);
        SpecialAsteroidBlock shell = null;
        if (rand.nextInt(2) == 0) {
            shell = this.shellHandler.getBlock(rand, size);
        }
        boolean isHollow = false;
        float hollowSize = rand.nextFloat() * 0.19999999f + 0.6f;
        if (rand.nextInt(10) == 0 && size >= 15) {
            isHollow = true;
            shell = new SpecialAsteroidBlock(Blocks.field_150403_cj, 0, 1, 0.15);
        }
        ((WorldProviderMoon)this.world.field_73011_w).addAsteroid(asteroidX, asteroidY, asteroidZ, size, isHollow ? -1 : core.index);
        int xMin = (int)this.clamp(Math.max(chunkX, asteroidX - size - 8 - 2) - chunkX, 0.0, 16.0);
        int zMin = (int)this.clamp(Math.max(chunkZ, asteroidZ - size - 8 - 2) - chunkZ, 0.0, 16.0);
        int yMin = asteroidY - size - 8 - 2;
        int yMax = asteroidY + size + 8 + 2;
        int xMax = (int)this.clamp(Math.min(chunkX + 16, asteroidX + size + 8 + 2) - chunkX, 0.0, 16.0);
        int zMax = (int)this.clamp(Math.min(chunkZ + 16, asteroidZ + size + 8 + 2) - chunkZ, 0.0, 16.0);
        int xSize = xMax - xMin;
        int ySize = yMax - yMin;
        int zSize = zMax - zMin;
        if (xSize <= 0 || ySize <= 0 || zSize <= 0) {
            return;
        }
        float noiseOffsetX = this.randFromPoint(asteroidX, asteroidY, asteroidZ) * 256.0f + (float)chunkX;
        float noiseOffsetY = this.randFromPoint(asteroidX * 7, asteroidY * 11, asteroidZ * 13) * 256.0f;
        float noiseOffsetZ = this.randFromPoint(asteroidX * 17, asteroidY * 23, asteroidZ * 29) * 256.0f + (float)chunkZ;
        this.setOtherAxisFrequency(1.0f / ((float)size * 2.0f / 2.0f));
        float[] sizeXArray = new float[ySize * zSize];
        float[] sizeZArray = new float[xSize * ySize];
        float[] sizeYArray = new float[xSize * zSize];
        for (int x2 = 0; x2 < xSize; ++x2) {
            int xx = x2 * zSize;
            float xxx = (float)x2 + noiseOffsetX;
            for (int z = 0; z < zSize; ++z) {
                sizeYArray[xx + z] = this.asteroidSkewY.getNoise(xxx, (float)z + noiseOffsetZ);
            }
        }
        AsteroidData asteroidData = new AsteroidData(isHollow, sizeYArray, xMin, zMin, xMax, zMax, zSize, size, asteroidX, asteroidY, asteroidZ);
        this.largeAsteroids.add(asteroidData);
        this.largeAsteroidsLastChunkX = chunkX;
        this.largeAsteroidsLastChunkZ = chunkZ;
        if (flagDataOnly) {
            return;
        }
        for (int y = 0; y < ySize; ++y) {
            int yy = y * zSize;
            float yyy = (float)y + noiseOffsetY;
            for (int z = 0; z < zSize; ++z) {
                sizeXArray[yy + z] = this.asteroidSkewX.getNoise(yyy, (float)z + noiseOffsetZ);
            }
        }
        for (int x3 = 0; x3 < xSize; ++x3) {
            int xx = x3 * ySize;
            float xxx = (float)x3 + noiseOffsetX;
            for (int y = 0; y < ySize; ++y) {
                sizeZArray[xx + y] = this.asteroidSkewZ.getNoise(xxx, (float)y + noiseOffsetY);
            }
        }
        double shellThickness = 0.0;
        int terrainY = 0;
        int terrainYY = 0;
        IBlockState asteroidShell = null;
        if (shell != null) {
            asteroidShell = shell.block.func_176203_a((int)shell.meta);
            shellThickness = 1.0 - shell.thickness;
        }
        IBlockState asteroidCore = core.block.func_176203_a((int)core.meta);
        this.getClass();
        IBlockState asteroidRock0 = this.ASTEROID_STONE.func_176203_a(0);
        IBlockState asteroidRock1 = this.ASTEROID_STONE.func_176203_a(this.ASTEROID_STONE_META_1);
        IBlockState airBlock = Blocks.field_150350_a.func_176223_P();
        this.getClass();
        IBlockState dirtBlock = this.DIRT.func_176203_a(0);
        this.getClass();
        IBlockState grassBlock = this.GRASS.func_176203_a(0);
        for (x = xMax - 1; x >= xMin; --x) {
            indexXY = (x - xMin) * ySize - yMin;
            indexXZ = (x - xMin) * zSize - zMin;
            distanceX = asteroidX - (x + chunkX);
            int indexBaseX = x * 128 << 4;
            float xx = x + chunkX;
            for (int z = zMin; z < zMax; ++z) {
                if (isHollow) {
                    float sizeModY = sizeYArray[indexXZ + z];
                    terrainY = this.getTerrainHeightFor(sizeModY, asteroidY, size);
                    terrainYY = this.getTerrainHeightFor(sizeModY, asteroidY - 1, size);
                }
                float sizeY = (float)size + sizeYArray[indexXZ + z];
                sizeY *= sizeY;
                int distanceZ = asteroidZ - (z + chunkZ);
                int indexBase = indexBaseX | z * 128;
                float zz = z + chunkZ;
                for (int y = yMin; y < yMax; ++y) {
                    int index;
                    float distance;
                    float dSizeX = (float)distanceX / ((float)size + sizeXArray[(y - yMin) * zSize + z - zMin]);
                    float dSizeZ = (float)distanceZ / ((float)size + sizeZArray[indexXY + y]);
                    dSizeX *= dSizeX;
                    dSizeZ *= dSizeZ;
                    int distanceY = asteroidY - y;
                    distanceY *= distanceY;
                    float distanceAbove = distance = dSizeX + (float)distanceY / sizeY + dSizeZ;
                    distance += this.asteroidTurbulance.getNoise(xx, y, zz);
                    if (isHollow && distance <= hollowSize && (distanceAbove += this.asteroidTurbulance.getNoise(xx, y + 1, zz)) <= 1.0f && y - 1 == terrainYY) {
                        index = indexBase | y + 1;
                        this.getClass();
                        primer.func_177855_a(x, y + 1, z, this.LIGHT.func_176203_a(0));
                    }
                    if (!(distance <= 1.0f)) continue;
                    index = indexBase | y;
                    if (isHollow && distance <= hollowSize) {
                        if (y == terrainY) {
                            primer.func_177855_a(x, y, z, grassBlock);
                            continue;
                        }
                        if (y < terrainY) {
                            primer.func_177855_a(x, y, z, dirtBlock);
                            continue;
                        }
                        if (primer.func_177856_a(x, y, z).func_177230_c() == GCBlocks.fallenMeteor.func_176223_P()) continue;
                        primer.func_177855_a(x, y, z, airBlock);
                        continue;
                    }
                    if ((double)distance <= core.thickness) {
                        if (rand.nextBoolean()) {
                            primer.func_177855_a(x, y, z, asteroidCore);
                            continue;
                        }
                        primer.func_177855_a(x, y, z, asteroidRock0);
                        continue;
                    }
                    if (shell != null && (double)distance >= shellThickness) {
                        primer.func_177855_a(x, y, z, asteroidShell);
                        continue;
                    }
                    primer.func_177855_a(x, y, z, asteroidRock1);
                }
            }
        }
        if (isHollow) {
            shellThickness = 0.0;
            if (shell != null) {
                shellThickness = 1.0 - shell.thickness;
            }
            for (x = xMin; x < xMax; ++x) {
                indexXY = (x - xMin) * ySize - yMin;
                indexXZ = (x - xMin) * zSize - zMin;
                distanceX = asteroidX - (x + chunkX);
                distanceX *= distanceX;
                for (int z = zMin; z < zMax; ++z) {
                    float sizeModY = sizeYArray[indexXZ + z];
                    float sizeY = (float)size + sizeYArray[indexXZ + z];
                    sizeY *= sizeY;
                    int distanceZ = asteroidZ - (z + chunkZ);
                    distanceZ *= distanceZ;
                    for (int y = yMin; y < yMax; ++y) {
                        float sizeX = (float)size + sizeXArray[(y - yMin) * zSize + z - zMin];
                        float sizeZ = (float)size + sizeZArray[indexXY + y];
                        sizeX *= sizeX;
                        sizeZ *= sizeZ;
                        int distanceY = asteroidY - y;
                        distanceY *= distanceY;
                        float distance = (float)distanceX / sizeX + (float)distanceY / sizeY + (float)distanceZ / sizeZ;
                        if (!((distance += this.asteroidTurbulance.getNoise(x + chunkX, y, z + chunkZ)) <= 1.0f)) continue;
                        IBlockState state = primer.func_177856_a(x, y, z);
                        IBlockState stateAbove = primer.func_177856_a(x, y + 1, z);
                        if (Blocks.field_150350_a != stateAbove.func_177230_c() || state.func_177230_c() != this.ASTEROID_STONE && state.func_177230_c() != this.GRASS || this.rand.nextInt(20) != 0) continue;
                        primer.func_177855_a(x, y + 1, z, GCBlocks.fallenMeteor.func_176223_P());
                        this.getClass();
                        primer.func_177855_a(x, y, z, this.LIGHT.func_176203_a(0));
                    }
                }
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.setBlocksInChunk(x, z, chunkprimer);
        this.createCraters(x, z, chunkprimer);
        this.replaceBlocksForBiome(x, z, chunkprimer, null);
        this.generateTerrain(x, z, chunkprimer, false);
        this.dungeonGeneratorMoon.func_186125_a(this.world, x, z, chunkprimer);
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        byte b = (byte)Biome.func_185362_a((Biome)BiomeAdaptive.biomeDefault);
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = b;
        }
        chunk.func_76603_b();
        return chunk;
    }

    private void createCraters(int chunkX, int chunkZ, ChunkPrimer primer) {
        for (int cx = chunkX - 2; cx <= chunkX + 2; ++cx) {
            for (int cz = chunkZ - 2; cz <= chunkZ + 2; ++cz) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        if (!(Math.abs(this.randFromPoint(cx * 16 + x, (cz * 16 + z) * 1000)) < (double)(this.noiseGen4.getNoise(x * 16 + x, cz * 16 + z) / 300.0f))) continue;
                        Random random = new Random(cx * 16 + x + (cz * 16 + z) * 5000);
                        EnumCraterSize cSize = EnumCraterSize.sizeArray[random.nextInt(EnumCraterSize.sizeArray.length)];
                        int size = random.nextInt(cSize.MAX_SIZE - cSize.MIN_SIZE) + cSize.MIN_SIZE;
                        this.makeCrater(cx * 16 + x, cz * 16 + z, chunkX * 16, chunkZ * 16, size, primer);
                    }
                }
            }
        }
    }

    private void makeCrater(int craterX, int craterZ, int chunkX, int chunkZ, int size, ChunkPrimer primer) {
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                double xDev = craterX - (chunkX + x);
                double zDev = craterZ - (chunkZ + z);
                if (!(xDev * xDev + zDev * zDev < (double)(size * size))) continue;
                double sqrtY = (xDev /= (double)size) * xDev + (zDev /= (double)size) * zDev;
                double yDev = sqrtY * sqrtY * 6.0;
                yDev = 5.0 - yDev;
                int helper = 0;
                for (int y = 127; y > 0; --y) {
                    if (Blocks.field_150350_a != primer.func_177856_a(x, y, z).func_177230_c() && (double)helper <= yDev) {
                        primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
                        ++helper;
                    }
                    if ((double)helper > yDev) continue block1;
                }
            }
        }
    }

    private int getIndex(int x, int y, int z) {
        return (x * 16 + z) * 256 + y;
    }

    private double randFromPoint(int x, int z) {
        int n = x + z * 57;
        n = n << 13 ^ n;
        return 1.0 - (double)(n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) / 1.073741824E9;
    }

    public void func_185931_b(int x, int z) {
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biomegenbase = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * k + (long)z * l ^ this.world.func_72905_C());
        this.dungeonGeneratorMoon.func_175794_a(this.world, this.rand, new ChunkPos(x, z));
        biomegenbase.func_180624_a(this.world, this.rand, new BlockPos(i, 0, j));
        BlockFalling.field_149832_M = false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biomegenbase = this.world.func_180494_b(pos);
        return biomegenbase.func_76747_a(creatureType);
    }

    public void func_180514_a(Chunk chunk, int x, int z) {
        if (!ConfigManagerCore.disableMoonVillageGen) {
            this.villageGenerator.func_186125_a(this.world, x, z, null);
        }
        this.dungeonGeneratorMoon.func_186125_a(this.world, x, z, null);
    }

    private class AsteroidData {
        public boolean isHollow;
        public float[] sizeYArray;
        public int xMinArray;
        public int zMinArray;
        public int xMax;
        public int zMax;
        public int zSizeArray;
        public int asteroidSizeArray;
        public int asteroidXArray;
        public int asteroidYArray;
        public int asteroidZArray;

        public AsteroidData(boolean hollow, float[] sizeYArray2, int xMin, int zMin, int xmax, int zmax, int zSize, int size, int asteroidX, int asteroidY, int asteroidZ) {
            this.isHollow = hollow;
            this.sizeYArray = (float[])sizeYArray2.clone();
            this.xMinArray = xMin;
            this.zMinArray = zMin;
            this.xMax = xmax;
            this.zMax = zmax;
            this.zSizeArray = zSize;
            this.asteroidSizeArray = size;
            this.asteroidXArray = asteroidX;
            this.asteroidYArray = asteroidY;
            this.asteroidZArray = asteroidZ;
        }
    }
}

