/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.world.gen;

import com.google.common.base.Predicate;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.event.wgen.GCCoreEventPopulate;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockBasicMoon;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.world.gen.WorldGenMinableMeta;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BiomeDecoratorMoon
extends BiomeDecorator {
    private final WorldGenerator dirtGen;
    private final WorldGenerator cheeseGen;
    private final WorldGenerator copperGen = new WorldGenMinableMeta(GCBlocks.blockMoon, 4, 0, true, GCBlocks.blockMoon, 4);
    private final WorldGenerator tinGen = new WorldGenMinableMeta(GCBlocks.blockMoon, 4, 1, true, GCBlocks.blockMoon, 4);
    private World world;
    private Random randomGenerator;

    public BiomeDecoratorMoon() {
        this.cheeseGen = new WorldGenMinableMeta(GCBlocks.blockMoon, 3, 2, true, GCBlocks.blockMoon, 4);
        this.dirtGen = new WorldGenMinableMeta(GCBlocks.blockMoon, 32, 3, true, GCBlocks.blockMoon, 4);
    }

    public void func_180292_a(World worldIn, Random random, Biome p_180292_3_, BlockPos pos) {
        if (this.world != null) {
            throw new RuntimeException("Already decorating!!");
        }
        this.world = worldIn;
        this.randomGenerator = random;
        this.field_180294_c = pos;
        this.generateMoon();
        this.world = null;
        this.randomGenerator = null;
    }

    private void genStandardOre(int amountPerChunk, WorldGenerator worldGenerator, int minY, int maxY) {
        for (int var5 = 0; var5 < amountPerChunk; ++var5) {
            BlockPos blockpos = this.field_180294_c.func_177982_a(this.randomGenerator.nextInt(16), this.randomGenerator.nextInt(maxY - minY) + minY, this.randomGenerator.nextInt(16));
            worldGenerator.func_180709_b(this.world, this.randomGenerator, blockpos);
        }
    }

    private void generateMoon() {
        MinecraftForge.EVENT_BUS.post((Event)new GCCoreEventPopulate.Pre(this.world, this.randomGenerator, this.field_180294_c));
        this.genStandardOre(20, this.dirtGen, 0, 200);
        if (!ConfigManagerCore.disableCopperMoon) {
            this.genStandardOre(26, this.copperGen, 0, 60);
        }
        if (!ConfigManagerCore.disableTinMoon) {
            this.genStandardOre(23, this.tinGen, 0, 60);
        }
        if (!ConfigManagerCore.disableCheeseMoon) {
            this.genStandardOre(14, this.cheeseGen, 0, 85);
        }
        if (!ConfigManagerCore.disableSapphireMoon) {
            int count = 3 + this.randomGenerator.nextInt(6);
            IBlockState sapphire = GCBlocks.blockMoon.func_176223_P().func_177226_a(BlockBasicMoon.BASIC_TYPE_MOON, (Comparable)((Object)BlockBasicMoon.EnumBlockBasicMoon.ORE_SAPPHIRE));
            for (int i = 0; i < count; ++i) {
                BlockPos blockpos = this.field_180294_c.func_177982_a(this.randomGenerator.nextInt(16) + 8, this.randomGenerator.nextInt(28) + 4, this.randomGenerator.nextInt(16) + 8);
                IBlockState toReplace = this.world.func_180495_p(blockpos);
                if (toReplace.func_177230_c() != GCBlocks.blockMoon || !toReplace.func_177230_c().isReplaceableOreGen(toReplace, (IBlockAccess)this.world, blockpos, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b))) continue;
                this.world.func_180501_a(blockpos, sapphire, 2);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new GCCoreEventPopulate.Post(this.world, this.randomGenerator, this.field_180294_c));
    }
}

