/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.world;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.world.IChunkLoader;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.config.Configuration;

public class ChunkLoadingCallback
implements ForgeChunkManager.LoadingCallback {
    private static final HashMap<String, HashMap<Integer, HashSet<BlockPos>>> chunkLoaderList = new HashMap();
    private static boolean loaded;
    private static boolean configLoaded;
    private static Configuration config;
    private static boolean loadOnLogin;
    private static boolean dirtyData;

    public static void loadConfig(File file) {
        if (!configLoaded) {
            config = new Configuration(file);
        }
        try {
            loadOnLogin = config.get("CHUNKLOADING", "LoadOnLogin", true, "If you don't want each player's chunks to load when they log in, set to false.").getBoolean(true);
        }
        catch (Exception e) {
            GCLog.severe("Problem loading chunkloading config (\"core.conf\")");
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
            configLoaded = true;
        }
    }

    public static void addToList(World world, int x, int y, int z, String playerName) {
        HashSet<Object> chunkLoaders;
        HashMap<Integer, HashSet<Object>> dimensionMap = chunkLoaderList.get(playerName);
        if (dimensionMap == null) {
            dimensionMap = new HashMap();
            chunkLoaderList.put(playerName, dimensionMap);
        }
        if ((chunkLoaders = dimensionMap.get(world.field_73011_w.getDimension())) == null) {
            chunkLoaders = new HashSet();
        }
        chunkLoaders.add(new BlockPos(x, y, z));
        dimensionMap.put(GCCoreUtil.getDimensionID(world), chunkLoaders);
        chunkLoaderList.put(playerName, dimensionMap);
        dirtyData = true;
    }

    public static void forceChunk(ForgeChunkManager.Ticket ticket, World world, int x, int y, int z, String playerName) {
        ChunkLoadingCallback.addToList(world, x, y, z, playerName);
        ChunkPos chunkPos = new ChunkPos(x >> 4, z >> 4);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunkPos);
    }

    public static void save(WorldServer world) {
        if (!dirtyData) {
            return;
        }
        File saveDir = ChunkLoadingCallback.getSaveDir();
        if (saveDir != null) {
            File saveFile = new File(saveDir, "chunkloaders.dat");
            if (!saveFile.exists()) {
                try {
                    if (!saveFile.createNewFile()) {
                        GCLog.severe("Could not create chunk loader data file: " + saveFile.getAbsolutePath());
                    }
                }
                catch (IOException e) {
                    GCLog.severe("Could not create chunk loader data file: " + saveFile.getAbsolutePath());
                    e.printStackTrace();
                }
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(saveFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            if (fos != null) {
                DataOutputStream dataStream = new DataOutputStream(fos);
                try {
                    dataStream.writeInt(chunkLoaderList.size());
                    for (Map.Entry<String, HashMap<Integer, HashSet<BlockPos>>> playerEntry : chunkLoaderList.entrySet()) {
                        dataStream.writeUTF(playerEntry.getKey());
                        dataStream.writeInt(playerEntry.getValue().size());
                        for (Map.Entry<Integer, HashSet<BlockPos>> dimensionEntry : playerEntry.getValue().entrySet()) {
                            dataStream.writeInt(dimensionEntry.getKey());
                            dataStream.writeInt(dimensionEntry.getValue().size());
                            for (BlockPos coords : dimensionEntry.getValue()) {
                                dataStream.writeInt(coords.func_177958_n());
                                dataStream.writeInt(coords.func_177956_o());
                                dataStream.writeInt(coords.func_177952_p());
                            }
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    dataStream.close();
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        dirtyData = false;
    }

    private static File getSaveDir() {
        if (DimensionManager.getWorld((int)0) != null) {
            File saveDir = new File(DimensionManager.getCurrentSaveRootDirectory(), "galacticraft");
            if (!saveDir.exists() && !saveDir.mkdirs()) {
                GCLog.severe("Could not create chunk loader save data folder: " + saveDir.getAbsolutePath());
            }
            return saveDir;
        }
        return null;
    }

    public static void load(WorldServer world) {
        block11: {
            if (loaded) {
                return;
            }
            FilterInputStream dataStream = null;
            try {
                File saveDir = ChunkLoadingCallback.getSaveDir();
                if (saveDir != null) {
                    File saveFile;
                    if (!saveDir.exists() && !saveDir.mkdirs()) {
                        GCLog.severe("Could not create chunk loader save data folder: " + saveDir.getAbsolutePath());
                    }
                    if ((saveFile = new File(saveDir, "chunkloaders.dat")).exists()) {
                        dataStream = new DataInputStream(new FileInputStream(saveFile));
                        int playerCount = ((DataInputStream)dataStream).readInt();
                        for (int l = 0; l < playerCount; ++l) {
                            String ownerName = ((DataInputStream)dataStream).readUTF();
                            int mapSize = ((DataInputStream)dataStream).readInt();
                            HashMap dimensionMap = new HashMap();
                            for (int i = 0; i < mapSize; ++i) {
                                int dimensionID = ((DataInputStream)dataStream).readInt();
                                HashSet<BlockPos> coords = new HashSet<BlockPos>();
                                dimensionMap.put(dimensionID, coords);
                                int coordSetSize = ((DataInputStream)dataStream).readInt();
                                for (int j = 0; j < coordSetSize; ++j) {
                                    coords.add(new BlockPos(((DataInputStream)dataStream).readInt(), ((DataInputStream)dataStream).readInt(), ((DataInputStream)dataStream).readInt()));
                                }
                            }
                            chunkLoaderList.put(ownerName, dimensionMap);
                        }
                        dataStream.close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (dataStream == null) break block11;
                try {
                    dataStream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        loaded = true;
        dirtyData = false;
    }

    public static void onPlayerLogin(EntityPlayer player) {
        for (Map.Entry<String, HashMap<Integer, HashSet<BlockPos>>> playerEntry : chunkLoaderList.entrySet()) {
            if (!PlayerUtil.getName(player).equals(playerEntry.getKey())) continue;
            for (Map.Entry<Integer, HashSet<BlockPos>> dimensionEntry : playerEntry.getValue().entrySet()) {
                int dimID = dimensionEntry.getKey();
                if (!loadOnLogin) continue;
                player.field_70170_p.func_73046_m().func_71218_a(dimID);
            }
        }
    }

    public static void onPlayerLogout(EntityPlayer player) {
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            int tileZ;
            int tileY;
            int tileX;
            TileEntity tile;
            NBTTagCompound nbt = ticket.getModData();
            if (nbt == null || !((tile = world.func_175625_s(new BlockPos(tileX = nbt.func_74762_e("ChunkLoaderTileX"), tileY = nbt.func_74762_e("ChunkLoaderTileY"), tileZ = nbt.func_74762_e("ChunkLoaderTileZ")))) instanceof IChunkLoader)) continue;
            ((IChunkLoader)tile).onTicketLoaded(ticket, false);
        }
    }
}

