/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.entity.IAntiGrav;
import micdoodle8.mods.galacticraft.api.entity.IWorldTransferCallback;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.recipe.SpaceStationRecipe;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.api.world.SpaceStationType;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.dimension.SpaceStationWorldData;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.entities.EntityCelestialFake;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerHandler;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.items.ItemParaChute;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTelemetry;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.planets.venus.dimension.WorldProviderVenus;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.server.permission.PermissionAPI;
import org.apache.commons.lang3.ArrayUtils;

public class WorldUtil {
    public static HashMap<Integer, Integer> registeredSpaceStations;
    public static Map<Integer, String> dimNames;
    public static Map<EntityPlayerMP, HashMap<String, Integer>> celestialMapCache;
    public static List<Integer> registeredPlanets;

    public static float getGravityFactor(Entity entity) {
        if (entity.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            IGalacticraftWorldProvider customProvider = (IGalacticraftWorldProvider)entity.field_70170_p.field_73011_w;
            float returnValue = MathHelper.func_76129_c((float)(0.08f / (0.08f - customProvider.getGravity())));
            if (returnValue > 2.5f) {
                returnValue = 2.5f;
            }
            if (returnValue < 0.75f) {
                returnValue = 0.75f;
            }
            return returnValue;
        }
        if (entity instanceof IAntiGrav) {
            return 1.0f;
        }
        return 1.0f;
    }

    public static Vector3 getWorldColor(World world) {
        if (GalacticraftCore.isPlanetsLoaded && world.field_73011_w instanceof WorldProviderVenus) {
            return new Vector3(1.0, 0.8f, 0.6f);
        }
        return new Vector3(1.0, 1.0, 1.0);
    }

    public static WorldProvider getProviderForNameServer(String par1String) {
        String nameToFind = par1String;
        if (par1String.contains("$")) {
            String[] twoDimensions = par1String.split("\\$");
            nameToFind = twoDimensions[0];
        }
        if (nameToFind == null) {
            return null;
        }
        for (Map.Entry<Integer, String> element : dimNames.entrySet()) {
            if (!nameToFind.equalsIgnoreCase(element.getValue())) continue;
            return WorldUtil.getProviderForDimensionServer(element.getKey());
        }
        GCLog.info("Failed to find matching world for '" + par1String + "'");
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static WorldProvider getProviderForNameClient(String par1String) {
        String nameToFind = par1String;
        if (par1String.contains("$")) {
            String[] twoDimensions = par1String.split("\\$");
            nameToFind = twoDimensions[0];
        }
        if (nameToFind == null) {
            return null;
        }
        for (Map.Entry<Integer, String> element : dimNames.entrySet()) {
            if (!nameToFind.equalsIgnoreCase(element.getValue())) continue;
            return WorldUtil.getProviderForDimensionClient(element.getKey());
        }
        GCLog.info("Failed to find matching world for '" + par1String + "'");
        return null;
    }

    public static void initialiseDimensionNames() {
        WorldProvider provider = WorldUtil.getProviderForDimensionServer(ConfigManagerCore.idDimensionOverworld);
        dimNames.put(ConfigManagerCore.idDimensionOverworld, provider.func_186058_p().func_186065_b());
    }

    public static List<Integer> getPossibleDimensionsForSpaceshipTier(int tier, EntityPlayerMP playerBase) {
        ArrayList<Integer> temp = new ArrayList<Integer>();
        if (!ConfigManagerCore.disableRocketsToOverworld) {
            temp.add(ConfigManagerCore.idDimensionOverworld);
        }
        for (Integer element : registeredPlanets) {
            WorldProvider provider;
            if (element == ConfigManagerCore.idDimensionOverworld || (provider = WorldUtil.getProviderForDimensionServer(element)) == null) continue;
            if (provider instanceof IGalacticraftWorldProvider) {
                if (!((IGalacticraftWorldProvider)provider).canSpaceshipTierPass(tier)) continue;
                temp.add(element);
                continue;
            }
            temp.add(element);
        }
        for (Integer element : registeredSpaceStations.keySet()) {
            WorldProvider homeWorld;
            SpaceStationWorldData data = SpaceStationWorldData.getStationData(playerBase.field_70170_p, element, null);
            if (ConfigManagerCore.spaceStationsRequirePermission && !data.getAllowedAll() && !data.getAllowedPlayers().contains(PlayerUtil.getName((EntityPlayer)playerBase)) && !ArrayUtils.contains((Object[])playerBase.field_71133_b.func_184103_al().func_152606_n(), (Object)playerBase.func_70005_c_())) continue;
            if (playerBase != null) {
                SpaceStationWorldData dataCurrent;
                int currentWorld = playerBase.field_71093_bK;
                if (currentWorld == data.getHomePlanet()) {
                    temp.add(element);
                    continue;
                }
                if (playerBase.field_70170_p.field_73011_w instanceof IOrbitDimension && (dataCurrent = SpaceStationWorldData.getStationData(playerBase.field_70170_p, playerBase.field_71093_bK, null)).getHomePlanet() == data.getHomePlanet()) {
                    temp.add(element);
                    continue;
                }
            }
            if ((homeWorld = WorldUtil.getProviderForDimensionServer(data.getHomePlanet())) == null) continue;
            if (homeWorld instanceof IGalacticraftWorldProvider) {
                if (!((IGalacticraftWorldProvider)homeWorld).canSpaceshipTierPass(tier)) continue;
                temp.add(element);
                continue;
            }
            temp.add(element);
        }
        return temp;
    }

    public static CelestialBody getReachableCelestialBodiesForDimensionID(int id) {
        ArrayList celestialBodyList = Lists.newArrayList();
        celestialBodyList.addAll(GalaxyRegistry.getRegisteredMoons().values());
        celestialBodyList.addAll(GalaxyRegistry.getRegisteredPlanets().values());
        celestialBodyList.addAll(GalaxyRegistry.getRegisteredSatellites().values());
        for (CelestialBody cBody : celestialBodyList) {
            if (!cBody.getReachable() || cBody.getDimensionID() != id) continue;
            return cBody;
        }
        return null;
    }

    public static CelestialBody getReachableCelestialBodiesForName(String name) {
        ArrayList celestialBodyList = Lists.newArrayList();
        celestialBodyList.addAll(GalaxyRegistry.getRegisteredMoons().values());
        celestialBodyList.addAll(GalaxyRegistry.getRegisteredPlanets().values());
        celestialBodyList.addAll(GalaxyRegistry.getRegisteredSatellites().values());
        for (CelestialBody cBody : celestialBodyList) {
            if (!cBody.getReachable() || !cBody.getName().equals(name)) continue;
            return cBody;
        }
        return null;
    }

    public static World getWorldForDimensionServer(int id) {
        MinecraftServer theServer = GCCoreUtil.getServer();
        if (theServer == null) {
            GCLog.debug("Called WorldUtil server side method but FML returned no server - is this a bug?");
            return null;
        }
        return theServer.func_71218_a(id);
    }

    public static WorldProvider getProviderForDimensionServer(int id) {
        World ws = WorldUtil.getWorldForDimensionServer(id);
        if (ws != null) {
            return ws.field_73011_w;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static WorldProvider getProviderForDimensionClient(int id) {
        WorldClient ws = ClientProxyCore.mc.field_71441_e;
        if (ws != null && GCCoreUtil.getDimensionID((World)ws) == id) {
            return ws.field_73011_w;
        }
        return DimensionManager.createProviderFor((int)id);
    }

    public static HashMap<String, Integer> getArrayOfPossibleDimensions(int tier, EntityPlayerMP playerBase) {
        List<Integer> ids = WorldUtil.getPossibleDimensionsForSpaceshipTier(tier, playerBase);
        HashMap<String, Integer> map = new HashMap<String, Integer>(ids.size(), 1.0f);
        for (Integer id : ids) {
            CelestialBody celestialBody = WorldUtil.getReachableCelestialBodiesForDimensionID(id);
            if (id > 0 && celestialBody == null) {
                celestialBody = GalacticraftCore.satelliteSpaceStation;
                if (playerBase == null) continue;
                SpaceStationWorldData data = SpaceStationWorldData.getStationData(playerBase.field_70170_p, id, null);
                map.put(celestialBody.getName() + "$" + data.getOwner() + "$" + data.getSpaceStationName() + "$" + id + "$" + data.getHomePlanet(), id);
                continue;
            }
            if (celestialBody == GalacticraftCore.planetOverworld) {
                map.put(celestialBody.getName(), id);
                continue;
            }
            WorldProvider provider = WorldUtil.getProviderForDimensionServer(id);
            if (celestialBody == null || provider == null || (!(provider instanceof IGalacticraftWorldProvider) || provider instanceof IOrbitDimension) && GCCoreUtil.getDimensionID(provider) != 0) continue;
            map.put(celestialBody.getName(), GCCoreUtil.getDimensionID(provider));
        }
        ArrayList<CelestialBody> cBodyList = new ArrayList<CelestialBody>();
        cBodyList.addAll(GalaxyRegistry.getRegisteredPlanets().values());
        cBodyList.addAll(GalaxyRegistry.getRegisteredMoons().values());
        for (CelestialBody body : cBodyList) {
            if (body.getReachable()) continue;
            map.put(body.getLocalizedName() + "*", body.getDimensionID());
        }
        celestialMapCache.put(playerBase, map);
        return map;
    }

    public static HashMap<String, Integer> getArrayOfPossibleDimensionsAgain(int tier, EntityPlayerMP playerBase) {
        HashMap<String, Integer> map = celestialMapCache.get(playerBase);
        if (map != null) {
            return map;
        }
        return WorldUtil.getArrayOfPossibleDimensions(tier, playerBase);
    }

    public static void unregisterSpaceStations() {
        if (registeredSpaceStations != null) {
            for (Integer registeredID : registeredSpaceStations.keySet()) {
                DimensionManager.unregisterDimension((int)registeredID);
            }
            registeredSpaceStations = null;
        }
    }

    public static void registerSpaceStations(MinecraftServer theServer, File spaceStationList) {
        registeredSpaceStations = Maps.newHashMap();
        if (theServer == null || !spaceStationList.exists() && !spaceStationList.isDirectory()) {
            return;
        }
        File[] var2 = spaceStationList.listFiles();
        if (var2 != null) {
            for (File var5 : var2) {
                if (!var5.getName().startsWith("spacestation_") || !var5.getName().endsWith(".dat")) continue;
                try {
                    String name = var5.getName();
                    SpaceStationWorldData worldDataTemp = new SpaceStationWorldData(name);
                    name = name.substring(13, name.length() - 4);
                    int registeredID = Integer.parseInt(name);
                    FileInputStream fileinputstream = new FileInputStream(var5);
                    NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                    fileinputstream.close();
                    worldDataTemp.func_76184_a(nbttagcompound.func_74775_l("data"));
                    int id = Arrays.binarySearch(ConfigManagerCore.staticLoadDimensions, registeredID);
                    int providerID = id >= 0 ? worldDataTemp.getDimensionIdStatic() : worldDataTemp.getDimensionIdDynamic();
                    boolean registrationOK = false;
                    if (!DimensionManager.isDimensionRegistered((int)registeredID)) {
                        DimensionManager.registerDimension((int)registeredID, (DimensionType)WorldUtil.getDimensionTypeById(providerID));
                        registrationOK = true;
                    } else if (GalacticraftRegistry.isDimensionTypeIDRegistered(providerID)) {
                        boolean bl = registrationOK = DimensionManager.getProviderType((int)id).func_186068_a() == providerID;
                        if (!registrationOK) {
                            try {
                                Class<?> sponge = Class.forName("org.spongepowered.common.world.WorldManager");
                                Field dtDI = sponge.getDeclaredField("dimensionTypeByDimensionId");
                                dtDI.setAccessible(true);
                                Int2ObjectMap result = (Int2ObjectMap)dtDI.get(null);
                                if (result != null) {
                                    result.put(id, (Object)WorldUtil.getDimensionTypeById(providerID));
                                    GCLog.info("Re-registered dimension type " + providerID);
                                }
                                registrationOK = true;
                            }
                            catch (ClassNotFoundException sponge) {
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (registrationOK) {
                        registeredSpaceStations.put(registeredID, providerID);
                        if (id >= 0) {
                            theServer.func_71218_a(registeredID);
                        }
                        dimNames.put(registeredID, "Space Station " + registeredID);
                        continue;
                    }
                    GCLog.severe("Dimension already registered to another mod: unable to register space station dimension " + registeredID);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean registerPlanet(int id, boolean initialiseDimensionAtServerInit, int defaultID) {
        if (registeredPlanets == null) {
            registeredPlanets = new ArrayList<Integer>();
        }
        if (initialiseDimensionAtServerInit) {
            if (!DimensionManager.isDimensionRegistered((int)id)) {
                DimensionManager.registerDimension((int)id, (DimensionType)WorldUtil.getDimensionTypeById(id));
                GCLog.info("Registered Dimension: " + id);
                registeredPlanets.add(id);
            } else if (DimensionManager.getProviderType((int)id).func_186068_a() == id && GalacticraftRegistry.isDimensionTypeIDRegistered(id)) {
                GCLog.info("Re-registered dimension: " + id);
                registeredPlanets.add(id);
            } else {
                GCLog.severe("Dimension already registered: unable to register planet dimension " + id);
                registeredPlanets.add(defaultID);
                return false;
            }
            DimensionType dt = WorldUtil.getDimensionTypeById(id);
            WorldProvider wp = dt.func_186070_d();
            dimNames.put(id, WorldUtil.getDimensionName(wp));
            return true;
        }
        registeredPlanets.add(id);
        return true;
    }

    public static void unregisterPlanets() {
        if (registeredPlanets != null) {
            for (Integer var1 : registeredPlanets) {
                DimensionManager.unregisterDimension((int)var1);
                GCLog.info("Unregistered Dimension: " + var1);
            }
            registeredPlanets = null;
        }
        dimNames.clear();
    }

    public static void registerPlanetClient(Integer dimID, int providerIndex) {
        int typeID = GalacticraftRegistry.getDimensionTypeID(providerIndex);
        if (typeID == 0) {
            GCLog.severe("Server dimension " + dimID + " has no match on client due to earlier registration problem.");
        } else if (dimID == 0) {
            GCLog.severe("Client dimension " + providerIndex + " has no match on server - probably a server dimension ID conflict problem.");
        } else if (!registeredPlanets.contains(dimID)) {
            registeredPlanets.add(dimID);
            DimensionManager.registerDimension((int)dimID, (DimensionType)WorldUtil.getDimensionTypeById(typeID));
        } else {
            GCLog.severe("Dimension already registered to another mod: unable to register planet dimension " + dimID);
        }
    }

    public static SpaceStationWorldData bindSpaceStationToNewDimension(World world, EntityPlayerMP player, int homePlanetID) {
        int dynamicProviderID = -1;
        int staticProviderID = -1;
        for (Satellite satellite : GalaxyRegistry.getRegisteredSatellites().values()) {
            if (satellite.getParentPlanet().getDimensionID() != homePlanetID) continue;
            dynamicProviderID = satellite.getDimensionID();
            staticProviderID = satellite.getDimensionIdStatic();
        }
        if (dynamicProviderID == -1 || staticProviderID == -1) {
            throw new RuntimeException("Space station being bound on bad provider IDs!");
        }
        int newID = DimensionManager.getNextFreeDimId();
        SpaceStationWorldData data = WorldUtil.createSpaceStation(world, newID, homePlanetID, dynamicProviderID, staticProviderID, player);
        dimNames.put(newID, "Space Station " + newID);
        GCPlayerStats stats = GCPlayerStats.get((Entity)player);
        stats.getSpaceStationDimensionData().put(homePlanetID, newID);
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SPACESTATION_CLIENT_ID, GCCoreUtil.getDimensionID(player.field_70170_p), new Object[]{WorldUtil.spaceStationDataToString(stats.getSpaceStationDimensionData())}), player);
        return data;
    }

    public static SpaceStationWorldData createSpaceStation(World world, int dimID, int homePlanetID, int dynamicProviderID, int staticProviderID, EntityPlayerMP player) {
        if (!DimensionManager.isDimensionRegistered((int)dimID)) {
            int id;
            if (ConfigManagerCore.keepLoadedNewSpaceStations) {
                ConfigManagerCore.setLoaded(dimID);
            }
            if ((id = Arrays.binarySearch(ConfigManagerCore.staticLoadDimensions, dimID)) >= 0) {
                DimensionManager.registerDimension((int)dimID, (DimensionType)WorldUtil.getDimensionTypeById(staticProviderID));
                registeredSpaceStations.put(dimID, staticProviderID);
            } else {
                DimensionManager.registerDimension((int)dimID, (DimensionType)WorldUtil.getDimensionTypeById(dynamicProviderID));
                registeredSpaceStations.put(dimID, dynamicProviderID);
            }
        } else {
            GCLog.severe("Dimension already registered to another mod: unable to register space station dimension " + dimID);
        }
        for (WorldServer server : world.func_73046_m().field_71305_c) {
            GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SPACESTATION_LIST, GCCoreUtil.getDimensionID((World)server), WorldUtil.getSpaceStationList()), GCCoreUtil.getDimensionID((World)server));
        }
        return SpaceStationWorldData.getStationData(world, dimID, homePlanetID, dynamicProviderID, staticProviderID, (EntityPlayer)player);
    }

    public static Entity transferEntityToDimension(Entity entity, int dimensionID, WorldServer world) {
        return WorldUtil.transferEntityToDimension(entity, dimensionID, world, true, null);
    }

    public static Entity transferEntityToDimension(Entity entity, int dimensionID, WorldServer world, boolean transferInv, EntityAutoRocket ridingRocket) {
        MinecraftServer mcServer;
        if (!world.field_72995_K && (mcServer = world.func_73046_m()) != null) {
            WorldServer var6 = mcServer.func_71218_a(dimensionID);
            if (var6 == null) {
                System.err.println("Cannot Transfer Entity to Dimension: Could not get World for Dimension " + dimensionID);
                return null;
            }
            ITeleportType type = GalacticraftRegistry.getTeleportTypeForDimension(var6.field_73011_w.getClass());
            if (type != null) {
                return WorldUtil.teleportEntity((World)var6, entity, dimensionID, type, transferInv, ridingRocket);
            }
        }
        return null;
    }

    private static Entity teleportEntity(World worldNew, Entity entity, int dimID, ITeleportType type, boolean transferInv, EntityAutoRocket ridingRocket) {
        GCPlayerStats stats;
        World worldOld;
        NBTTagCompound nbt;
        ArrayList<TileEntityTelemetry> tList;
        Entity otherRiddenEntity = null;
        if (entity.func_184187_bx() != null) {
            if (entity.func_184187_bx() instanceof EntitySpaceshipBase) {
                entity.func_184220_m(entity.func_184187_bx());
            } else if (entity.func_184187_bx() instanceof EntityCelestialFake) {
                Entity e = entity.func_184187_bx();
                e.func_184226_ay();
                e.func_70106_y();
            } else {
                otherRiddenEntity = entity.func_184187_bx();
                entity.func_184210_p();
            }
        }
        boolean dimChange = entity.field_70170_p != worldNew;
        entity.field_70170_p.func_72866_a(entity, false);
        EntityPlayerMP player = null;
        Vector3 spawnPos = null;
        int oldDimID = GCCoreUtil.getDimensionID(entity.field_70170_p);
        if (ridingRocket != null) {
            tList = ridingRocket.getTelemetry();
            nbt = new NBTTagCompound();
            ridingRocket.field_70128_L = false;
            ridingRocket.func_184226_ay();
            ridingRocket.func_70039_c(nbt);
            ((WorldServer)ridingRocket.field_70170_p).func_73039_n().func_72790_b((Entity)ridingRocket);
            WorldUtil.removeEntityFromWorld(ridingRocket.field_70170_p, ridingRocket, true);
            ridingRocket = (EntityAutoRocket)EntityList.func_75615_a((NBTTagCompound)nbt, (World)worldNew);
            if (ridingRocket != null) {
                ridingRocket.setWaitForPlayer(true);
                if (ridingRocket instanceof IWorldTransferCallback) {
                    ((IWorldTransferCallback)((Object)ridingRocket)).onWorldTransferred(worldNew);
                }
            }
        }
        if (dimChange) {
            if (entity instanceof EntityPlayerMP) {
                player = (EntityPlayerMP)entity;
                worldOld = player.field_70170_p;
                GCPlayerStats stats2 = GCPlayerStats.get((Entity)player);
                stats2.setUsingPlanetSelectionGui(false);
                player.field_71093_bK = dimID;
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info("DEBUG: Sending respawn packet to player for dim " + dimID);
                }
                player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(dimID, worldNew.func_175659_aa(), worldNew.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
                player.field_71133_b.func_184103_al().func_187243_f(player);
                if (worldNew.field_73011_w instanceof WorldProviderSpaceStation && registeredSpaceStations.containsKey(dimID)) {
                    NBTTagCompound var2 = new NBTTagCompound();
                    SpaceStationWorldData.getStationData(worldNew, dimID, (EntityPlayer)player).func_189551_b(var2);
                    GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SPACESTATION_DATA, GCCoreUtil.getDimensionID(player.field_70170_p), new Object[]{dimID, var2}), player);
                }
                WorldUtil.removeEntityFromWorld(worldOld, (Entity)player, true);
                spawnPos = ridingRocket != null ? new Vector3(ridingRocket) : type.getPlayerSpawnLocation((WorldServer)worldNew, player);
                WorldUtil.forceMoveEntityToPos(entity, (WorldServer)worldNew, spawnPos, true);
                GCLog.info("Server attempting to transfer player " + PlayerUtil.getName((EntityPlayer)player) + " to dimension " + GCCoreUtil.getDimensionID(worldNew));
                if (worldNew.field_73011_w instanceof WorldProviderSpaceStation) {
                    GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_RESET_THIRD_PERSON, GCCoreUtil.getDimensionID(worldNew), new Object[0]), player);
                }
                player.field_71075_bZ.field_75100_b = false;
                player.field_71133_b.func_184103_al().func_72375_a(player, (WorldServer)worldOld);
                player.field_71134_c.func_73080_a((WorldServer)worldNew);
                player.field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
                player.field_71133_b.func_184103_al().func_72354_b(player, (WorldServer)worldNew);
                player.field_71133_b.func_184103_al().func_72385_f(player);
                for (Object o : player.func_70651_bq()) {
                    PotionEffect var10 = (PotionEffect)o;
                    player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), var10));
                }
                player.field_71135_a.func_147359_a((Packet)new SPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
            } else {
                tList = null;
                if (entity instanceof EntitySpaceshipBase) {
                    tList = ((EntitySpaceshipBase)entity).getTelemetry();
                }
                WorldUtil.removeEntityFromWorld(entity.field_70170_p, entity, true);
                nbt = new NBTTagCompound();
                entity.field_70128_L = false;
                entity.func_70039_c(nbt);
                entity = EntityList.func_75615_a((NBTTagCompound)nbt, (World)worldNew);
                if (entity == null) {
                    return null;
                }
                if (entity instanceof IWorldTransferCallback) {
                    ((IWorldTransferCallback)entity).onWorldTransferred(worldNew);
                }
                WorldUtil.forceMoveEntityToPos(entity, (WorldServer)worldNew, new Vector3(entity), true);
                if (tList != null && tList.size() > 0) {
                    for (TileEntityTelemetry t : tList) {
                        t.addTrackedEntity(entity);
                    }
                }
            }
        } else if (entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entity;
            player.func_71053_j();
            stats = GCPlayerStats.get((Entity)player);
            stats.setUsingPlanetSelectionGui(false);
            spawnPos = ridingRocket != null ? new Vector3(ridingRocket) : type.getPlayerSpawnLocation((WorldServer)entity.field_70170_p, (EntityPlayerMP)entity);
            WorldUtil.forceMoveEntityToPos(entity, (WorldServer)worldNew, spawnPos, false);
            GCLog.info("Server attempting to transfer player " + PlayerUtil.getName((EntityPlayer)player) + " within same dimension " + GCCoreUtil.getDimensionID(worldNew));
            if (worldNew.field_73011_w instanceof WorldProviderSpaceStation) {
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_RESET_THIRD_PERSON, GCCoreUtil.getDimensionID(worldNew), new Object[0]), player);
            }
            player.field_71075_bZ.field_75100_b = false;
        }
        if (player != null) {
            stats = GCPlayerStats.get((Entity)player);
            GCPlayerHandler.setUsingParachute(player, stats, ridingRocket == null && type.useParachute() && stats.getExtendedInventory().func_70301_a(4) != null && stats.getExtendedInventory().func_70301_a(4).func_77973_b() instanceof ItemParaChute);
            if (stats.getRocketStacks() != null && !stats.getRocketStacks().isEmpty()) {
                for (int stack = 0; stack < stats.getRocketStacks().size(); ++stack) {
                    if (transferInv) {
                        if (!((ItemStack)stats.getRocketStacks().get(stack)).func_190926_b()) continue;
                        if (stack == stats.getRocketStacks().size() - 1) {
                            if (stats.getRocketItem() == null) continue;
                            stats.getRocketStacks().set(stack, (Object)new ItemStack(stats.getRocketItem(), 1, stats.getRocketType()));
                            continue;
                        }
                        if (stack != stats.getRocketStacks().size() - 2) continue;
                        ItemStack launchpad = stats.getLaunchpadStack();
                        stats.getRocketStacks().set(stack, (Object)(launchpad == null ? ItemStack.field_190927_a : launchpad));
                        stats.setLaunchpadStack(null);
                        continue;
                    }
                    stats.getRocketStacks().set(stack, (Object)ItemStack.field_190927_a);
                }
            }
            if (transferInv && stats.getChestSpawnCooldown() == 0) {
                stats.setChestSpawnVector(type.getParaChestSpawnLocation((WorldServer)entity.field_70170_p, player, new Random()));
                stats.setChestSpawnCooldown(200);
            }
        }
        if (ridingRocket != null) {
            CompatibilityManager.forceLoadChunks((WorldServer)worldNew);
            ridingRocket.field_98038_p = true;
            worldNew.func_72838_d((Entity)ridingRocket);
            ridingRocket.func_70029_a(worldNew);
            worldNew.func_72866_a((Entity)ridingRocket, true);
            CompatibilityManager.forceLoadChunksEnd((WorldServer)worldNew);
            entity.func_184220_m((Entity)ridingRocket);
            GCLog.debug("Entering rocket at : " + entity.field_70165_t + "," + entity.field_70161_v + " rocket at: " + ridingRocket.field_70165_t + "," + ridingRocket.field_70161_v);
        } else if (otherRiddenEntity != null) {
            if (dimChange) {
                worldOld = otherRiddenEntity.field_70170_p;
                NBTTagCompound nbt2 = new NBTTagCompound();
                otherRiddenEntity.func_70039_c(nbt2);
                WorldUtil.removeEntityFromWorld(worldOld, otherRiddenEntity, true);
                otherRiddenEntity = EntityList.func_75615_a((NBTTagCompound)nbt2, (World)worldNew);
                worldNew.func_72838_d(otherRiddenEntity);
                otherRiddenEntity.func_70029_a(worldNew);
            }
            otherRiddenEntity.func_70080_a(entity.field_70165_t, entity.field_70163_u - 10.0, entity.field_70161_v, otherRiddenEntity.field_70177_z, otherRiddenEntity.field_70125_A);
            worldNew.func_72866_a(otherRiddenEntity, true);
        }
        if (entity instanceof EntityPlayerMP) {
            if (dimChange) {
                FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)((EntityPlayerMP)entity), oldDimID, dimID);
            }
            type.onSpaceDimensionChanged(worldNew, (EntityPlayerMP)entity, ridingRocket != null);
        }
        return entity;
    }

    public static Entity teleportEntitySimple(World worldNew, int dimID, EntityPlayerMP player, Vector3 spawnPos) {
        if (player.func_184187_bx() != null) {
            player.func_184187_bx().func_70106_y();
            player.func_184210_p();
        }
        World worldOld = player.field_70170_p;
        int oldDimID = GCCoreUtil.getDimensionID(worldOld);
        boolean dimChange = worldOld != worldNew;
        worldOld.func_72866_a((Entity)player, false);
        if (dimChange) {
            player.field_71093_bK = dimID;
            if (ConfigManagerCore.enableDebug) {
                GCLog.info("DEBUG: Sending respawn packet to player for dim " + dimID);
            }
            player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(dimID, player.field_70170_p.func_175659_aa(), player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
            if (worldNew.field_73011_w instanceof WorldProviderSpaceStation && registeredSpaceStations.containsKey(dimID)) {
                NBTTagCompound var2 = new NBTTagCompound();
                SpaceStationWorldData.getStationData(worldNew, dimID, (EntityPlayer)player).func_189551_b(var2);
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SPACESTATION_DATA, GCCoreUtil.getDimensionID(player.field_70170_p), new Object[]{dimID, var2}), player);
            }
            WorldUtil.removeEntityFromWorld(worldOld, (Entity)player, true);
            WorldUtil.forceMoveEntityToPos((Entity)player, (WorldServer)worldNew, spawnPos, true);
            GCLog.info("Server attempting to transfer player " + PlayerUtil.getName((EntityPlayer)player) + " to dimension " + GCCoreUtil.getDimensionID(worldNew));
            player.field_71133_b.func_184103_al().func_72375_a(player, (WorldServer)worldOld);
            player.field_71134_c.func_73080_a((WorldServer)worldNew);
            player.field_71133_b.func_184103_al().func_72354_b(player, (WorldServer)worldNew);
            player.field_71133_b.func_184103_al().func_72385_f(player);
            for (Object o : player.func_70651_bq()) {
                PotionEffect var10 = (PotionEffect)o;
                player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), var10));
            }
            player.field_71135_a.func_147359_a((Packet)new SPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
            FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, oldDimID, dimID);
        } else {
            WorldUtil.forceMoveEntityToPos((Entity)player, (WorldServer)worldNew, spawnPos, false);
            GCLog.info("Server attempting to transfer player " + PlayerUtil.getName((EntityPlayer)player) + " within same dimension " + GCCoreUtil.getDimensionID(worldNew));
        }
        player.field_71075_bZ.field_75100_b = false;
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_RESET_THIRD_PERSON, GCCoreUtil.getDimensionID(player.field_70170_p), new Object[0]), player);
        GCPlayerStats stats = GCPlayerStats.get((Entity)player);
        GCPlayerHandler.setUsingParachute(player, stats, false);
        return player;
    }

    public static void forceMoveEntityToPos(Entity entity, WorldServer worldNew, Vector3 spawnPos, boolean spawnRequired) {
        CompatibilityManager.forceLoadChunks(worldNew);
        ChunkPos pair = worldNew.func_72964_e(spawnPos.intX() >> 4, spawnPos.intZ() >> 4).func_76632_l();
        GCLog.debug("Loading first chunk in new dimension at " + pair.field_77276_a + "," + pair.field_77275_b);
        worldNew.func_72863_F().func_186028_c(pair.field_77276_a, pair.field_77275_b);
        entity.func_70012_b(spawnPos.x, spawnPos.y, spawnPos.z, entity.field_70177_z, entity.field_70125_A);
        WorldServer fromWorld = (WorldServer)entity.field_70170_p;
        if (spawnRequired) {
            ((WorldServer)entity.field_70170_p).func_73039_n().func_72790_b(entity);
            entity.field_98038_p = true;
            worldNew.func_72838_d(entity);
            entity.func_70029_a((World)worldNew);
        }
        worldNew.func_72866_a(entity, true);
        if (entity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)entity).field_71135_a.func_147364_a(spawnPos.x, spawnPos.y, spawnPos.z, entity.field_70177_z, entity.field_70125_A);
        }
        CompatibilityManager.forceLoadChunksEnd(worldNew);
    }

    public static WorldServer getStartWorld(WorldServer unchanged) {
        if (ConfigManagerCore.challengeSpawnHandling) {
            WorldServer worldNew;
            WorldProvider wp = WorldUtil.getProviderForNameServer("planet.asteroids");
            WorldServer worldServer = worldNew = wp == null ? null : (WorldServer)wp.field_76579_a;
            if (worldNew != null) {
                return worldNew;
            }
        }
        return unchanged;
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityPlayer forceRespawnClient(int dimID, int par2, String par3, int par4) {
        SPacketRespawn fakePacket = new SPacketRespawn(dimID, EnumDifficulty.func_151523_a((int)par2), WorldType.func_77130_a((String)par3), WorldSettings.func_77161_a((int)par4));
        FMLClientHandler.instance().getClient().field_71439_g.field_71174_a.func_147280_a(fakePacket);
        return FMLClientHandler.instance().getClientPlayerEntity();
    }

    private static void removeEntityFromWorld(World var0, Entity var1, boolean directlyRemove) {
        if (var1 instanceof EntityPlayer) {
            EntityPlayer var2 = (EntityPlayer)var1;
            var2.func_71053_j();
            var0.field_73010_i.remove(var2);
            var0.func_72854_c();
        }
        int i = var1.field_70176_ah;
        int j = var1.field_70164_aj;
        if (var1.field_70175_ag && var0.func_175668_a(new BlockPos(i << 4, 63, j << 4), true)) {
            var0.func_72964_e(i, j).func_76622_b(var1);
        }
        if (directlyRemove) {
            ArrayList<Entity> l = new ArrayList<Entity>();
            l.add(var1);
            var0.func_175681_c(l);
        }
        var1.field_70128_L = false;
    }

    public static SpaceStationRecipe getSpaceStationRecipe(int planetID) {
        for (SpaceStationType type : GalacticraftRegistry.getSpaceStationData()) {
            if (type.getWorldToOrbitID() != planetID) continue;
            return type.getRecipeForSpaceStation();
        }
        return null;
    }

    public static List<Object> getPlanetList() {
        ArrayList<Object> objList = new ArrayList<Object>();
        objList.add(WorldUtil.getPlanetListInts());
        return objList;
    }

    public static Integer[] getPlanetListInts() {
        Integer[] iArray = new Integer[registeredPlanets.size()];
        for (int i = 0; i < iArray.length; ++i) {
            iArray[i] = registeredPlanets.get(i);
        }
        return iArray;
    }

    public static void decodePlanetsListClient(List<Object> data) {
        try {
            if (ConfigManagerCore.enableDebug) {
                GCLog.info("GC connecting to server: received planets dimension ID list.");
            }
            if (registeredPlanets != null) {
                for (Integer registeredID : registeredPlanets) {
                    if (!DimensionManager.isDimensionRegistered((int)registeredID)) continue;
                    DimensionManager.unregisterDimension((int)registeredID);
                }
            }
            registeredPlanets = new ArrayList<Integer>();
            String ids = "";
            if (data.size() > 0) {
                int providerIndex = GalaxyRegistry.getRegisteredSatellites().size() * 2;
                if (data.get(0) instanceof Integer) {
                    for (Object o : data) {
                        WorldUtil.registerPlanetClient((Integer)o, providerIndex);
                        ++providerIndex;
                        ids = ids + ((Integer)o).toString() + " ";
                    }
                } else if (data.get(0) instanceof Integer[]) {
                    for (Integer o : (Integer[])data.get(0)) {
                        WorldUtil.registerPlanetClient(o, providerIndex);
                        ++providerIndex;
                        ids = ids + o.toString() + " ";
                    }
                }
            }
            if (ConfigManagerCore.enableDebug) {
                WorldProvider dimAst;
                WorldProvider dimMars;
                GCLog.debug("GC clientside planet dimensions registered: " + ids);
                WorldProvider dimMoon = WorldUtil.getProviderForNameClient("moon.moon");
                if (dimMoon != null) {
                    GCLog.debug("Crosscheck: Moon is " + GCCoreUtil.getDimensionID(dimMoon));
                }
                if ((dimMars = WorldUtil.getProviderForNameClient("planet.mars")) != null) {
                    GCLog.debug("Crosscheck: Mars is " + GCCoreUtil.getDimensionID(dimMars));
                }
                if ((dimAst = WorldUtil.getProviderForNameClient("planet.asteroids")) != null) {
                    GCLog.debug("Crosscheck: Asteroids is " + GCCoreUtil.getDimensionID(dimAst));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<Object> getSpaceStationList() {
        ArrayList<Object> objList = new ArrayList<Object>();
        objList.add(WorldUtil.getSpaceStationListInts());
        return objList;
    }

    public static Integer[] getSpaceStationListInts() {
        Integer[] iArray = new Integer[registeredSpaceStations.size() * 2];
        int i = 0;
        for (Map.Entry<Integer, Integer> e : registeredSpaceStations.entrySet()) {
            iArray[i] = e.getKey();
            iArray[i + 1] = e.getValue();
            i += 2;
        }
        return iArray;
    }

    public static void decodeSpaceStationListClient(List<Object> data) {
        try {
            if (registeredSpaceStations != null) {
                for (Integer registeredID : registeredSpaceStations.keySet()) {
                    DimensionManager.unregisterDimension((int)registeredID);
                }
            }
            registeredSpaceStations = Maps.newHashMap();
            if (data.size() > 0) {
                if (data.get(0) instanceof Integer) {
                    for (int i = 0; i < data.size(); i += 2) {
                        WorldUtil.registerSSdim((Integer)data.get(i), (Integer)data.get(i + 1));
                    }
                } else if (data.get(0) instanceof Integer[]) {
                    Integer[] array = (Integer[])data.get(0);
                    for (int i = 0; i < array.length; i += 2) {
                        WorldUtil.registerSSdim(array[i], array[i + 1]);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void registerSSdim(Integer dimID, Integer providerKey) {
        if (!registeredSpaceStations.containsKey(dimID)) {
            if (!DimensionManager.isDimensionRegistered((int)dimID)) {
                registeredSpaceStations.put(dimID, providerKey);
                DimensionManager.registerDimension((int)dimID, (DimensionType)WorldUtil.getDimensionTypeById(providerKey));
            } else {
                GCLog.severe("Dimension already registered on client: unable to register space station dimension " + dimID);
            }
        }
    }

    public static void toCelestialSelection(EntityPlayerMP player, GCPlayerStats stats, int tier) {
        player.func_184210_p();
        stats.setSpaceshipTier(tier);
        HashMap<String, Integer> map = WorldUtil.getArrayOfPossibleDimensions(tier, player);
        String dimensionList = "";
        int count = 0;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            dimensionList = dimensionList.concat(entry.getKey() + (count < map.entrySet().size() - 1 ? "?" : ""));
            ++count;
        }
        boolean canCreateStations = PermissionAPI.hasPermission((EntityPlayer)player, (String)"galacticraft.station.create");
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_DIMENSION_LIST, GCCoreUtil.getDimensionID(player.field_70170_p), new Object[]{PlayerUtil.getName((EntityPlayer)player), dimensionList, canCreateStations}), player);
        stats.setUsingPlanetSelectionGui(true);
        stats.setSavedPlanetList(dimensionList);
        EntityCelestialFake fakeEntity = new EntityCelestialFake(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v);
        player.field_70170_p.func_72838_d((Entity)fakeEntity);
        player.func_184220_m((Entity)fakeEntity);
    }

    public static Vector3 getFootprintPosition(World world, float rotation, Vector3 startPosition, BlockVec3 playerCenter) {
        int mainPosZ;
        int mainPosY;
        Vector3 position = startPosition.clone();
        float footprintScale = 0.375f;
        int mainPosX = position.intX();
        BlockPos posMain = new BlockPos(mainPosX, mainPosY = position.intY(), mainPosZ = position.intZ());
        if (world.func_180495_p(posMain).func_177230_c().isAir(world.func_180495_p(posMain), (IBlockAccess)world, posMain)) {
            position.x += (double)(playerCenter.x - mainPosX);
            position.z += (double)(playerCenter.z - mainPosZ);
            BlockPos pos1 = new BlockPos(position.intX(), position.intY(), position.intZ());
            Block b2 = world.func_180495_p(pos1).func_177230_c();
            if (b2 != null && b2.isAir(world.func_180495_p(pos1), (IBlockAccess)world, pos1)) {
                for (EnumFacing direction : EnumFacing.field_82609_l) {
                    BlockPos offsetPos = posMain.func_177972_a(direction);
                    if (direction == EnumFacing.DOWN || direction == EnumFacing.UP || world.func_180495_p(offsetPos).func_177230_c().isAir(world.func_180495_p(offsetPos), (IBlockAccess)world, offsetPos)) continue;
                    position.x += (double)direction.func_82601_c();
                    position.z += (double)direction.func_82599_e();
                    break;
                }
            }
        }
        mainPosX = position.intX();
        mainPosZ = position.intZ();
        double x0 = Math.sin((double)(45.0f - rotation) / 57.29577951308232) * (double)footprintScale + position.x;
        double x1 = Math.sin((double)(135.0f - rotation) / 57.29577951308232) * (double)footprintScale + position.x;
        double x2 = Math.sin((double)(225.0f - rotation) / 57.29577951308232) * (double)footprintScale + position.x;
        double x3 = Math.sin((double)(315.0f - rotation) / 57.29577951308232) * (double)footprintScale + position.x;
        double z0 = Math.cos((double)(45.0f - rotation) / 57.29577951308232) * (double)footprintScale + position.z;
        double z1 = Math.cos((double)(135.0f - rotation) / 57.29577951308232) * (double)footprintScale + position.z;
        double z2 = Math.cos((double)(225.0f - rotation) / 57.29577951308232) * (double)footprintScale + position.z;
        double z3 = Math.cos((double)(315.0f - rotation) / 57.29577951308232) * (double)footprintScale + position.z;
        double xMin = Math.min(Math.min(x0, x1), Math.min(x2, x3));
        double xMax = Math.max(Math.max(x0, x1), Math.max(x2, x3));
        double zMin = Math.min(Math.min(z0, z1), Math.min(z2, z3));
        double zMax = Math.max(Math.max(z0, z1), Math.max(z2, z3));
        if (xMin < (double)mainPosX) {
            position.x += (double)mainPosX - xMin;
        }
        if (xMax > (double)(mainPosX + 1)) {
            position.x -= xMax - (double)(mainPosX + 1);
        }
        if (zMin < (double)mainPosZ) {
            position.z += (double)mainPosZ - zMin;
        }
        if (zMax > (double)(mainPosZ + 1)) {
            position.z -= zMax - (double)(mainPosZ + 1);
        }
        return position;
    }

    public static String spaceStationDataToString(HashMap<Integer, Integer> data) {
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<Integer, Integer>> it = data.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Integer> e = it.next();
            builder.append(e.getKey());
            builder.append("$");
            builder.append(e.getValue());
            if (!it.hasNext()) continue;
            builder.append("?");
        }
        return builder.toString();
    }

    public static HashMap<Integer, Integer> stringToSpaceStationData(String input) {
        HashMap data = Maps.newHashMap();
        if (!input.isEmpty()) {
            String[] str0 = input.split("\\?");
            for (int i = 0; i < str0.length; ++i) {
                String[] str1 = str0[i].split("\\$");
                data.put(Integer.parseInt(str1[0]), Integer.parseInt(str1[1]));
            }
        }
        return data;
    }

    public static String getDimensionName(WorldProvider wp) {
        CelestialBody cb;
        if (wp instanceof IGalacticraftWorldProvider && (cb = ((IGalacticraftWorldProvider)wp).getCelestialBody()) != null && !(cb instanceof Satellite)) {
            return cb.getUnlocalizedName();
        }
        if (GCCoreUtil.getDimensionID(wp) == ConfigManagerCore.idDimensionOverworld) {
            return "overworld";
        }
        return wp.func_186058_p().func_186065_b();
    }

    public static Map<String, List<String>> getAllChecklistKeys() {
        HashMap checklistMap = Maps.newHashMap();
        for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
            if (!planet.getReachable()) continue;
            checklistMap.put(planet.getUnlocalizedName(), planet.getChecklistKeys());
        }
        for (Moon moon : GalaxyRegistry.getRegisteredMoons().values()) {
            if (!moon.getReachable()) continue;
            checklistMap.put(moon.getUnlocalizedName(), moon.getChecklistKeys());
        }
        for (Satellite satellite : GalaxyRegistry.getRegisteredSatellites().values()) {
            if (!satellite.getReachable()) continue;
            checklistMap.put(satellite.getUnlocalizedName(), satellite.getChecklistKeys());
        }
        return checklistMap;
    }

    public static DimensionType getDimensionTypeById(int id) {
        for (DimensionType dimensiontype : DimensionType.values()) {
            if (dimensiontype.func_186068_a() != id) continue;
            return dimensiontype;
        }
        GCLog.severe("There was a problem getting WorldProvider type " + id);
        GCLog.severe("(possibly this is a conflict, check Galacticraft config.)");
        return null;
    }

    public static void markAdjacentPadForUpdate(World worldIn, BlockPos pos) {
        for (int dX = -2; dX <= 2; ++dX) {
            for (int dZ = -2; dZ <= 2; ++dZ) {
                BlockPos offsetPos = pos.func_177982_a(dX, 0, dZ);
                IBlockState blockState = worldIn.func_180495_p(offsetPos);
                if (blockState.func_177230_c() != GCBlocks.landingPadFull) continue;
                worldIn.func_184138_a(offsetPos, blockState, blockState, 3);
            }
        }
    }

    public static void setNextMorning(WorldServer world) {
        if (world.field_73011_w instanceof WorldProviderSpace) {
            long current = ((WorldProviderSpace)world.field_73011_w).preTickTime;
            long dayLength = ((WorldProviderSpace)world.field_73011_w).getDayLength();
            if (dayLength <= 0L) {
                return;
            }
            world.func_72877_b(current - current % dayLength + dayLength);
        } else {
            long newTime = world.func_72820_D();
            for (WorldServer worldServer : GCCoreUtil.getWorldServerList((World)world)) {
                if (worldServer == world || !(worldServer.field_73011_w instanceof WorldProviderSpace)) continue;
                ((WorldProviderSpace)worldServer.field_73011_w).adjustTime(newTime);
            }
        }
    }

    static {
        dimNames = new TreeMap<Integer, String>();
        celestialMapCache = new MapMaker().weakKeys().makeMap();
    }
}

