/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.MapUtil;
import micdoodle8.mods.miccore.IntCache;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import org.apache.commons.io.FileUtils;

public class MapGen
extends BiomeProvider
implements Runnable {
    private static final float[] parabolicField = new float[25];
    public static boolean disabled;
    static double[] mainNoiseRegion;
    static double[] minLimitRegion;
    static double[] maxLimitRegion;
    static double[] depthRegion;
    private final int biomeMapFactor;
    private final int tickLimit;
    private final int dimID;
    public boolean mapNeedsCalculating = false;
    public AtomicBoolean finishedCalculating;
    public File biomeMapFile;
    public NoiseGeneratorOctaves noiseGen4;
    private AtomicBoolean paused;
    private AtomicBoolean aborted;
    private AtomicInteger progressX;
    private int progressZ;
    private int biomeMapX;
    private int biomeMapZ;
    private int biomeMap0;
    private int biomeMapCx;
    private int biomeMapCz;
    private int imagefactor;
    private BiomeCache biomeCache;
    private GenLayer genBiomes;
    private GenLayer biomeIndexLayer;
    private byte[] biomeAndHeightArray = null;
    private int biomeMapSizeX;
    private int biomeMapSizeZ;
    private Random rand;
    private int[] heights;
    private double[] heighttemp;
    private World world;
    private WorldType worldType;
    private WorldInfo worldInfo;
    private ChunkGeneratorSettings settings = null;
    private int[] biomesGrid = null;
    private Biome[] biomesGridHeights = null;
    private int[] biomeCount = null;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;

    public MapGen(World worldIn, int sx, int sz, int cx, int cz, int scale, File file) {
        GenLayer[] agenlayer;
        this.dimID = GCCoreUtil.getDimensionID(worldIn);
        this.biomeMapFactor = scale;
        this.tickLimit = Math.min(scale, 16);
        if (disabled) {
            this.mapNeedsCalculating = false;
            return;
        }
        this.biomeMapSizeX = sx;
        this.biomeMapSizeZ = sz;
        int progress = this.checkProgress(file);
        if (progress < 0) {
            this.mapNeedsCalculating = false;
            return;
        }
        this.mapNeedsCalculating = true;
        this.rand = new Random();
        this.finishedCalculating = new AtomicBoolean();
        this.paused = new AtomicBoolean();
        this.aborted = new AtomicBoolean();
        this.biomeMapCx = cx >> 4;
        this.biomeMapCz = cz >> 4;
        this.biomeMapFile = file;
        this.imagefactor = 16 / this.biomeMapFactor;
        if (this.imagefactor < 1) {
            this.imagefactor = 1;
        }
        int limitX = this.biomeMapSizeX * this.biomeMapFactor / 32;
        int limitZ = this.biomeMapSizeZ * this.biomeMapFactor / 32;
        this.biomeMap0 = -limitZ;
        this.biomeMapX = -limitX;
        this.biomeMapZ = this.biomeMap0;
        this.progressX = new AtomicInteger();
        this.progressZ = 0;
        this.world = worldIn;
        this.worldInfo = worldIn.func_72912_H();
        this.worldType = this.worldInfo.func_76067_t();
        long seed = this.worldInfo.func_76063_b();
        this.biomeCache = new BiomeCache((BiomeProvider)this);
        String options = this.worldInfo.func_82571_y();
        try {
            if (options != null) {
                this.settings = ChunkGeneratorSettings.Factory.func_177865_a((String)options).func_177864_b();
            }
            if (CompatibilityManager.isBOPWorld(this.worldType)) {
                Object settingsBOP = CompatibilityManager.classBOPws.getConstructor(String.class).newInstance(options);
                Method bopSetup = CompatibilityManager.classBOPwcm.getMethod("setupBOPGenLayers", Long.TYPE, settingsBOP.getClass());
                agenlayer = (GenLayer[])bopSetup.invoke(null, seed, settingsBOP);
            } else {
                agenlayer = GenLayer.func_180781_a((long)seed, (WorldType)this.worldType, (ChunkGeneratorSettings)this.settings);
            }
            agenlayer = this.getModdedBiomeGenerators(this.worldType, seed, agenlayer);
        }
        catch (Exception e) {
            GCLog.severe("Galacticraft background map image generator not able to run (probably a mod conflict?)");
            GCLog.severe("Please report this at https://github.com/micdoodle8/Galacticraft/issues/2481");
            e.printStackTrace();
            this.mapNeedsCalculating = false;
            disabled = true;
            return;
        }
        this.genBiomes = agenlayer[0];
        this.biomeIndexLayer = agenlayer[1];
        GCLog.debug("Starting map generation " + file.getName() + " top left " + (this.biomeMapCx - limitX) * 16 + "," + (this.biomeMapCz - limitZ) * 16);
        if (progress > 0) {
            this.resumeProgress(progress);
        }
    }

    public static boolean testFlag(byte[] bb) {
        return (bb[7] & 0xFF) == 254 && bb[6] == 6 && bb[5] == 3 && bb[4] == 14;
    }

    public static void arrayClear(int[] array, int len) {
        int i;
        int lenB = len < 16 ? len : 16;
        for (i = 0; i < lenB; ++i) {
            array[i] = 0;
        }
        for (i = 16; i < len; i += i) {
            System.arraycopy(array, 0, array, i, i + i > len ? i : len - i);
        }
    }

    private int checkProgress(File file) {
        if (!file.exists()) {
            return 0;
        }
        if (file.length() != (long)(this.biomeMapSizeX * this.biomeMapSizeZ * 2)) {
            return 0;
        }
        int progress = 0;
        if (file.getName().equals("Overworld1536.bin")) {
            int len = (int)file.length();
            try {
                FileChannel fc = FileChannel.open(file.toPath(), new OpenOption[0]);
                fc.position(len - 8);
                byte[] flagdata = new byte[8];
                ByteBuffer databuff = ByteBuffer.wrap(flagdata);
                fc.read(databuff);
                if (!MapGen.testFlag(flagdata)) {
                    return -1;
                }
                databuff.order(ByteOrder.BIG_ENDIAN);
                databuff.position(0);
                progress = databuff.getInt();
                fc.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (progress > 0 && progress <= this.biomeMapSizeX - this.imagefactor) {
                try {
                    this.biomeAndHeightArray = FileUtils.readFileToByteArray((File)file);
                    this.initialiseSmallerArrays();
                    return progress;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.biomeAndHeightArray = null;
                }
            }
            return 0;
        }
        return -1;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(90L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long seed = this.worldInfo.func_76063_b();
        this.initialise(seed);
        while (!this.aborted.get()) {
            if (this.paused.get()) {
                try {
                    Thread.sleep(1211L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (!this.BiomeMapOneTick()) continue;
        }
        this.finishedCalculating.set(true);
    }

    public void pause() {
        this.paused.set(true);
    }

    public void resume() {
        this.paused.set(false);
    }

    public void abort() {
        this.aborted.set(true);
    }

    private void flagProgress() {
        int progX = this.progressX.get();
        if (progX > this.biomeMapSizeX - this.imagefactor) {
            return;
        }
        GCLog.debug("Saving partial map image progress " + progX);
        int offset = this.biomeAndHeightArray.length;
        this.biomeAndHeightArray[offset - 1] = -2;
        this.biomeAndHeightArray[offset - 2] = 6;
        this.biomeAndHeightArray[offset - 3] = 3;
        this.biomeAndHeightArray[offset - 4] = 14;
        this.biomeAndHeightArray[offset - 5] = (byte)(progX & 0xFF);
        this.biomeAndHeightArray[offset - 6] = (byte)(progX >> 8 & 0xFF);
        this.biomeAndHeightArray[offset - 7] = (byte)(progX >> 16 & 0xFF);
        this.biomeAndHeightArray[offset - 8] = (byte)(progX >> 24 & 0xFF);
    }

    private void resumeProgress(int progress) {
        int multifactor = this.biomeMapFactor >> 4;
        if (multifactor < 1) {
            multifactor = 1;
        }
        int progCount = progress / this.imagefactor;
        this.progressX.set(progress);
        this.biomeMapX = multifactor * progCount - this.biomeMapSizeX * this.biomeMapFactor / 32;
        if (this.biomeMapX > -this.biomeMap0 * 4) {
            this.biomeMapX += this.biomeMap0 * 8;
        }
    }

    public void writeOutputFile(boolean sendToClientImmediately) {
        if (this.biomeAndHeightArray == null) {
            return;
        }
        if (!this.aborted.get()) {
            try {
                if (!this.biomeMapFile.exists() || this.biomeMapFile.canWrite() && this.biomeMapFile.canRead()) {
                    this.flagProgress();
                    FileUtils.writeByteArrayToFile((File)this.biomeMapFile, (byte[])this.biomeAndHeightArray);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (sendToClientImmediately) {
                MapUtil.sendMapPacketToAll(this.biomeMapCx << 4, this.biomeMapCz << 4, this.biomeAndHeightArray);
            }
        }
        this.biomeAndHeightArray = null;
    }

    private void initialiseSmallerArrays() {
        this.heights = new int[256];
        this.heighttemp = new double[825];
        this.biomeCount = new int[this.tickLimit * this.tickLimit];
    }

    public boolean BiomeMapOneTick() {
        int multifactor;
        if (this.biomeAndHeightArray == null) {
            this.biomeAndHeightArray = new byte[this.biomeMapSizeX * this.biomeMapSizeZ * 2];
            this.initialiseSmallerArrays();
        }
        if ((multifactor = this.biomeMapFactor >> 4) < 1) {
            multifactor = 1;
        }
        int progX = this.progressX.get();
        try {
            this.biomeMapOneChunk(this.biomeMapCx + this.biomeMapX, this.biomeMapCz + this.biomeMapZ, progX, this.progressZ, this.tickLimit);
        }
        catch (Exception e) {
            GCLog.severe("Galacticraft background map image generator hit an error (probably a mod conflict?)");
            GCLog.severe("--> Please report this at https://github.com/micdoodle8/Galacticraft/issues/2544 <--");
            e.printStackTrace();
            disabled = true;
            this.aborted.set(true);
            return true;
        }
        this.biomeMapZ += multifactor;
        this.progressZ += this.imagefactor;
        if (this.progressZ > this.biomeMapSizeZ - this.imagefactor) {
            this.progressZ = 0;
            this.progressX.set(progX + this.imagefactor);
            this.biomeMapZ = this.biomeMap0;
            this.biomeMapX += multifactor;
            if (this.biomeMapX > -this.biomeMap0 * 4) {
                this.biomeMapX += this.biomeMap0 * 8;
            }
            return progX > this.biomeMapSizeX - this.imagefactor - this.imagefactor;
        }
        return false;
    }

    private void biomeMapOneChunk(int x0, int z0, int ix, int iz, int limit) {
        this.biomesGrid = this.getBiomeGenAt(this.biomesGrid, x0 << 4, z0 << 4, 16, 16);
        if (this.biomesGrid == null) {
            return;
        }
        this.getHeightMap(x0, z0);
        int factor = this.biomeMapFactor;
        int halfFactor = limit * limit / 2;
        ArrayList<Integer> cols = new ArrayList<Integer>();
        for (int j = 0; j < this.biomeCount.length; ++j) {
            this.biomeCount[j] = 0;
        }
        for (int x = 0; x < 16; x += factor) {
            int izstore = iz;
            for (int z = 0; z < 16; z += factor) {
                cols.clear();
                int maxcount = 0;
                int maxindex = -1;
                int biome = -1;
                int lastcol = -1;
                int idx = 0;
                int avgHeight = 0;
                int divisor = 0;
                block3: for (int xx = 0; xx < limit; ++xx) {
                    int hidx = (xx + x << 4) + z;
                    for (int zz = 0; zz < limit; ++zz) {
                        int height = this.heights[hidx + zz];
                        avgHeight += height;
                        ++divisor;
                        biome = this.biomesGrid[xx + x + (zz + z << 4)];
                        if (biome != lastcol) {
                            idx = cols.indexOf(biome);
                            if (idx == -1) {
                                idx = cols.size();
                                cols.add(biome);
                            }
                            lastcol = biome;
                        }
                        int n = idx;
                        this.biomeCount[n] = this.biomeCount[n] + 1;
                        if (this.biomeCount[idx] <= maxcount) continue;
                        maxcount = this.biomeCount[idx];
                        maxindex = idx;
                        if (maxcount > halfFactor) break block3;
                    }
                }
                MapGen.arrayClear(this.biomeCount, cols.size());
                int arrayIndex = (ix * this.biomeMapSizeZ + iz) * 2;
                this.biomeAndHeightArray[arrayIndex] = (byte)((Integer)cols.get(maxindex)).intValue();
                this.biomeAndHeightArray[arrayIndex + 1] = (byte)((avgHeight + (divisor + 1) / 2) / divisor);
                ++iz;
            }
            iz = izstore;
            ++ix;
        }
    }

    public void getHeightMap(int cx, int cz) {
        this.rand.setSeed((long)cx * 341873128712L + (long)cz * 132897987541L);
        this.biomesGridHeights = this.func_76937_a(this.biomesGridHeights, cx * 4 - 2, cz * 4 - 2, 10, 10);
        this.generateHeightMap(cx * 4, 0, cz * 4);
        double d0 = 0.125;
        double d9 = 0.25;
        for (int xx = 0; xx < 4; ++xx) {
            int xa = xx * 5;
            int xb = xa + 5;
            for (int zz = 0; zz < 4; ++zz) {
                int aa = (xa + zz) * 33;
                int ab = aa + 33;
                int ba = (xb + zz) * 33;
                int bb = ba + 33;
                for (int yy = 2; yy < 18; ++yy) {
                    double d1 = this.heighttemp[aa + yy];
                    double d2 = this.heighttemp[ab + yy];
                    double d3 = this.heighttemp[ba + yy];
                    double d4 = this.heighttemp[bb + yy];
                    double d5 = (this.heighttemp[aa + yy + 1] - d1) * 0.125;
                    double d6 = (this.heighttemp[ab + yy + 1] - d2) * 0.125;
                    double d7 = (this.heighttemp[ba + yy + 1] - d3) * 0.125;
                    double d8 = (this.heighttemp[bb + yy + 1] - d4) * 0.125;
                    for (int y = 0; y < 8; ++y) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        int truey = yy * 8 + y;
                        for (int x = 0; x < 4; ++x) {
                            int idx = x + xx * 4 << 4 | zz * 4;
                            double d16 = (d11 - d10) * 0.25;
                            double d15 = d10 - d16;
                            for (int z = 0; z < 4; ++z) {
                                double d;
                                d15 += d16;
                                if (!(d > 0.0)) continue;
                                this.heights[idx + z] = truey;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void initialise(long seed) {
        this.rand = new Random(seed);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        NoiseGeneratorPerlin ignore1 = new NoiseGeneratorPerlin(this.rand, 4);
        NoiseGeneratorOctaves ignore2 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 16);
        NoiseGeneratorOctaves ignore3 = new NoiseGeneratorOctaves(this.rand, 8);
        InitNoiseGensEvent.ContextOverworld ctx = new InitNoiseGensEvent.ContextOverworld(this.noiseGen1, this.noiseGen2, this.noiseGen3, ignore1, ignore2, this.noiseGen4, ignore3);
        ctx = (InitNoiseGensEvent.ContextOverworld)TerrainGen.getModdedNoiseGenerators((World)this.world, (Random)this.rand, (InitNoiseGensEvent.Context)ctx);
        this.noiseGen1 = ctx.getLPerlin1();
        this.noiseGen2 = ctx.getLPerlin2();
        this.noiseGen3 = ctx.getPerlin();
        this.noiseGen4 = ctx.getDepth();
    }

    private void generateHeightMap(int cx, int cy, int cz) {
        float f = this.settings.field_177811_a;
        float f1 = this.settings.field_177809_b;
        depthRegion = this.noiseGen4.func_76305_a(depthRegion, cx, cz, 5, 5, (double)this.settings.field_177808_e, (double)this.settings.field_177803_f, (double)this.settings.field_177804_g);
        mainNoiseRegion = this.noiseGen3.func_76304_a(mainNoiseRegion, cx, cy, cz, 5, 33, 5, (double)(f / this.settings.field_177825_h), (double)(f1 / this.settings.field_177827_i), (double)(f / this.settings.field_177821_j));
        minLimitRegion = this.noiseGen1.func_76304_a(minLimitRegion, cx, cy, cz, 5, 33, 5, (double)f, (double)f1, (double)f);
        maxLimitRegion = this.noiseGen2.func_76304_a(maxLimitRegion, cx, cy, cz, 5, 33, 5, (double)f, (double)f1, (double)f);
        boolean amplified = this.worldType == WorldType.field_151360_e;
        double minLimitScale = this.settings.field_177806_d;
        double maxLimitScale = this.settings.field_177810_c;
        double stretchY = (double)this.settings.field_177817_l * 128.0 / 256.0;
        double baseSize = this.settings.field_177823_k;
        int i = 2;
        int j = 0;
        for (int xx = 0; xx < 5; ++xx) {
            for (int zz = 0; zz < 5; ++zz) {
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                float theMinHeight = this.biomesGridHeights[xx + 22 + zz * 10].func_185355_j();
                for (int x = -2; x <= 2; ++x) {
                    int baseIndex = xx + x + 22;
                    for (int z = -2; z <= 2; ++z) {
                        Biome biomegenbase1 = this.biomesGridHeights[baseIndex + (zz + z) * 10];
                        float f5 = this.settings.field_177813_n + biomegenbase1.func_185355_j() * this.settings.field_177819_m;
                        float f6 = this.settings.field_177843_p + biomegenbase1.func_185360_m() * this.settings.field_177815_o;
                        if (amplified && f5 > 0.0f) {
                            f5 = 1.0f + f5 + f5;
                            f6 = 1.0f + f6 * 4.0f;
                        }
                        float f7 = parabolicField[x + 12 + z * 5] / (f5 + 2.0f);
                        if (biomegenbase1.func_185355_j() > theMinHeight) {
                            f7 /= 2.0f;
                        }
                        f2 += f6 * f7;
                        f3 += f5 * f7;
                        f4 += f7;
                    }
                }
                f2 /= f4;
                f3 /= f4;
                f2 = f2 * 0.9f + 0.1f;
                f3 = (f3 * 4.0f - 1.0f) / 8.0f;
                double d7 = depthRegion[j] / 8000.0;
                if (d7 < 0.0) {
                    d7 = -d7 * 0.3;
                }
                if ((d7 = d7 * 3.0 - 2.0) < 0.0) {
                    if ((d7 /= 2.0) < -1.0) {
                        d7 = -1.0;
                    }
                    d7 /= 1.4;
                    d7 /= 2.0;
                } else {
                    if (d7 > 1.0) {
                        d7 = 1.0;
                    }
                    d7 /= 8.0;
                }
                ++j;
                double d8 = f3;
                double d9 = f2;
                d8 += d7 * 0.2;
                d8 = d8 * baseSize / 8.0;
                double d0 = baseSize + d8 * 4.0;
                for (int j2 = 2; j2 < 19; ++j2) {
                    double d5;
                    double d1 = ((double)j2 - d0) * stretchY / d9;
                    if (d1 < 0.0) {
                        d1 *= 4.0;
                    }
                    double d2 = minLimitRegion[i] / minLimitScale;
                    double d3 = maxLimitRegion[i] / maxLimitScale;
                    double d4 = (mainNoiseRegion[i] / 10.0 + 1.0) / 2.0;
                    this.heighttemp[i] = d5 = MathHelper.func_151238_b((double)d2, (double)d3, (double)d4) - d1;
                    ++i;
                }
                i += 16;
            }
        }
    }

    public Biome[] func_76937_a(Biome[] biomes, int x, int z, int width, int height) {
        IntCache.resetIntCacheGC();
        int[] aint = this.genBiomes.func_75904_a(x, z, width, height);
        int size = width * height;
        if (biomes == null || biomes.length < size) {
            biomes = new Biome[size];
        }
        for (int i = 0; i < size; ++i) {
            int biomeId = aint[i];
            Biome biomegenbase = Biome.func_180276_a((int)biomeId, (Biome)Biomes.field_180279_ad);
            biomes[i] = biomegenbase == null ? Biomes.field_76771_b : biomegenbase;
        }
        return biomes;
    }

    public int[] getBiomeGenAt(int[] listToReuse, int x, int z, int width, int height) {
        IntCache.resetIntCacheGC();
        int[] aint = this.biomeIndexLayer.func_75904_a(x, z, width, height);
        int size = width * height;
        if (listToReuse == null || listToReuse.length < size) {
            listToReuse = new int[size];
        }
        System.arraycopy(aint, 0, listToReuse, 0, size);
        return listToReuse;
    }

    static {
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                MapGen.parabolicField[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
    }
}

