/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockPanelLighting;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.galacticraft.core.util.RedstoneUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityPanelLight
extends TileEntity
implements IPacketReceiver {
    private static final IBlockState defaultLook = GalacticraftCore.isPlanetsLoaded ? AsteroidBlocks.blockBasic.func_176203_a(6) : GCBlocks.basicBlock.func_176203_a(4);
    public int meta;
    public int color = 0xF0F0E0;
    private IBlockState superState;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    public static IBlockState readBlockState(NBTTagCompound tag) {
        int meta;
        if (!tag.func_150297_b("Name", 8)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(tag.func_74779_i("Name")));
        if (tag.func_74764_b("Meta") && (meta = tag.func_74762_e("Meta")) >= 0 && meta < 16) {
            return block.func_176203_a(meta);
        }
        return block.func_176223_P();
    }

    public static NBTTagCompound writeBlockState(NBTTagCompound tag, IBlockState state) {
        tag.func_74778_a("Name", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c())).toString());
        tag.func_74768_a("Meta", state.func_177230_c().func_176201_c(state));
        return tag;
    }

    public static IBlockState readBlockState(String name, Integer meta) {
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(name));
        if (block == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return block.func_176203_a(meta.intValue());
    }

    public void initialise(int type, EnumFacing facing, EntityPlayer player, boolean isRemote, IBlockState superStateClient) {
        this.meta = facing.ordinal();
        if (isRemote) {
            this.superState = superStateClient;
            this.color = BlockPanelLighting.color;
        } else {
            GCPlayerStats stats = GCPlayerStats.get((Entity)player);
            this.superState = stats.getPanelLightingBases()[type];
            this.color = stats.getPanelLightingColor();
        }
    }

    public IBlockState getBaseBlock() {
        if (this.superState != null && this.superState.func_177230_c() == Blocks.field_150350_a) {
            this.superState = null;
        }
        return this.superState == null ? defaultLook : this.superState;
    }

    public BlockPanelLighting.PanelType getType() {
        IBlockState b;
        if (this.field_145850_b != null && (b = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() instanceof BlockPanelLighting) {
            return (BlockPanelLighting.PanelType)((Object)b.func_177229_b(BlockPanelLighting.TYPE));
        }
        return BlockPanelLighting.PanelType.SQUARE;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1));
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 262144.0;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        NBTTagCompound tag;
        super.func_145839_a(nbt);
        this.meta = nbt.func_74762_e("meta");
        if (nbt.func_74764_b("col")) {
            this.color = nbt.func_74762_e("col");
        }
        if (!(tag = nbt.func_74775_l("sust")).func_82582_d()) {
            this.superState = TileEntityPanelLight.readBlockState(tag);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("meta", this.meta);
        nbt.func_74768_a("col", this.color);
        if (this.superState != null) {
            NBTTagCompound tag = new NBTTagCompound();
            TileEntityPanelLight.writeBlockState(tag, this.superState);
            nbt.func_74782_a("sust", (NBTBase)tag);
        }
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            GalacticraftCore.packetPipeline.sendToServer(new PacketDynamic(this));
        }
    }

    @Override
    public void getNetworkedData(ArrayList<Object> sendData) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        sendData.add((byte)this.meta);
        sendData.add(this.color);
        if (this.superState != null) {
            Block block = this.superState.func_177230_c();
            if (block == Blocks.field_150350_a) {
                this.superState = null;
                return;
            }
            sendData.add(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString());
            sendData.add((byte)block.func_176201_c(this.superState));
        }
    }

    @Override
    public void decodePacketdata(ByteBuf buffer) {
        if (this.field_145850_b.field_72995_K) {
            try {
                this.meta = buffer.readByte();
                this.color = buffer.readInt();
                if (buffer.readableBytes() > 0) {
                    String name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
                    byte otherMeta = buffer.readByte();
                    this.superState = TileEntityPanelLight.readBlockState(name, Integer.valueOf(otherMeta));
                    this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean getEnabled() {
        return !RedstoneUtil.isBlockReceivingRedstone(this.field_145850_b, this.func_174877_v());
    }
}

