/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.entities.IBoss;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAdvanced;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityDungeonSpawner<E extends Entity>
extends TileEntityAdvanced {
    public Class<E> bossClass;
    public IBoss boss;
    public boolean spawned;
    public boolean isBossDefeated;
    public boolean playerInRange;
    public boolean lastPlayerInRange;
    public long lastKillTime;
    private Vector3 roomCoords;
    private Vector3 roomSize;
    private BlockPos chestPos;
    private AxisAlignedBB range15 = null;
    private AxisAlignedBB rangeBounds = null;
    private AxisAlignedBB rangeBoundsPlus3 = null;
    private AxisAlignedBB rangeBoundsPlus11 = null;

    public TileEntityDungeonSpawner() {
        this((Class<E>)null);
    }

    public TileEntityDungeonSpawner(Class<E> bossClass) {
        super("tile.gcdungeonspawner.name");
        this.bossClass = bossClass;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.roomCoords == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.range15 == null) {
                Vector3 thisVec = new Vector3(this);
                this.range15 = new AxisAlignedBB(thisVec.x - 15.0, thisVec.y - 15.0, thisVec.z - 15.0, thisVec.x + 15.0, thisVec.y + 15.0, thisVec.z + 15.0);
                this.rangeBounds = new AxisAlignedBB((double)this.roomCoords.intX(), (double)this.roomCoords.intY(), (double)this.roomCoords.intZ(), (double)(this.roomCoords.intX() + this.roomSize.intX()), (double)(this.roomCoords.intY() + this.roomSize.intY()), (double)(this.roomCoords.intZ() + this.roomSize.intZ()));
                this.rangeBoundsPlus3 = this.rangeBounds.func_72314_b(3.0, 3.0, 3.0);
            }
            if (this.lastKillTime > 0L && MinecraftServer.func_130071_aq() - this.lastKillTime > 900000L) {
                this.lastKillTime = 0L;
                this.isBossDefeated = false;
            }
            List l = this.field_145850_b.func_72872_a(this.bossClass, this.range15);
            for (Object e : l) {
                if (((Entity)e).field_70128_L) continue;
                this.boss = (IBoss)e;
                this.spawned = true;
                this.isBossDefeated = false;
                this.boss.onBossSpawned(this);
            }
            List entitiesWithin = this.field_145850_b.func_72872_a(EntityMob.class, this.rangeBoundsPlus3);
            for (Entity mob : entitiesWithin) {
                if (!this.getDisabledCreatures().contains(mob.getClass())) continue;
                mob.func_70106_y();
            }
            List playersWithin = this.field_145850_b.func_72872_a(EntityPlayer.class, this.rangeBounds);
            boolean bl = this.playerInRange = !playersWithin.isEmpty();
            if (this.playerInRange && !this.lastPlayerInRange && !this.spawned) {
                if (this.boss == null && !this.isBossDefeated) {
                    try {
                        Constructor<E> c = this.bossClass.getConstructor(World.class);
                        this.boss = (IBoss)c.newInstance(this.field_145850_b);
                        ((Entity)this.boss).func_70107_b((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.0, (double)this.func_174877_v().func_177952_p() + 0.5);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (this.boss != null && this.boss instanceof EntityLiving) {
                    EntityLiving bossLiving = (EntityLiving)this.boss;
                    bossLiving.func_180482_a(this.field_145850_b.func_175649_E(new BlockPos((Entity)bossLiving)), null);
                    this.field_145850_b.func_72838_d((Entity)bossLiving);
                    this.playSpawnSound((Entity)bossLiving);
                    this.spawned = true;
                }
            }
            this.lastPlayerInRange = this.playerInRange;
        }
    }

    public void playSpawnSound(Entity entity) {
    }

    public List<Class<? extends EntityLiving>> getDisabledCreatures() {
        ArrayList<Class<? extends EntityLiving>> list = new ArrayList<Class<? extends EntityLiving>>();
        list.add(EntityEvolvedSkeleton.class);
        list.add(EntityEvolvedCreeper.class);
        list.add(EntityEvolvedZombie.class);
        list.add(EntityEvolvedSpider.class);
        return list;
    }

    public void setRoom(Vector3 coords, Vector3 size) {
        this.roomCoords = coords;
        this.roomSize = size;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        block6: {
            super.func_145839_a(nbt);
            this.playerInRange = this.lastPlayerInRange = nbt.func_74767_n("playerInRange");
            this.isBossDefeated = nbt.func_74767_n("defeated");
            try {
                this.bossClass = Class.forName(nbt.func_74779_i("bossClass"));
            }
            catch (Exception e) {
                if (this.field_145850_b.field_72995_K) break block6;
                e.printStackTrace();
            }
        }
        this.roomCoords = new Vector3();
        this.roomCoords.x = nbt.func_74769_h("roomCoordsX");
        this.roomCoords.y = nbt.func_74769_h("roomCoordsY");
        this.roomCoords.z = nbt.func_74769_h("roomCoordsZ");
        this.roomSize = new Vector3();
        this.roomSize.x = nbt.func_74769_h("roomSizeX");
        this.roomSize.y = nbt.func_74769_h("roomSizeY");
        this.roomSize.z = nbt.func_74769_h("roomSizeZ");
        if (nbt.func_74764_b("lastKillTime")) {
            this.lastKillTime = nbt.func_74763_f("lastKillTime");
        } else if (nbt.func_74764_b("lastKillTimeNew")) {
            long savedTime = nbt.func_74763_f("lastKillTimeNew");
            long l = this.lastKillTime = savedTime == 0L ? 0L : savedTime + MinecraftServer.func_130071_aq();
        }
        if (nbt.func_74764_b("chestPosNull") && !nbt.func_74767_n("chestPosNull")) {
            this.chestPos = new BlockPos(nbt.func_74762_e("chestX"), nbt.func_74762_e("chestY"), nbt.func_74762_e("chestZ"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("playerInRange", this.playerInRange);
        nbt.func_74757_a("defeated", this.isBossDefeated);
        nbt.func_74778_a("bossClass", this.bossClass.getCanonicalName());
        if (this.roomCoords != null) {
            nbt.func_74780_a("roomCoordsX", this.roomCoords.x);
            nbt.func_74780_a("roomCoordsY", this.roomCoords.y);
            nbt.func_74780_a("roomCoordsZ", this.roomCoords.z);
            nbt.func_74780_a("roomSizeX", this.roomSize.x);
            nbt.func_74780_a("roomSizeY", this.roomSize.y);
            nbt.func_74780_a("roomSizeZ", this.roomSize.z);
        }
        nbt.func_74772_a("lastKillTimeNew", this.lastKillTime == 0L ? 0L : this.lastKillTime - MinecraftServer.func_130071_aq());
        nbt.func_74757_a("chestPosNull", this.chestPos == null);
        if (this.chestPos != null) {
            nbt.func_74768_a("chestX", this.chestPos.func_177958_n());
            nbt.func_74768_a("chestY", this.chestPos.func_177956_o());
            nbt.func_74768_a("chestZ", this.chestPos.func_177952_p());
        }
        return nbt;
    }

    @Override
    public double getPacketRange() {
        return 0.0;
    }

    @Override
    public int getPacketCooldown() {
        return 0;
    }

    @Override
    public boolean isNetworkedTile() {
        return false;
    }

    public BlockPos getChestPos() {
        return this.chestPos;
    }

    public void setChestPos(BlockPos chestPos) {
        this.chestPos = chestPos;
    }

    public AxisAlignedBB getRangeBounds() {
        if (this.rangeBounds == null) {
            this.rangeBounds = new AxisAlignedBB((double)this.roomCoords.intX(), (double)this.roomCoords.intY(), (double)this.roomCoords.intZ(), (double)(this.roomCoords.intX() + this.roomSize.intX()), (double)(this.roomCoords.intY() + this.roomSize.intY()), (double)(this.roomCoords.intZ() + this.roomSize.intZ()));
        }
        return this.rangeBounds;
    }

    public AxisAlignedBB getRangeBoundsPlus11() {
        if (this.rangeBoundsPlus11 == null) {
            this.rangeBoundsPlus11 = this.getRangeBounds().func_72314_b(11.0, 11.0, 11.0);
        }
        return this.rangeBoundsPlus11;
    }
}

