/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityDish
extends TileBaseUniversalElectrical
implements IMultiBlock,
IDisableableMachine,
IInventoryDefaults,
ISidedInventory,
IConnector {
    public float targetAngle;
    public float currentAngle;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean disabled = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int disableCooldown = 0;
    private boolean initialised = false;
    private AxisAlignedBB renderAABB;

    public TileEntityDish() {
        super("tile.satellitedish.name");
        this.storage.setMaxExtract(100.0f);
        this.setTierGC(1);
        this.inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    }

    public float rotation(float partial) {
        return ((float)this.ticks + partial) / 12.0f;
    }

    public float elevation(float partial) {
        return (MathHelper.func_76126_a((float)(this.rotation(partial) / 40.0f)) + 1.0f) * 22.5f;
    }

    @Override
    public void func_73660_a() {
        float difference;
        super.func_73660_a();
        if (!this.initialised) {
            this.initialised = this.initialiseMultiTiles(this.func_174877_v(), this.field_145850_b);
        }
        if (!this.field_145850_b.field_72995_K && this.disableCooldown > 0) {
            --this.disableCooldown;
        }
        float angle = this.field_145850_b.func_72826_c(1.0f) - 0.7845194f < 0.0f ? 0.21548063f : -0.7845194f;
        float celestialAngle = (this.field_145850_b.func_72826_c(1.0f) + angle) * 360.0f;
        if ((celestialAngle %= 360.0f) > 30.0f && celestialAngle < 150.0f) {
            difference = this.targetAngle - celestialAngle;
            this.targetAngle -= difference / 20.0f;
        } else if (!this.field_145850_b.func_72935_r() || this.field_145850_b.func_72896_J() || this.field_145850_b.func_72911_I()) {
            this.targetAngle = 257.5f;
        } else if (celestialAngle < 50.0f) {
            this.targetAngle = 50.0f;
        } else if (celestialAngle > 150.0f) {
            this.targetAngle = 150.0f;
        }
        difference = this.targetAngle - this.currentAngle;
        this.currentAngle += difference / 20.0f;
    }

    protected boolean initialiseMultiTiles(BlockPos pos, World world) {
        if (world.field_72995_K) {
            this.onCreate(world, pos);
        }
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        this.getPositions(pos, positions);
        boolean result = true;
        for (BlockPos vecToAdd : positions) {
            TileEntity tile = world.func_175625_s(vecToAdd);
            if (tile instanceof TileEntityMulti) {
                ((TileEntityMulti)tile).mainBlockPosition = pos;
                continue;
            }
            result = false;
        }
        return result;
    }

    @Override
    public boolean onActivated(EntityPlayer entityPlayer) {
        return false;
    }

    @Override
    public void onCreate(World world, BlockPos placedPosition) {
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        this.getPositions(placedPosition, positions);
        ((BlockMulti)GCBlocks.fakeBlock).makeFakeBlock(world, positions, placedPosition, this.getMultiType());
    }

    @Override
    public BlockMulti.EnumBlockMultiType getMultiType() {
        return BlockMulti.EnumBlockMultiType.DISH_LARGE;
    }

    @Override
    public void getPositions(BlockPos placedPosition, List<BlockPos> positions) {
        int z;
        int x;
        int buildHeight = this.field_145850_b.func_72800_K() - 1;
        int y = placedPosition.func_177956_o();
        if (++y > buildHeight) {
            return;
        }
        positions.add(new BlockPos(placedPosition.func_177958_n(), y, placedPosition.func_177952_p()));
        if (++y > buildHeight) {
            return;
        }
        positions.add(new BlockPos(placedPosition.func_177958_n(), y, placedPosition.func_177952_p()));
        if (++y > buildHeight) {
            return;
        }
        positions.add(new BlockPos(placedPosition.func_177958_n(), y, placedPosition.func_177952_p()));
        if (++y > buildHeight) {
            return;
        }
        for (x = -1; x < 2; ++x) {
            for (z = -1; z < 2; ++z) {
                positions.add(new BlockPos(placedPosition.func_177958_n() + x, y, placedPosition.func_177952_p() + z));
            }
        }
        if (++y > buildHeight) {
            return;
        }
        for (x = -1; x < 2; ++x) {
            for (z = -1; z < 2; ++z) {
                positions.add(new BlockPos(placedPosition.func_177958_n() + x, y, placedPosition.func_177952_p() + z));
            }
        }
        if (++y > buildHeight) {
            return;
        }
        for (x = -3; x < 4; ++x) {
            for (z = -3; z < 4; ++z) {
                if (Math.abs(x) + Math.abs(z) == 6) continue;
                positions.add(new BlockPos(placedPosition.func_177958_n() + x, y, placedPosition.func_177952_p() + z));
            }
        }
        if (++y > buildHeight) {
            return;
        }
        for (x = -3; x < 4; ++x) {
            for (z = -3; z < 4; ++z) {
                if (Math.abs(x) + Math.abs(z) == 6) continue;
                positions.add(new BlockPos(placedPosition.func_177958_n() + x, y, placedPosition.func_177952_p() + z));
            }
        }
        if (++y > buildHeight) {
            return;
        }
        for (x = -2; x < 3; ++x) {
            for (z = -2; z < 3; ++z) {
                if (Math.abs(x) + Math.abs(z) == 4) continue;
                positions.add(new BlockPos(placedPosition.func_177958_n() + x, y, placedPosition.func_177952_p() + z));
            }
        }
    }

    @Override
    public void onDestroy(TileEntity callingBlock) {
        BlockPos thisBlock = this.func_174877_v();
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        this.getPositions(thisBlock, positions);
        for (BlockPos pos : positions) {
            IBlockState stateAt = this.field_145850_b.func_180495_p(pos);
            if (stateAt.func_177230_c() != GCBlocks.fakeBlock || stateAt.func_177229_b(BlockMulti.MULTI_TYPE) != BlockMulti.EnumBlockMultiType.DISH_LARGE) continue;
            if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextDouble() < 0.05) {
                FMLClientHandler.instance().getClient().field_71452_i.func_180533_a(pos, this.field_145850_b.func_180495_p(pos));
            }
            this.field_145850_b.func_175698_g(pos);
        }
        this.field_145850_b.func_175655_b(thisBlock, true);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.setCapacity(nbt.func_74760_g("maxEnergy"));
        this.currentAngle = nbt.func_74760_g("currentAngle");
        this.targetAngle = nbt.func_74760_g("targetAngle");
        this.setDisabled(0, nbt.func_74767_n("disabled"));
        this.disableCooldown = nbt.func_74762_e("disabledCooldown");
        this.initialised = false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74776_a("maxEnergy", this.getMaxEnergyStoredGC());
        nbt.func_74776_a("currentAngle", this.currentAngle);
        nbt.func_74776_a("targetAngle", this.targetAngle);
        nbt.func_74768_a("disabledCooldown", this.disableCooldown);
        nbt.func_74757_a("disabled", this.getDisabled(0));
        return nbt;
    }

    @Override
    public EnumSet<EnumFacing> getElectricalInputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB(this.field_174879_c.func_177982_a(-3, 0, -3), this.field_174879_c.func_177982_a(3, 8, 3));
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            this.disabled = disabled;
            this.disableCooldown = 20;
        }
    }

    @Override
    public boolean getDisabled(int index) {
        return this.disabled;
    }

    public int getScaledElecticalLevel(int i) {
        return (int)Math.floor(this.getEnergyStoredGC() * (float)i / this.getMaxEnergyStoredGC());
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return slotID == 0;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 0 && ItemElectricBase.isElectricItem(itemstack.func_77973_b());
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }
}

