/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.recipe;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ShapedRecipeNBT
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public final ItemStack[] recipeItems;
    private final ItemStack recipeOutput;
    public int recipeWidth;
    public int recipeHeight;
    private boolean copyIngredientNBT;

    public ShapedRecipeNBT(ItemStack output, Object[] layout) {
        this.recipeOutput = output;
        String shape = "";
        int idx = 0;
        int width = 0;
        int height = 0;
        while (layout[idx] instanceof String) {
            String s = (String)layout[idx++];
            shape = shape + s;
            width = s.length();
            ++height;
        }
        if (width * height != shape.length()) {
            String ret = "Invalid shaped recipe: ";
            for (Object tmp : layout) {
                ret = ret + tmp + ", ";
            }
            throw new RuntimeException(ret);
        }
        HashMap<Character, ItemStack> itemMap = new HashMap<Character, ItemStack>();
        while (idx < layout.length) {
            Character chr = (Character)layout[idx];
            Object in = layout[idx + 1];
            if (in instanceof ItemStack) {
                itemMap.put(chr, ((ItemStack)in).func_77946_l());
            } else if (in instanceof Item) {
                itemMap.put(chr, new ItemStack((Item)in));
            } else if (in instanceof Block) {
                itemMap.put(chr, new ItemStack((Block)in, 1, Short.MAX_VALUE));
            } else {
                String ret = "Invalid shaped recipe: ";
                for (Object tmp : layout) {
                    ret = ret + tmp + ", ";
                }
                throw new RuntimeException(ret);
            }
            idx += 2;
        }
        this.recipeWidth = width;
        this.recipeHeight = height;
        this.recipeItems = new ItemStack[width * height];
        int x = 0;
        for (char chr : shape.toCharArray()) {
            this.recipeItems[x++] = (ItemStack)itemMap.get(Character.valueOf(chr));
        }
    }

    @Nullable
    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        for (int i = 0; i <= 3 - this.recipeWidth; ++i) {
            for (int j = 0; j <= 3 - this.recipeHeight; ++j) {
                if (this.checkMatch(inv, i, j, false)) {
                    return true;
                }
                if (!this.checkMatch(inv, i, j, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting inv, int x, int z, boolean mirror) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack itemstack1;
                int k = i - x;
                int l = j - z;
                ItemStack target = null;
                if (k >= 0 && l >= 0 && k < this.recipeWidth && l < this.recipeHeight) {
                    target = mirror ? this.recipeItems[this.recipeWidth - k - 1 + l * this.recipeWidth] : this.recipeItems[k + l * this.recipeWidth];
                }
                if ((itemstack1 = inv.func_70463_b(i, j)).func_190926_b() && target == null) continue;
                if (itemstack1.func_190926_b() || target == null) {
                    return false;
                }
                if (target.func_77973_b() != itemstack1.func_77973_b()) {
                    return false;
                }
                if (target.func_77960_j() != Short.MAX_VALUE && target.func_77960_j() != itemstack1.func_77960_j()) {
                    return false;
                }
                if (ItemStack.func_77970_a((ItemStack)target, (ItemStack)itemstack1)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.func_77571_b().func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width >= this.recipeWidth && height >= this.recipeHeight;
    }
}

