/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.network;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.item.EnumExtendedInventorySlot;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.tile.ITileClientUpdates;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkProvider;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockPanelLighting;
import micdoodle8.mods.galacticraft.core.blocks.BlockSpaceGlass;
import micdoodle8.mods.galacticraft.core.client.FootprintRenderer;
import micdoodle8.mods.galacticraft.core.client.fx.ParticleSparks;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiBuggy;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiParaChest;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.client.sounds.GCSounds;
import micdoodle8.mods.galacticraft.core.command.CommandGCEnergyUnits;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRace;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRaceManager;
import micdoodle8.mods.galacticraft.core.dimension.SpaceStationWorldData;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseConductor;
import micdoodle8.mods.galacticraft.core.entities.EntityBuggy;
import micdoodle8.mods.galacticraft.core.entities.EntityHangingSchematic;
import micdoodle8.mods.galacticraft.core.entities.IBubbleProvider;
import micdoodle8.mods.galacticraft.core.entities.IControllableEntity;
import micdoodle8.mods.galacticraft.core.entities.player.GCEntityPlayerMP;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerHandler;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.fluid.FluidNetwork;
import micdoodle8.mods.galacticraft.core.inventory.ContainerSchematic;
import micdoodle8.mods.galacticraft.core.inventory.IInventorySettable;
import micdoodle8.mods.galacticraft.core.items.ItemParaChute;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import micdoodle8.mods.galacticraft.core.network.PacketBase;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.tick.KeyHandlerClient;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerClient;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAirLockController;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFluidPipe;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTelemetry;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.MapUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.wrappers.FlagData;
import micdoodle8.mods.galacticraft.core.wrappers.Footprint;
import micdoodle8.mods.galacticraft.core.wrappers.PlayerGearData;
import micdoodle8.mods.galacticraft.core.wrappers.ScheduledDimensionChange;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketSimple
extends PacketBase
implements Packet<INetHandler> {
    private static final Map<EntityPlayerMP, GameType> savedSettings = new HashMap<EntityPlayerMP, GameType>();
    private static String spamCheckString;
    private EnumSimplePacket type;
    private List<Object> data;

    public PacketSimple() {
    }

    public PacketSimple(EnumSimplePacket packetType, int dimID, Object[] data) {
        this(packetType, dimID, Arrays.asList(data));
    }

    public PacketSimple(EnumSimplePacket packetType, World world, Object[] data) {
        this(packetType, GCCoreUtil.getDimensionID(world), Arrays.asList(data));
    }

    public PacketSimple(EnumSimplePacket packetType, int dimID, List<Object> data) {
        super(dimID);
        if (packetType.getDecodeClasses().length != data.size()) {
            GCLog.info("Simple Packet Core found data length different than packet type");
            new RuntimeException().printStackTrace();
        }
        this.type = packetType;
        this.data = data;
    }

    @Override
    public void encodeInto(ByteBuf buffer) {
        super.encodeInto(buffer);
        buffer.writeInt(this.type.ordinal());
        try {
            NetworkUtil.encodeData(buffer, this.data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void decodeInto(ByteBuf buffer) {
        super.decodeInto(buffer);
        this.type = EnumSimplePacket.values()[buffer.readInt()];
        try {
            if (this.type.getDecodeClasses().length > 0) {
                this.data = NetworkUtil.decodeData(this.type.getDecodeClasses(), buffer);
            }
            if (buffer.readableBytes() > 0 && buffer.writerIndex() < 1048320) {
                GCLog.severe("Galacticraft packet length problem for packet type " + this.type.toString());
            }
        }
        catch (Exception e) {
            System.err.println("[Galacticraft] Error handling simple packet type: " + this.type.toString() + " " + buffer);
            e.printStackTrace();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        EntityPlayerSP playerBaseClient = null;
        GCPlayerStatsClient stats = null;
        if (player instanceof EntityPlayerSP) {
            playerBaseClient = (EntityPlayerSP)player;
            stats = GCPlayerStatsClient.get((Entity)playerBaseClient);
        } else if (this.type != EnumSimplePacket.C_UPDATE_SPACESTATION_LIST && this.type != EnumSimplePacket.C_UPDATE_PLANETS_LIST && this.type != EnumSimplePacket.C_UPDATE_CONFIGS) {
            return;
        }
        switch (this.type) {
            case C_AIR_REMAINING: {
                if (!String.valueOf(this.data.get(2)).equals(String.valueOf(PlayerUtil.getName(player)))) break;
                TickHandlerClient.airRemaining = (Integer)this.data.get(0);
                TickHandlerClient.airRemaining2 = (Integer)this.data.get(1);
                break;
            }
            case C_UPDATE_DIMENSION_LIST: {
                if (!String.valueOf(this.data.get(0)).equals(PlayerUtil.getName(player))) break;
                String dimensionList = (String)this.data.get(1);
                if (ConfigManagerCore.enableDebug && !dimensionList.equals(spamCheckString)) {
                    GCLog.info("DEBUG info: " + dimensionList);
                    spamCheckString = dimensionList;
                }
                String[] destinations = dimensionList.split("\\?");
                ArrayList possibleCelestialBodies = Lists.newArrayList();
                HashMap spaceStationData = Maps.newHashMap();
                for (String str : destinations) {
                    CelestialBody celestialBody = WorldUtil.getReachableCelestialBodiesForName(str);
                    if (celestialBody == null && str.contains("$")) {
                        String[] values = str.split("\\$");
                        int homePlanetID = Integer.parseInt(values[4]);
                        for (Satellite satellite : GalaxyRegistry.getRegisteredSatellites().values()) {
                            if (satellite.getParentPlanet().getDimensionID() != homePlanetID) continue;
                            celestialBody = satellite;
                            break;
                        }
                        if (!spaceStationData.containsKey(homePlanetID)) {
                            spaceStationData.put(homePlanetID, new HashMap());
                        }
                        ((Map)spaceStationData.get(homePlanetID)).put(values[1], new GuiCelestialSelection.StationDataGUI(values[2], Integer.parseInt(values[3])));
                    }
                    if (celestialBody == null) continue;
                    possibleCelestialBodies.add(celestialBody);
                }
                if (FMLClientHandler.instance().getClient().field_71441_e == null) break;
                if (!(FMLClientHandler.instance().getClient().field_71462_r instanceof GuiCelestialSelection)) {
                    GuiCelestialSelection gui = new GuiCelestialSelection(false, possibleCelestialBodies, (Boolean)this.data.get(2));
                    gui.spaceStationMap = spaceStationData;
                    FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)gui);
                    break;
                }
                ((GuiCelestialSelection)FMLClientHandler.instance().getClient().field_71462_r).possibleBodies = possibleCelestialBodies;
                ((GuiCelestialSelection)FMLClientHandler.instance().getClient().field_71462_r).spaceStationMap = spaceStationData;
                break;
            }
            case C_SPAWN_SPARK_PARTICLES: {
                BlockPos pos = (BlockPos)this.data.get(0);
                Minecraft mc = Minecraft.func_71410_x();
                for (int i = 0; i < 4; ++i) {
                    if (mc.func_175606_aa() == null || mc.field_71452_i == null || mc.field_71441_e == null) continue;
                    ParticleSparks fx = new ParticleSparks((World)mc.field_71441_e, (double)pos.func_177958_n() - 0.15 + 0.5, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.15 + 0.5, mc.field_71441_e.field_73012_v.nextDouble() / 20.0 - mc.field_71441_e.field_73012_v.nextDouble() / 20.0, mc.field_71441_e.field_73012_v.nextDouble() / 20.0 - mc.field_71441_e.field_73012_v.nextDouble() / 20.0);
                    mc.field_71452_i.func_78873_a((Particle)fx);
                }
                break;
            }
            case C_UPDATE_GEAR_SLOT: {
                int subtype = (Integer)this.data.get(3);
                String gearName = (String)this.data.get(0);
                EntityPlayer gearDataPlayer = player.field_70170_p.func_72924_a(gearName);
                if (gearDataPlayer == null) break;
                PlayerGearData gearData = ClientProxyCore.playerItemData.get(PlayerUtil.getName(gearDataPlayer));
                if (gearData == null) {
                    gearData = new PlayerGearData(player);
                    if (!ClientProxyCore.gearDataRequests.contains(gearName)) {
                        GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(EnumSimplePacket.S_REQUEST_GEAR_DATA, this.getDimensionID(), new Object[]{gearName}));
                        ClientProxyCore.gearDataRequests.add(gearName);
                    }
                } else {
                    ClientProxyCore.gearDataRequests.remove(gearName);
                }
                EnumExtendedInventorySlot type = EnumExtendedInventorySlot.values()[(Integer)this.data.get(2)];
                GCPlayerHandler.EnumModelPacketType typeChange = GCPlayerHandler.EnumModelPacketType.values()[(Integer)this.data.get(1)];
                switch (type) {
                    case MASK: {
                        gearData.setMask(subtype);
                        break;
                    }
                    case GEAR: {
                        gearData.setGear(subtype);
                        break;
                    }
                    case LEFT_TANK: {
                        gearData.setLeftTank(subtype);
                        break;
                    }
                    case RIGHT_TANK: {
                        gearData.setRightTank(subtype);
                        break;
                    }
                    case PARACHUTE: {
                        if (typeChange == GCPlayerHandler.EnumModelPacketType.ADD) {
                            if (subtype == -1) break;
                            String name = ItemParaChute.names[subtype];
                            gearData.setParachute(new ResourceLocation("galacticraftcore", "textures/model/parachute/" + name + ".png"));
                            break;
                        }
                        gearData.setParachute(null);
                        break;
                    }
                    case FREQUENCY_MODULE: {
                        gearData.setFrequencyModule(subtype);
                        break;
                    }
                    case THERMAL_HELMET: {
                        gearData.setThermalPadding(0, subtype);
                        break;
                    }
                    case THERMAL_CHESTPLATE: {
                        gearData.setThermalPadding(1, subtype);
                        break;
                    }
                    case THERMAL_LEGGINGS: {
                        gearData.setThermalPadding(2, subtype);
                        break;
                    }
                    case THERMAL_BOOTS: {
                        gearData.setThermalPadding(3, subtype);
                        break;
                    }
                    case SHIELD_CONTROLLER: {
                        gearData.setShieldController(subtype);
                        break;
                    }
                }
                ClientProxyCore.playerItemData.put(gearName, gearData);
                break;
            }
            case C_CLOSE_GUI: {
                FMLClientHandler.instance().getClient().func_147108_a(null);
                break;
            }
            case C_RESET_THIRD_PERSON: {
                FMLClientHandler.instance().getClient().field_71474_y.field_74320_O = stats.getThirdPersonView();
                break;
            }
            case C_UPDATE_SPACESTATION_LIST: {
                WorldUtil.decodeSpaceStationListClient(this.data);
                break;
            }
            case C_UPDATE_SPACESTATION_DATA: {
                SpaceStationWorldData var4 = SpaceStationWorldData.getMPSpaceStationData(player.field_70170_p, (Integer)this.data.get(0), player);
                var4.func_76184_a((NBTTagCompound)this.data.get(1));
                break;
            }
            case C_UPDATE_SPACESTATION_CLIENT_ID: {
                ClientProxyCore.clientSpaceStationID = WorldUtil.stringToSpaceStationData((String)this.data.get(0));
                break;
            }
            case C_UPDATE_PLANETS_LIST: {
                WorldUtil.decodePlanetsListClient(this.data);
                break;
            }
            case C_UPDATE_CONFIGS: {
                ConfigManagerCore.saveClientConfigOverrideable();
                ConfigManagerCore.setConfigOverride(this.data);
                break;
            }
            case C_ADD_NEW_SCHEMATIC: {
                ISchematicPage page = SchematicRegistry.getMatchingRecipeForID((Integer)this.data.get(0));
                if (stats.getUnlockedSchematics().contains(page)) break;
                stats.getUnlockedSchematics().add(page);
                break;
            }
            case C_UPDATE_SCHEMATIC_LIST: {
                for (Object o : this.data) {
                    Integer schematicID = (Integer)o;
                    if (schematicID == -2) continue;
                    Collections.sort(stats.getUnlockedSchematics());
                    if (stats.getUnlockedSchematics().contains(SchematicRegistry.getMatchingRecipeForID(schematicID))) continue;
                    stats.getUnlockedSchematics().add(SchematicRegistry.getMatchingRecipeForID(schematicID));
                }
                break;
            }
            case C_PLAY_SOUND_BOSS_DEATH: {
                player.func_184185_a(GCSounds.bossDeath, 10.0f, ((Float)this.data.get(0)).floatValue());
                break;
            }
            case C_PLAY_SOUND_EXPLODE: {
                player.func_184185_a(SoundEvents.field_187539_bB, 10.0f, 0.7f);
                break;
            }
            case C_PLAY_SOUND_BOSS_LAUGH: {
                player.func_184185_a(GCSounds.bossLaugh, 10.0f, 0.2f);
                break;
            }
            case C_PLAY_SOUND_BOW: {
                player.func_184185_a(SoundEvents.field_187737_v, 10.0f, 0.2f);
                break;
            }
            case C_UPDATE_OXYGEN_VALIDITY: {
                stats.setOxygenSetupValid((Boolean)this.data.get(0));
                break;
            }
            case C_OPEN_PARACHEST_GUI: {
                switch ((Integer)this.data.get(1)) {
                    case 0: {
                        if (!(player.func_184187_bx() instanceof EntityBuggy)) break;
                        FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiBuggy((IInventory)player.field_71071_by, (EntityBuggy)player.func_184187_bx(), ((EntityBuggy)player.func_184187_bx()).getType()));
                        player.field_71070_bA.field_75152_c = (Integer)this.data.get(0);
                        break;
                    }
                    case 1: {
                        int entityID = (Integer)this.data.get(2);
                        Entity entity = player.field_70170_p.func_73045_a(entityID);
                        if (entity != null && entity instanceof IInventorySettable) {
                            FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiParaChest((IInventory)player.field_71071_by, (IInventorySettable)entity));
                        }
                        player.field_71070_bA.field_75152_c = (Integer)this.data.get(0);
                    }
                }
                break;
            }
            case C_UPDATE_WIRE_BOUNDS: {
                TileEntity tile = player.field_70170_p.func_175625_s((BlockPos)this.data.get(0));
                if (!(tile instanceof TileBaseConductor)) break;
                ((TileBaseConductor)tile).adjacentConnections = null;
                break;
            }
            case C_OPEN_SPACE_RACE_GUI: {
                if (Minecraft.func_71410_x().field_71462_r == null) {
                    TickHandlerClient.spaceRaceGuiScheduled = false;
                    player.openGui((Object)GalacticraftCore.instance, 6, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                    break;
                }
                TickHandlerClient.spaceRaceGuiScheduled = true;
                break;
            }
            case C_UPDATE_SPACE_RACE_DATA: {
                Integer teamID = (Integer)this.data.get(0);
                String teamName = (String)this.data.get(1);
                FlagData flagData = (FlagData)this.data.get(2);
                Vector3 teamColor = (Vector3)this.data.get(3);
                ArrayList<String> playerList = new ArrayList<String>();
                for (int i = 4; i < this.data.size(); ++i) {
                    String playerName = (String)this.data.get(i);
                    ClientProxyCore.flagRequestsSent.remove(playerName);
                    playerList.add(playerName);
                }
                SpaceRace race = new SpaceRace(playerList, teamName, flagData, teamColor);
                race.setSpaceRaceID(teamID);
                SpaceRaceManager.addSpaceRace(race);
                break;
            }
            case C_OPEN_JOIN_RACE_GUI: {
                stats.setSpaceRaceInviteTeamID((Integer)this.data.get(0));
                player.openGui((Object)GalacticraftCore.instance, 7, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                break;
            }
            case C_UPDATE_DUNGEON_DIRECTION: {
                stats.setDungeonDirection(((Float)this.data.get(0)).floatValue());
                break;
            }
            case C_UPDATE_FOOTPRINT_LIST: {
                ArrayList<Footprint> printList = new ArrayList<Footprint>();
                long chunkKey = (Long)this.data.get(0);
                for (int i = 1; i < this.data.size(); ++i) {
                    Footprint print = (Footprint)this.data.get(i);
                    if (print.owner.equals(player.func_70005_c_())) continue;
                    printList.add(print);
                }
                FootprintRenderer.setFootprints(chunkKey, printList);
                break;
            }
            case C_FOOTPRINTS_REMOVED: {
                long chunkKey0 = (Long)this.data.get(0);
                BlockVec3 position = (BlockVec3)this.data.get(1);
                List<Footprint> footprintList = FootprintRenderer.footprints.get(chunkKey0);
                ArrayList<Footprint> toRemove = new ArrayList<Footprint>();
                if (footprintList != null) {
                    for (Footprint footprint : footprintList) {
                        if (!(footprint.position.x > (double)position.x) || !(footprint.position.x < (double)(position.x + 1)) || !(footprint.position.z > (double)position.z) || !(footprint.position.z < (double)(position.z + 1))) continue;
                        toRemove.add(footprint);
                    }
                }
                if (toRemove.isEmpty()) break;
                footprintList.removeAll(toRemove);
                FootprintRenderer.footprints.put(chunkKey0, footprintList);
                break;
            }
            case C_UPDATE_STATION_SPIN: {
                if (!(playerBaseClient.field_70170_p.field_73011_w instanceof WorldProviderSpaceStation)) break;
                ((WorldProviderSpaceStation)playerBaseClient.field_70170_p.field_73011_w).getSpinManager().setSpinRate(((Float)this.data.get(0)).floatValue(), (Boolean)this.data.get(1));
                break;
            }
            case C_UPDATE_STATION_DATA: {
                if (!(playerBaseClient.field_70170_p.field_73011_w instanceof WorldProviderSpaceStation)) break;
                ((WorldProviderSpaceStation)playerBaseClient.field_70170_p.field_73011_w).getSpinManager().setSpinCentre((Double)this.data.get(0), (Double)this.data.get(1));
                break;
            }
            case C_UPDATE_STATION_BOX: {
                if (!(playerBaseClient.field_70170_p.field_73011_w instanceof WorldProviderSpaceStation)) break;
                ((WorldProviderSpaceStation)playerBaseClient.field_70170_p.field_73011_w).getSpinManager().setSpinBox((Integer)this.data.get(0), (Integer)this.data.get(1), (Integer)this.data.get(2), (Integer)this.data.get(3), (Integer)this.data.get(4), (Integer)this.data.get(5));
                break;
            }
            case C_UPDATE_THERMAL_LEVEL: {
                stats.setThermalLevel((Integer)this.data.get(0));
                stats.setThermalLevelNormalising((Boolean)this.data.get(1));
                break;
            }
            case C_DISPLAY_ROCKET_CONTROLS: {
                player.func_145747_a((ITextComponent)new TextComponentString(GameSettings.func_74298_c((int)KeyHandlerClient.spaceKey.func_151463_i()) + "  - " + GCCoreUtil.translate("gui.rocket.launch.name")));
                player.func_145747_a((ITextComponent)new TextComponentString(GameSettings.func_74298_c((int)KeyHandlerClient.leftKey.func_151463_i()) + " / " + GameSettings.func_74298_c((int)KeyHandlerClient.rightKey.func_151463_i()) + "  - " + GCCoreUtil.translate("gui.rocket.turn.name")));
                player.func_145747_a((ITextComponent)new TextComponentString(GameSettings.func_74298_c((int)KeyHandlerClient.accelerateKey.func_151463_i()) + " / " + GameSettings.func_74298_c((int)KeyHandlerClient.decelerateKey.func_151463_i()) + "  - " + GCCoreUtil.translate("gui.rocket.updown.name")));
                break;
            }
            case C_GET_CELESTIAL_BODY_LIST: {
                String str = "";
                for (CelestialBody celestialBody : GalaxyRegistry.getRegisteredPlanets().values()) {
                    str = str.concat(celestialBody.getUnlocalizedName() + ";");
                }
                for (CelestialBody celestialBody : GalaxyRegistry.getRegisteredMoons().values()) {
                    str = str.concat(celestialBody.getUnlocalizedName() + ";");
                }
                for (CelestialBody celestialBody : GalaxyRegistry.getRegisteredSatellites().values()) {
                    str = str.concat(celestialBody.getUnlocalizedName() + ";");
                }
                for (SolarSystem solarSystem : GalaxyRegistry.getRegisteredSolarSystems().values()) {
                    str = str.concat(solarSystem.getUnlocalizedName() + ";");
                }
                GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(EnumSimplePacket.S_COMPLETE_CBODY_HANDSHAKE, this.getDimensionID(), new Object[]{str}));
                break;
            }
            case C_UPDATE_ENERGYUNITS: {
                CommandGCEnergyUnits.handleParamClientside((Integer)this.data.get(0));
                break;
            }
            case C_RESPAWN_PLAYER: {
                WorldProvider provider = WorldUtil.getProviderForNameClient((String)this.data.get(0));
                int n = GCCoreUtil.getDimensionID(provider);
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info("DEBUG: Client receiving respawn packet for dim " + n);
                }
                int par2 = (Integer)this.data.get(1);
                String par3 = (String)this.data.get(2);
                int par4 = (Integer)this.data.get(3);
                WorldUtil.forceRespawnClient(n, par2, par3, par4);
                break;
            }
            case C_UPDATE_STATS: {
                stats.setBuildFlags((Integer)this.data.get(0));
                BlockPanelLighting.updateClient(this.data);
                break;
            }
            case C_UPDATE_TELEMETRY: {
                TileEntity tile = player.field_70170_p.func_175625_s((BlockPos)this.data.get(0));
                if (!(tile instanceof TileEntityTelemetry)) break;
                ((TileEntityTelemetry)tile).receiveUpdate(this.data, this.getDimensionID());
                break;
            }
            case C_SEND_PLAYERSKIN: {
                String strName = (String)this.data.get(0);
                String s1 = (String)this.data.get(1);
                String s2 = (String)this.data.get(2);
                String strUUID = (String)this.data.get(3);
                GameProfile gp = PlayerUtil.getOtherPlayerProfile(strName);
                if (gp == null) {
                    gp = PlayerUtil.makeOtherPlayerProfile(strName, strUUID);
                }
                gp.getProperties().put((Object)"textures", (Object)new Property("textures", s1, s2));
                break;
            }
            case C_SEND_OVERWORLD_IMAGE: {
                try {
                    int cx = (Integer)this.data.get(0);
                    int cz = (Integer)this.data.get(1);
                    byte[] bytes = (byte[])this.data.get(2);
                    MapUtil.receiveOverworldImageCompressed(cx, cz, bytes);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case C_RECOLOR_PIPE: {
                TileEntity tileEntity = player.field_70170_p.func_175625_s((BlockPos)this.data.get(0));
                if (!(tileEntity instanceof TileEntityFluidPipe)) break;
                TileEntityFluidPipe pipe = (TileEntityFluidPipe)tileEntity;
                pipe.getNetwork().split(pipe);
                pipe.setNetwork(null);
                break;
            }
            case C_RECOLOR_ALL_GLASS: {
                BlockSpaceGlass.updateGlassColors((Integer)this.data.get(0), (Integer)this.data.get(1), (Integer)this.data.get(2));
                break;
            }
            case C_UPDATE_MACHINE_DATA: {
                TileEntity tile3 = player.field_70170_p.func_175625_s((BlockPos)this.data.get(0));
                if (!(tile3 instanceof ITileClientUpdates)) break;
                ((ITileClientUpdates)tile3).updateClient(this.data);
                break;
            }
            case C_LEAK_DATA: {
                TileEntity tile4 = player.field_70170_p.func_175625_s((BlockPos)this.data.get(0));
                if (!(tile4 instanceof TileEntityOxygenSealer)) break;
                ((ITileClientUpdates)tile4).updateClient(this.data);
                break;
            }
            case C_SPAWN_HANGING_SCHEMATIC: {
                EntityHangingSchematic entity = new EntityHangingSchematic(player.field_70170_p, (BlockPos)this.data.get(0), EnumFacing.func_82600_a((int)((Integer)this.data.get(2))), (Integer)this.data.get(3));
                ((WorldClient)player.field_70170_p).func_73027_a(((Integer)this.data.get(1)).intValue(), (Entity)entity);
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handleServerSide(EntityPlayer player) {
        EntityPlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer(player, false);
        if (playerBase == null) {
            return;
        }
        MinecraftServer server = playerBase.field_71133_b;
        GCPlayerStats stats = GCPlayerStats.get((Entity)playerBase);
        block1 : switch (this.type) {
            case S_RESPAWN_PLAYER: {
                playerBase.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, player.field_70170_p.func_175659_aa(), player.field_70170_p.func_72912_H().func_76067_t(), playerBase.field_71134_c.func_73081_b()));
                break;
            }
            case S_TELEPORT_ENTITY: {
                TickHandlerServer.scheduleNewDimensionChange(new ScheduledDimensionChange(playerBase, (String)this.data.get(0)));
                break;
            }
            case S_IGNITE_ROCKET: {
                if (player.field_70170_p.field_72995_K || player.field_70128_L || player.func_184187_bx() == null || player.func_184187_bx().field_70128_L || !(player.func_184187_bx() instanceof EntityTieredRocket)) break;
                EntityTieredRocket ship = (EntityTieredRocket)player.func_184187_bx();
                if (ship.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal()) break;
                if (ship.fuelTank.getFluidAmount() == ship.fuelTank.getCapacity()) {
                    ItemStack stack2 = stats.getExtendedInventory().func_70301_a(4);
                    if (stack2 != null && stack2.func_77973_b() instanceof ItemParaChute || stats.getLaunchAttempts() > 0) {
                        ship.igniteCheckingCooldown();
                        stats.setLaunchAttempts(0);
                        break;
                    }
                    if (stats.getChatCooldown() != 0 || stats.getLaunchAttempts() != 0) break;
                    player.func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translate("gui.rocket.warning.noparachute")));
                    stats.setChatCooldown(250);
                    stats.setLaunchAttempts(1);
                    break;
                }
                player.func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translate("gui.rocket.warning.nofuel")));
                stats.setChatCooldown(250);
                break;
            }
            case S_OPEN_SCHEMATIC_PAGE: {
                if (player == null) break;
                ISchematicPage page = SchematicRegistry.getMatchingRecipeForID((Integer)this.data.get(0));
                player.openGui((Object)GalacticraftCore.instance, page.getGuiID(), player.field_70170_p, ((Integer)this.data.get(1)).intValue(), ((Integer)this.data.get(2)).intValue(), ((Integer)this.data.get(3)).intValue());
                break;
            }
            case S_OPEN_FUEL_GUI: {
                if (player.func_184187_bx() instanceof EntityBuggy) {
                    GCCoreUtil.openBuggyInv(playerBase, (EntityBuggy)player.func_184187_bx(), ((EntityBuggy)player.func_184187_bx()).getType());
                    break;
                }
                if (!(player.func_184187_bx() instanceof EntitySpaceshipBase)) break;
                player.openGui((Object)GalacticraftCore.instance, 4, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                break;
            }
            case S_UPDATE_SHIP_YAW: {
                EntitySpaceshipBase ship;
                if (!(player.func_184187_bx() instanceof EntitySpaceshipBase) || (ship = (EntitySpaceshipBase)player.func_184187_bx()) == null) break;
                ship.field_70177_z = ((Float)this.data.get(0)).floatValue();
                break;
            }
            case S_UPDATE_SHIP_PITCH: {
                EntitySpaceshipBase ship;
                if (!(player.func_184187_bx() instanceof EntitySpaceshipBase) || (ship = (EntitySpaceshipBase)player.func_184187_bx()) == null) break;
                ship.field_70125_A = ((Float)this.data.get(0)).floatValue();
                break;
            }
            case S_SET_ENTITY_FIRE: {
                Entity entity = player.field_70170_p.func_73045_a(((Integer)this.data.get(0)).intValue());
                if (!(entity instanceof EntityLivingBase)) break;
                entity.func_70015_d(3);
                break;
            }
            case S_BIND_SPACE_STATION_ID: {
                int homeID = (Integer)this.data.get(0);
                if (stats.getSpaceStationDimensionData().containsKey(homeID) && stats.getSpaceStationDimensionData().get(homeID) != -1 && stats.getSpaceStationDimensionData().get(homeID) != 0 || ConfigManagerCore.disableSpaceStationCreation || !playerBase.field_71075_bZ.field_75098_d && !WorldUtil.getSpaceStationRecipe(homeID).matches((EntityPlayer)playerBase, true)) break;
                WorldUtil.bindSpaceStationToNewDimension(playerBase.field_70170_p, playerBase, homeID);
                break;
            }
            case S_UNLOCK_NEW_SCHEMATIC: {
                ISchematicPage page;
                Container container = player.field_71070_bA;
                if (!(container instanceof ContainerSchematic)) break;
                ContainerSchematic schematicContainer = (ContainerSchematic)container;
                ItemStack stack = schematicContainer.craftMatrix.func_70301_a(0);
                if (stack.func_190926_b() || (page = SchematicRegistry.getMatchingRecipeForItemStack(stack)) == null) break;
                SchematicRegistry.unlockNewPage(playerBase, stack);
                SpaceRaceManager.teamUnlockSchematic(playerBase, stack);
                stack.func_190918_g(1);
                schematicContainer.craftMatrix.func_70299_a(0, stack);
                schematicContainer.craftMatrix.func_70296_d();
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(EnumSimplePacket.C_ADD_NEW_SCHEMATIC, this.getDimensionID(), new Object[]{page.getPageID()}), playerBase);
                break;
            }
            case S_UPDATE_DISABLEABLE_BUTTON: {
                TileEntity tileAt = player.field_70170_p.func_175625_s((BlockPos)this.data.get(0));
                if (!(tileAt instanceof IDisableableMachine)) break;
                IDisableableMachine machine = (IDisableableMachine)tileAt;
                machine.setDisabled((Integer)this.data.get(1), !machine.getDisabled((Integer)this.data.get(1)));
                break;
            }
            case S_ON_FAILED_CHEST_UNLOCK: {
                if (stats.getChatCooldown() != 0) break;
                player.func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translateWithFormat("gui.chest.warning.wrongkey", this.data.get(0))));
                stats.setChatCooldown(100);
                break;
            }
            case S_RENAME_SPACE_STATION: {
                SpaceStationWorldData ssdata = SpaceStationWorldData.getStationData(playerBase.field_70170_p, (Integer)this.data.get(1), (EntityPlayer)playerBase);
                if (ssdata == null || !ssdata.getOwner().equalsIgnoreCase(PlayerUtil.getName(player))) break;
                ssdata.setSpaceStationName((String)this.data.get(0));
                ssdata.func_76186_a(true);
                break;
            }
            case S_OPEN_EXTENDED_INVENTORY: {
                player.openGui((Object)GalacticraftCore.instance, 5, player.field_70170_p, 0, 0, 0);
                break;
            }
            case S_ON_ADVANCED_GUI_CLICKED_INT: {
                TileEntity tile1 = player.field_70170_p.func_175625_s((BlockPos)this.data.get(1));
                switch ((Integer)this.data.get(0)) {
                    case 0: {
                        if (!(tile1 instanceof TileEntityAirLockController)) break block1;
                        TileEntityAirLockController airlockController = (TileEntityAirLockController)tile1;
                        airlockController.redstoneActivation = (Integer)this.data.get(2) == 1;
                        break block1;
                    }
                    case 1: {
                        if (!(tile1 instanceof TileEntityAirLockController)) break block1;
                        TileEntityAirLockController airlockController = (TileEntityAirLockController)tile1;
                        airlockController.playerDistanceActivation = (Integer)this.data.get(2) == 1;
                        break block1;
                    }
                    case 2: {
                        if (!(tile1 instanceof TileEntityAirLockController)) break block1;
                        TileEntityAirLockController airlockController = (TileEntityAirLockController)tile1;
                        airlockController.playerDistanceSelection = (Integer)this.data.get(2);
                        break block1;
                    }
                    case 3: {
                        if (!(tile1 instanceof TileEntityAirLockController)) break block1;
                        TileEntityAirLockController airlockController = (TileEntityAirLockController)tile1;
                        airlockController.playerNameMatches = (Integer)this.data.get(2) == 1;
                        break block1;
                    }
                    case 4: {
                        if (!(tile1 instanceof TileEntityAirLockController)) break block1;
                        TileEntityAirLockController airlockController = (TileEntityAirLockController)tile1;
                        airlockController.invertSelection = (Integer)this.data.get(2) == 1;
                        break block1;
                    }
                    case 5: {
                        if (!(tile1 instanceof TileEntityAirLockController)) break block1;
                        TileEntityAirLockController airlockController = (TileEntityAirLockController)tile1;
                        airlockController.lastHorizontalModeEnabled = airlockController.horizontalModeEnabled;
                        airlockController.horizontalModeEnabled = (Integer)this.data.get(2) == 1;
                        break block1;
                    }
                    case 6: {
                        if (!(tile1 instanceof IBubbleProvider)) break block1;
                        IBubbleProvider distributor = (IBubbleProvider)tile1;
                        distributor.setBubbleVisible((Integer)this.data.get(2) == 1);
                        break block1;
                    }
                }
                break;
            }
            case S_ON_ADVANCED_GUI_CLICKED_STRING: {
                TileEntity tile2 = player.field_70170_p.func_175625_s((BlockPos)this.data.get(1));
                switch ((Integer)this.data.get(0)) {
                    case 0: {
                        if (!(tile2 instanceof TileEntityAirLockController)) break block1;
                        TileEntityAirLockController airlockController = (TileEntityAirLockController)tile2;
                        airlockController.playerToOpenFor = (String)this.data.get(2);
                        break block1;
                    }
                }
                break;
            }
            case S_UPDATE_SHIP_MOTION_Y: {
                int entityID = (Integer)this.data.get(0);
                boolean up = (Boolean)this.data.get(1);
                Entity entity2 = player.field_70170_p.func_73045_a(entityID);
                if (!(entity2 instanceof EntityAutoRocket)) break;
                EntityAutoRocket autoRocket = (EntityAutoRocket)entity2;
                autoRocket.field_70181_x = autoRocket.field_70181_x + (up ? (double)0.02f : (double)-0.02f);
                break;
            }
            case S_START_NEW_SPACE_RACE: {
                Integer teamID = (Integer)this.data.get(0);
                String teamName = (String)this.data.get(1);
                FlagData flagData = (FlagData)this.data.get(2);
                Vector3 teamColor = (Vector3)this.data.get(3);
                ArrayList<String> playerList = new ArrayList<String>();
                for (int i = 4; i < this.data.size(); ++i) {
                    playerList.add((String)this.data.get(i));
                }
                boolean previousData = SpaceRaceManager.getSpaceRaceFromID(teamID) != null;
                SpaceRace newRace = new SpaceRace(playerList, teamName, flagData, teamColor);
                if (teamID > 0) {
                    newRace.setSpaceRaceID(teamID);
                }
                SpaceRaceManager.addSpaceRace(newRace);
                if (!previousData) break;
                SpaceRaceManager.sendSpaceRaceData(server, null, SpaceRaceManager.getSpaceRaceFromPlayer(PlayerUtil.getName((EntityPlayer)playerBase)));
                break;
            }
            case S_REQUEST_FLAG_DATA: {
                SpaceRaceManager.sendSpaceRaceData(server, playerBase, SpaceRaceManager.getSpaceRaceFromPlayer((String)this.data.get(0)));
                break;
            }
            case S_INVITE_RACE_PLAYER: {
                void var32_67;
                String[] teamNameSplit;
                Integer teamInvitedTo;
                SpaceRace race;
                EntityPlayerMP playerInvited = PlayerUtil.getPlayerBaseServerFromPlayerUsername(server, (String)this.data.get(0), true);
                if (playerInvited == null || (race = SpaceRaceManager.getSpaceRaceFromID(teamInvitedTo = (Integer)this.data.get(1))) == null) break;
                GCPlayerStats.get((Entity)playerInvited).setSpaceRaceInviteTeamID(teamInvitedTo);
                String dA = EnumColor.DARK_AQUA.getCode();
                String bG = EnumColor.BRIGHT_GREEN.getCode();
                String dB = EnumColor.PURPLE.getCode();
                String teamNameTotal = "";
                String[] stringArray = teamNameSplit = race.getTeamName().split(" ");
                int n = stringArray.length;
                boolean bl = false;
                while (var32_67 < n) {
                    String teamNamePart = stringArray[var32_67];
                    teamNameTotal = teamNameTotal.concat(dB + teamNamePart + " ");
                    ++var32_67;
                }
                playerInvited.func_145747_a(new TextComponentString(dA + GCCoreUtil.translateWithFormat("gui.space_race.chat.invite_received", bG + PlayerUtil.getName(player) + dA) + "  " + GCCoreUtil.translateWithFormat("gui.space_race.chat.to_join", teamNameTotal, (Object)((Object)EnumColor.AQUA) + "/joinrace" + dA)).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_AQUA)));
                break;
            }
            case S_REMOVE_RACE_PLAYER: {
                Integer teamInvitedTo = (Integer)this.data.get(1);
                SpaceRace race = SpaceRaceManager.getSpaceRaceFromID(teamInvitedTo);
                if (race == null) break;
                String playerToRemove = (String)this.data.get(0);
                if (!race.getPlayerNames().remove(playerToRemove)) {
                    player.func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translateWithFormat("gui.space_race.chat.not_found", playerToRemove)));
                    break;
                }
                SpaceRaceManager.onPlayerRemoval(server, playerToRemove, race);
                break;
            }
            case S_ADD_RACE_PLAYER: {
                Integer teamToAddPlayer = (Integer)this.data.get(1);
                SpaceRace spaceRaceToAddPlayer = SpaceRaceManager.getSpaceRaceFromID(teamToAddPlayer);
                if (spaceRaceToAddPlayer == null) break;
                String playerToAdd = (String)this.data.get(0);
                if (!spaceRaceToAddPlayer.getPlayerNames().contains(playerToAdd)) {
                    SpaceRace oldRace = null;
                    while ((oldRace = SpaceRaceManager.getSpaceRaceFromPlayer(playerToAdd)) != null) {
                        SpaceRaceManager.removeSpaceRace(oldRace);
                    }
                    spaceRaceToAddPlayer.getPlayerNames().add(playerToAdd);
                    SpaceRaceManager.sendSpaceRaceData(server, null, spaceRaceToAddPlayer);
                    for (String member : spaceRaceToAddPlayer.getPlayerNames()) {
                        EntityPlayerMP memberObj = PlayerUtil.getPlayerForUsernameVanilla(server, member);
                        if (memberObj == null) continue;
                        memberObj.func_145747_a(new TextComponentString((Object)((Object)EnumColor.DARK_AQUA) + GCCoreUtil.translateWithFormat("gui.space_race.chat.add_success", (Object)((Object)EnumColor.BRIGHT_GREEN) + playerToAdd + (Object)((Object)EnumColor.DARK_AQUA))).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_AQUA)));
                    }
                    break;
                }
                player.func_145747_a(new TextComponentString(GCCoreUtil.translate("gui.space_race.chat.already_part")).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
                break;
            }
            case S_COMPLETE_CBODY_HANDSHAKE: {
                String completeList = (String)this.data.get(0);
                List<String> clientObjects = Arrays.asList(completeList.split(";"));
                ArrayList serverObjects = Lists.newArrayList();
                String missingObjects = "";
                for (CelestialBody celestialBody : GalaxyRegistry.getRegisteredPlanets().values()) {
                    serverObjects.add(celestialBody.getUnlocalizedName());
                }
                for (CelestialBody celestialBody : GalaxyRegistry.getRegisteredMoons().values()) {
                    serverObjects.add(celestialBody.getUnlocalizedName());
                }
                for (CelestialBody celestialBody : GalaxyRegistry.getRegisteredSatellites().values()) {
                    serverObjects.add(celestialBody.getUnlocalizedName());
                }
                for (SolarSystem solarSystem : GalaxyRegistry.getRegisteredSolarSystems().values()) {
                    serverObjects.add(solarSystem.getUnlocalizedName());
                }
                for (String string : serverObjects) {
                    if (clientObjects.contains(string)) continue;
                    missingObjects = missingObjects.concat(string + "\n");
                }
                if (missingObjects.length() <= 0) break;
                playerBase.field_71135_a.func_194028_b((ITextComponent)new TextComponentString("Missing Galacticraft Celestial Objects:\n\n " + missingObjects));
                break;
            }
            case S_REQUEST_GEAR_DATA: {
                String name = (String)this.data.get(0);
                EntityPlayerMP entityPlayerMP = PlayerUtil.getPlayerBaseServerFromPlayerUsername(name, true);
                if (entityPlayerMP == null) break;
                GCPlayerHandler.checkGear(entityPlayerMP, GCPlayerStats.get((Entity)entityPlayerMP), true);
                break;
            }
            case S_BUILDFLAGS_UPDATE: {
                stats.setBuildFlags((Integer)this.data.get(0));
                break;
            }
            case S_REQUEST_OVERWORLD_IMAGE: {
                MapUtil.sendOverworldToClient(playerBase);
                break;
            }
            case S_REQUEST_MAP_IMAGE: {
                int dim = (Integer)this.data.get(0);
                int cx = (Integer)this.data.get(1);
                int cz = (Integer)this.data.get(2);
                MapUtil.sendOrCreateMap(WorldUtil.getProviderForDimensionServer((int)dim).field_76579_a, cx, cz, playerBase);
                break;
            }
            case S_REQUEST_PLAYERSKIN: {
                String strName = (String)this.data.get(0);
                EntityPlayerMP playerRequested = server.func_184103_al().func_152612_a(strName);
                if (playerRequested == null) {
                    return;
                }
                GameProfile gp = playerRequested.func_146103_bH();
                if (gp == null) {
                    return;
                }
                Property property = (Property)Iterables.getFirst((Iterable)gp.getProperties().get((Object)"textures"), null);
                if (property == null) {
                    return;
                }
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(EnumSimplePacket.C_SEND_PLAYERSKIN, this.getDimensionID(), new Object[]{strName, property.getValue(), property.getSignature(), playerRequested.func_110124_au().toString()}), playerBase);
                break;
            }
            case S_CONTROL_ENTITY: {
                if (player.func_184187_bx() == null || !(player.func_184187_bx() instanceof IControllableEntity)) break;
                ((IControllableEntity)player.func_184187_bx()).pressKey((Integer)this.data.get(0));
                break;
            }
            case S_NOCLIP_PLAYER: {
                boolean noClip = (Boolean)this.data.get(0);
                if (player instanceof GCEntityPlayerMP) {
                    GalacticraftCore.proxy.player.setNoClip((EntityPlayerMP)player, noClip);
                    if (noClip) break;
                    player.field_70143_R = 0.0f;
                    ((EntityPlayerMP)player).field_71135_a.field_147365_f = 0;
                    break;
                }
                if (!(player instanceof EntityPlayerMP)) break;
                EntityPlayerMP emp = (EntityPlayerMP)player;
                try {
                    Field f = emp.field_71134_c.getClass().getDeclaredField(GCCoreUtil.isDeobfuscated() ? "gameType" : "field_73091_c");
                    f.setAccessible(true);
                    if (!noClip) {
                        emp.field_70143_R = 0.0f;
                        emp.field_71135_a.field_147365_f = 0;
                        GameType gt = savedSettings.get(emp);
                        if (gt == null) break;
                        savedSettings.remove(emp);
                        f.set(emp.field_71134_c, gt);
                        break;
                    }
                    savedSettings.put(emp, emp.field_71134_c.func_73081_b());
                    f.set(emp.field_71134_c, GameType.SPECTATOR);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
                break;
            }
            case S_REQUEST_DATA: {
                TileEntity requestedTile;
                WorldServer worldServer = server.func_71218_a(((Integer)this.data.get(0)).intValue());
                if (worldServer == null || !((requestedTile = worldServer.func_175625_s((BlockPos)this.data.get(1))) instanceof INetworkProvider) || !(((INetworkProvider)requestedTile).getNetwork() instanceof FluidNetwork)) break;
                FluidNetwork network = (FluidNetwork)((INetworkProvider)requestedTile).getNetwork();
                network.addUpdate(playerBase);
                break;
            }
            case S_UPDATE_CHECKLIST: {
                for (EnumHand enumhand : EnumHand.values()) {
                    ItemStack stack = player.func_184586_b(enumhand);
                    if (stack == null || stack.func_77973_b() != GCItems.prelaunchChecklist) continue;
                    NBTTagCompound tagCompound = stack.func_77978_p();
                    if (tagCompound == null) {
                        tagCompound = new NBTTagCompound();
                    }
                    NBTTagCompound tagCompoundRead = (NBTTagCompound)this.data.get(0);
                    tagCompound.func_74782_a("checklistData", (NBTBase)tagCompoundRead);
                    stack.func_77982_d(tagCompound);
                }
                break;
            }
            case S_REQUEST_MACHINE_DATA: {
                TileEntity tile3 = player.field_70170_p.func_175625_s((BlockPos)this.data.get(0));
                if (!(tile3 instanceof ITileClientUpdates)) break;
                ((ITileClientUpdates)tile3).sendUpdateToClient(playerBase);
                break;
            }
        }
    }

    public void func_148837_a(PacketBuffer var1) {
        this.decodeInto((ByteBuf)var1);
    }

    public void func_148840_b(PacketBuffer var1) {
        this.encodeInto((ByteBuf)var1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_148833_a(INetHandler var1) {
        if (this.type != EnumSimplePacket.C_UPDATE_SPACESTATION_LIST && this.type != EnumSimplePacket.C_UPDATE_PLANETS_LIST && this.type != EnumSimplePacket.C_UPDATE_CONFIGS) {
            return;
        }
        if (GCCoreUtil.getEffectiveSide() == Side.CLIENT) {
            this.handleClientSide((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
        }
    }

    public static enum EnumSimplePacket {
        S_RESPAWN_PLAYER(Side.SERVER, String.class),
        S_TELEPORT_ENTITY(Side.SERVER, String.class),
        S_IGNITE_ROCKET(Side.SERVER, new Class[0]),
        S_OPEN_SCHEMATIC_PAGE(Side.SERVER, Integer.class, Integer.class, Integer.class, Integer.class),
        S_OPEN_FUEL_GUI(Side.SERVER, String.class),
        S_UPDATE_SHIP_YAW(Side.SERVER, Float.class),
        S_UPDATE_SHIP_PITCH(Side.SERVER, Float.class),
        S_SET_ENTITY_FIRE(Side.SERVER, Integer.class),
        S_BIND_SPACE_STATION_ID(Side.SERVER, Integer.class),
        S_UNLOCK_NEW_SCHEMATIC(Side.SERVER, new Class[0]),
        S_UPDATE_DISABLEABLE_BUTTON(Side.SERVER, BlockPos.class, Integer.class),
        S_ON_FAILED_CHEST_UNLOCK(Side.SERVER, Integer.class),
        S_RENAME_SPACE_STATION(Side.SERVER, String.class, Integer.class),
        S_OPEN_EXTENDED_INVENTORY(Side.SERVER, new Class[0]),
        S_ON_ADVANCED_GUI_CLICKED_INT(Side.SERVER, Integer.class, BlockPos.class, Integer.class),
        S_ON_ADVANCED_GUI_CLICKED_STRING(Side.SERVER, Integer.class, BlockPos.class, String.class),
        S_UPDATE_SHIP_MOTION_Y(Side.SERVER, Integer.class, Boolean.class),
        S_START_NEW_SPACE_RACE(Side.SERVER, Integer.class, String.class, FlagData.class, Vector3.class, String[].class),
        S_REQUEST_FLAG_DATA(Side.SERVER, String.class),
        S_INVITE_RACE_PLAYER(Side.SERVER, String.class, Integer.class),
        S_REMOVE_RACE_PLAYER(Side.SERVER, String.class, Integer.class),
        S_ADD_RACE_PLAYER(Side.SERVER, String.class, Integer.class),
        S_COMPLETE_CBODY_HANDSHAKE(Side.SERVER, String.class),
        S_REQUEST_GEAR_DATA(Side.SERVER, String.class),
        S_REQUEST_OVERWORLD_IMAGE(Side.SERVER, new Class[0]),
        S_REQUEST_MAP_IMAGE(Side.SERVER, Integer.class, Integer.class, Integer.class),
        S_REQUEST_PLAYERSKIN(Side.SERVER, String.class),
        S_BUILDFLAGS_UPDATE(Side.SERVER, Integer.class),
        S_CONTROL_ENTITY(Side.SERVER, Integer.class),
        S_NOCLIP_PLAYER(Side.SERVER, Boolean.class),
        S_REQUEST_DATA(Side.SERVER, Integer.class, BlockPos.class),
        S_UPDATE_CHECKLIST(Side.SERVER, NBTTagCompound.class),
        S_REQUEST_MACHINE_DATA(Side.SERVER, BlockPos.class),
        C_AIR_REMAINING(Side.CLIENT, Integer.class, Integer.class, String.class),
        C_UPDATE_DIMENSION_LIST(Side.CLIENT, String.class, String.class, Boolean.class),
        C_SPAWN_SPARK_PARTICLES(Side.CLIENT, BlockPos.class),
        C_UPDATE_GEAR_SLOT(Side.CLIENT, String.class, Integer.class, Integer.class, Integer.class),
        C_CLOSE_GUI(Side.CLIENT, new Class[0]),
        C_RESET_THIRD_PERSON(Side.CLIENT, new Class[0]),
        C_UPDATE_SPACESTATION_LIST(Side.CLIENT, Integer[].class),
        C_UPDATE_SPACESTATION_DATA(Side.CLIENT, Integer.class, NBTTagCompound.class),
        C_UPDATE_SPACESTATION_CLIENT_ID(Side.CLIENT, String.class),
        C_UPDATE_PLANETS_LIST(Side.CLIENT, Integer[].class),
        C_UPDATE_CONFIGS(Side.CLIENT, Integer.class, Double.class, Integer.class, Integer.class, Integer.class, String.class, Float.class, Float.class, Float.class, Float.class, Integer.class, String[].class),
        C_UPDATE_STATS(Side.CLIENT, Integer.class, String.class, Integer.class, String.class, Integer.class, String.class, Integer.class, String.class, Integer.class, String.class, Integer.class, Integer.class),
        C_ADD_NEW_SCHEMATIC(Side.CLIENT, Integer.class),
        C_UPDATE_SCHEMATIC_LIST(Side.CLIENT, Integer[].class),
        C_PLAY_SOUND_BOSS_DEATH(Side.CLIENT, Float.class),
        C_PLAY_SOUND_EXPLODE(Side.CLIENT, new Class[0]),
        C_PLAY_SOUND_BOSS_LAUGH(Side.CLIENT, new Class[0]),
        C_PLAY_SOUND_BOW(Side.CLIENT, new Class[0]),
        C_UPDATE_OXYGEN_VALIDITY(Side.CLIENT, Boolean.class),
        C_OPEN_PARACHEST_GUI(Side.CLIENT, Integer.class, Integer.class, Integer.class),
        C_UPDATE_WIRE_BOUNDS(Side.CLIENT, BlockPos.class),
        C_OPEN_SPACE_RACE_GUI(Side.CLIENT, new Class[0]),
        C_UPDATE_SPACE_RACE_DATA(Side.CLIENT, Integer.class, String.class, FlagData.class, Vector3.class, String[].class),
        C_OPEN_JOIN_RACE_GUI(Side.CLIENT, Integer.class),
        C_UPDATE_FOOTPRINT_LIST(Side.CLIENT, Long.class, Footprint[].class),
        C_UPDATE_DUNGEON_DIRECTION(Side.CLIENT, Float.class),
        C_FOOTPRINTS_REMOVED(Side.CLIENT, Long.class, BlockVec3.class),
        C_UPDATE_STATION_SPIN(Side.CLIENT, Float.class, Boolean.class),
        C_UPDATE_STATION_DATA(Side.CLIENT, Double.class, Double.class),
        C_UPDATE_STATION_BOX(Side.CLIENT, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class),
        C_UPDATE_THERMAL_LEVEL(Side.CLIENT, Integer.class, Boolean.class),
        C_DISPLAY_ROCKET_CONTROLS(Side.CLIENT, new Class[0]),
        C_GET_CELESTIAL_BODY_LIST(Side.CLIENT, new Class[0]),
        C_UPDATE_ENERGYUNITS(Side.CLIENT, Integer.class),
        C_RESPAWN_PLAYER(Side.CLIENT, String.class, Integer.class, String.class, Integer.class),
        C_UPDATE_TELEMETRY(Side.CLIENT, BlockPos.class, String.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, String.class),
        C_SEND_PLAYERSKIN(Side.CLIENT, String.class, String.class, String.class, String.class),
        C_SEND_OVERWORLD_IMAGE(Side.CLIENT, Integer.class, Integer.class, byte[].class),
        C_RECOLOR_PIPE(Side.CLIENT, BlockPos.class),
        C_RECOLOR_ALL_GLASS(Side.CLIENT, Integer.class, Integer.class, Integer.class),
        C_UPDATE_MACHINE_DATA(Side.CLIENT, BlockPos.class, Integer.class, Integer.class, Integer.class, Integer.class),
        C_SPAWN_HANGING_SCHEMATIC(Side.CLIENT, BlockPos.class, Integer.class, Integer.class, Integer.class),
        C_LEAK_DATA(Side.CLIENT, BlockPos.class, Integer[].class);

        private final Side targetSide;
        private final Class<?>[] decodeAs;

        private EnumSimplePacket(Side targetSide, Class<?> ... decodeAs) {
            this.targetSide = targetSide;
            this.decodeAs = decodeAs;
        }

        public Side getTargetSide() {
            return this.targetSide;
        }

        public Class<?>[] getDecodeClasses() {
            return this.decodeAs;
        }
    }
}

