/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;

public abstract class EntityAdvanced
extends Entity
implements IPacketReceiver {
    private final Map<Field, Object> lastSentData = new HashMap<Field, Object>();
    protected long ticks = 0L;
    private LinkedHashSet<Field> fieldCacheClient;
    private LinkedHashSet<Field> fieldCacheServer;
    private boolean networkDataChanged = false;

    public EntityAdvanced(World world) {
        super(world);
        if (world != null && world.field_72995_K) {
            this.fieldCacheServer = new LinkedHashSet();
            GalacticraftCore.packetPipeline.sendToServer(new PacketDynamic(this));
        }
    }

    public abstract boolean isNetworkedEntity();

    public abstract int getPacketCooldown(Side var1);

    public abstract void onPacketClient(EntityPlayer var1);

    public abstract void onPacketServer(EntityPlayer var1);

    public abstract double getPacketRange();

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.ticks;
        if (this.isNetworkedEntity()) {
            PacketDynamic packet;
            if (!this.field_70170_p.field_72995_K && this.ticks % (long)this.getPacketCooldown(Side.CLIENT) == 0L) {
                if (this.fieldCacheClient == null) {
                    try {
                        this.initFieldCache();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                packet = new PacketDynamic(this);
                if (this.networkDataChanged) {
                    GalacticraftCore.packetPipeline.sendToAllAround(packet, new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID(this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getPacketRange()));
                }
            }
            if (this.field_70170_p.field_72995_K && this.ticks % (long)this.getPacketCooldown(Side.SERVER) == 0L) {
                if (this.fieldCacheClient == null) {
                    try {
                        this.initFieldCache();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                packet = new PacketDynamic(this);
                if (this.networkDataChanged) {
                    GalacticraftCore.packetPipeline.sendToServer(packet);
                }
            }
        }
    }

    private void initFieldCache() throws IllegalArgumentException, IllegalAccessException {
        this.fieldCacheClient = new LinkedHashSet();
        this.fieldCacheServer = new LinkedHashSet();
        for (Field field : this.getClass().getFields()) {
            if (!field.isAnnotationPresent(Annotations.NetworkedField.class)) continue;
            Annotations.NetworkedField f = field.getAnnotation(Annotations.NetworkedField.class);
            if (f.targetSide() == Side.CLIENT) {
                this.fieldCacheClient.add(field);
                continue;
            }
            this.fieldCacheServer.add(field);
        }
    }

    @Override
    public void getNetworkedData(ArrayList<Object> sendData) {
        LinkedHashSet<Field> fieldList = null;
        boolean changed = false;
        fieldList = this.field_70170_p.field_72995_K ? this.fieldCacheServer : this.fieldCacheClient;
        for (Field f : fieldList) {
            boolean fieldChanged = false;
            try {
                Object data = f.get(this);
                Object lastData = this.lastSentData.get(f);
                if (!NetworkUtil.fuzzyEquals(lastData, data)) {
                    fieldChanged = true;
                }
                sendData.add(data);
                if (fieldChanged) {
                    this.lastSentData.put(f, NetworkUtil.cloneNetworkedObject(data));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            changed |= fieldChanged;
        }
        this.networkDataChanged = changed;
    }

    @Override
    public void decodePacketdata(ByteBuf buffer) {
        if (this.fieldCacheClient == null || this.fieldCacheServer == null) {
            try {
                this.initFieldCache();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        LinkedHashSet<Field> fieldSet = null;
        fieldSet = this.field_70170_p.field_72995_K ? this.fieldCacheClient : this.fieldCacheServer;
        for (Field field : fieldSet) {
            try {
                Object obj = NetworkUtil.getFieldValueFromStream(field, buffer, this.field_70170_p);
                field.set(this, obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

