/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy.item;

import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.item.ElectricItemHelper;
import micdoodle8.mods.galacticraft.api.item.IItemElectricBase;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.energy.item.ElectricItemManagerIC2;
import micdoodle8.mods.galacticraft.core.items.ItemBatteryInfinite;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.relauncher.FMLInjectionData;

public abstract class ItemElectricBase
extends Item
implements IItemElectricBase {
    private static final int DAMAGE_RANGE = 100;
    private static Object itemManagerIC2;
    public float transferMax;
    private DefaultArtifactVersion mcVersion = null;

    public ItemElectricBase() {
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
        this.setMaxTransfer();
        this.mcVersion = new DefaultArtifactVersion((String)FMLInjectionData.data()[4]);
        if (EnergyConfigHandler.isIndustrialCraft2Loaded()) {
            itemManagerIC2 = new ElectricItemManagerIC2();
        }
    }

    public static boolean isElectricItem(Item item) {
        if (item instanceof IItemElectricBase) {
            return true;
        }
        if (EnergyConfigHandler.isIndustrialCraft2Loaded()) {
            return item instanceof ISpecialElectricItem;
        }
        return false;
    }

    public static boolean isElectricItemEmpty(ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return false;
        }
        Item item = itemstack.func_77973_b();
        if (item instanceof IItemElectricBase) {
            return ((IItemElectricBase)item).getElectricityStored(itemstack) <= 0.0f;
        }
        if (EnergyConfigHandler.isIndustrialCraft2Loaded() && item instanceof IElectricItem) {
            return !((IElectricItem)item).canProvideEnergy(itemstack);
        }
        return false;
    }

    public static boolean isElectricItemCharged(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        Item item = itemstack.func_77973_b();
        if (item instanceof IItemElectricBase) {
            return ((IItemElectricBase)item).getElectricityStored(itemstack) > 0.0f;
        }
        if (EnergyConfigHandler.isIndustrialCraft2Loaded() && item instanceof IElectricItem) {
            return ((IElectricItem)item).canProvideEnergy(itemstack);
        }
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    protected void setMaxTransfer() {
        this.transferMax = 200.0f;
    }

    @Override
    public float getMaxTransferGC(ItemStack itemStack) {
        return this.transferMax;
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String color = "";
        float joules = this.getElectricityStored(itemStack);
        color = joules <= this.getMaxElectricityStored(itemStack) / 3.0f ? "\u00a74" : (joules > this.getMaxElectricityStored(itemStack) * 2.0f / 3.0f ? "\u00a72" : "\u00a76");
        tooltip.add(color + EnergyDisplayHelper.getEnergyDisplayS(joules) + "/" + EnergyDisplayHelper.getEnergyDisplayS(this.getMaxElectricityStored(itemStack)));
    }

    public void func_77622_d(ItemStack itemStack, World par2World, EntityPlayer par3EntityPlayer) {
        this.setElectricity(itemStack, 0.0f);
    }

    @Override
    public float recharge(ItemStack itemStack, float energy, boolean doReceive) {
        float rejectedElectricity = Math.max(this.getElectricityStored(itemStack) + energy - this.getMaxElectricityStored(itemStack), 0.0f);
        float energyToReceive = energy - rejectedElectricity;
        if (energyToReceive > this.transferMax) {
            rejectedElectricity += energyToReceive - this.transferMax;
            energyToReceive = this.transferMax;
        }
        if (doReceive) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) + energyToReceive);
        }
        return energyToReceive;
    }

    @Override
    public float discharge(ItemStack itemStack, float energy, boolean doTransfer) {
        float thisEnergy = this.getElectricityStored(itemStack);
        float energyToTransfer = Math.min(Math.min(thisEnergy, energy), this.transferMax);
        if (doTransfer) {
            this.setElectricity(itemStack, thisEnergy - energyToTransfer);
        }
        return energyToTransfer;
    }

    @Override
    public int getTierGC(ItemStack itemStack) {
        return 1;
    }

    @Override
    public void setElectricity(ItemStack itemStack, float joules) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float electricityStored = Math.max(Math.min(joules, this.getMaxElectricityStored(itemStack)), 0.0f);
        if (joules > 0.0f || itemStack.func_77978_p().func_74764_b("electricity")) {
            itemStack.func_77978_p().func_74776_a("electricity", electricityStored);
        }
        itemStack.func_77964_b(100 - (int)(electricityStored / this.getMaxElectricityStored(itemStack) * 100.0f));
    }

    @Override
    public float getTransfer(ItemStack itemStack) {
        return Math.min(this.transferMax, this.getMaxElectricityStored(itemStack) - this.getElectricityStored(itemStack));
    }

    @Override
    public float getElectricityStored(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float energyStored = 0.0f;
        if (itemStack.func_77978_p().func_74764_b("electricity")) {
            NBTBase obj = itemStack.func_77978_p().func_74781_a("electricity");
            if (obj instanceof NBTTagDouble) {
                energyStored = ((NBTTagDouble)obj).func_150288_h();
            } else if (obj instanceof NBTTagFloat) {
                energyStored = ((NBTTagFloat)obj).func_150288_h();
            }
        } else {
            if (itemStack.func_77952_i() == 100) {
                return 0.0f;
            }
            energyStored = this.getMaxElectricityStored(itemStack) * (float)(100 - itemStack.func_77952_i()) / 100.0f;
            itemStack.func_77978_p().func_74776_a("electricity", energyStored);
        }
        itemStack.func_77964_b(100 - (int)(energyStored / this.getMaxElectricityStored(itemStack) * 100.0f));
        return energyStored;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == GalacticraftCore.galacticraftItemsTab || tab == CreativeTabs.field_78027_g) {
            list.add((Object)ElectricItemHelper.getUncharged(new ItemStack((Item)this)));
            list.add((Object)ElectricItemHelper.getWithCharge(new ItemStack((Item)this), this.getMaxElectricityStored(new ItemStack((Item)this))));
        }
    }

    @Annotations.RuntimeInterface(clazz="cofh.redstoneflux.api.IEnergyContainerItem", modID="")
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return (int)(this.recharge(container, (float)maxReceive * EnergyConfigHandler.RF_RATIO, !simulate) / EnergyConfigHandler.RF_RATIO);
    }

    @Annotations.RuntimeInterface(clazz="cofh.redstoneflux.api.IEnergyContainerItem", modID="")
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return (int)(this.discharge(container, (float)maxExtract / EnergyConfigHandler.TO_RF_RATIO, !simulate) * EnergyConfigHandler.TO_RF_RATIO);
    }

    @Annotations.RuntimeInterface(clazz="cofh.redstoneflux.api.IEnergyContainerItem", modID="")
    public int getEnergyStored(ItemStack container) {
        return (int)(this.getElectricityStored(container) * EnergyConfigHandler.TO_RF_RATIO);
    }

    @Annotations.RuntimeInterface(clazz="cofh.redstoneflux.api.IEnergyContainerItem", modID="")
    public int getMaxEnergyStored(ItemStack container) {
        return (int)(this.getMaxElectricityStored(container) * EnergyConfigHandler.TO_RF_RATIO);
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IEnergizedItem", modID="mekanism")
    public double getEnergy(ItemStack itemStack) {
        return this.getElectricityStored(itemStack) * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IEnergizedItem", modID="mekanism")
    public void setEnergy(ItemStack itemStack, double amount) {
        this.setElectricity(itemStack, (float)amount * EnergyConfigHandler.MEKANISM_RATIO);
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IEnergizedItem", modID="mekanism")
    public double getMaxEnergy(ItemStack itemStack) {
        return this.getMaxElectricityStored(itemStack) * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IEnergizedItem", modID="mekanism")
    public double getMaxTransfer(ItemStack itemStack) {
        return this.transferMax * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IEnergizedItem", modID="mekanism")
    public boolean canReceive(ItemStack itemStack) {
        return itemStack != null && !(itemStack.func_77973_b() instanceof ItemBatteryInfinite);
    }

    public boolean canSend(ItemStack itemStack) {
        return true;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="ic2")
    public IElectricItemManager getManager(ItemStack itemstack) {
        return (IElectricItemManager)itemManagerIC2;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.IElectricItem", modID="ic2")
    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.IElectricItem", modID="ic2")
    public int getTier(ItemStack itemStack) {
        return 1;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.IElectricItem", modID="ic2")
    public double getMaxCharge(ItemStack itemStack) {
        return this.getMaxElectricityStored(itemStack) / EnergyConfigHandler.IC2_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.IElectricItem", modID="ic2")
    public double getTransferLimit(ItemStack itemStack) {
        return this.transferMax * EnergyConfigHandler.TO_IC2_RATIO;
    }
}

