/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.render;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.opengl.GL11;

public class RenderPlanet {
    private static final TextureManager renderEngine = FMLClientHandler.instance().getClient().field_71446_o;
    private static final ResourceLocation textureEuropa = new ResourceLocation("galacticraftcore", "textures/misc/planets/europa.png");
    private static final ResourceLocation textureGanymede = new ResourceLocation("galacticraftcore", "textures/misc/planets/ganymede.png");
    private static final ResourceLocation textureIo = new ResourceLocation("galacticraftcore", "textures/misc/planets/io.png");
    private static final ResourceLocation textureSaturn = new ResourceLocation("galacticraftcore", "textures/misc/planets/saturn.png");
    private static final ResourceLocation textureJupiterInner = new ResourceLocation("galacticraftcore", "textures/misc/planets/jupiter_inner.png");
    private static final ResourceLocation textureJupiterUpper = new ResourceLocation("galacticraftcore", "textures/misc/planets/jupiter_upper.png");

    public static void renderPlanet(int textureId, float scale, float ticks, float relSize) {
        GL11.glBindTexture((int)3553, (int)textureId);
        float size = relSize / 70.0f * scale;
        ticks = (float)System.nanoTime() / 5.0E7f;
        RenderPlanet.drawTexturedRectUV(-size / 2.0f, -size / 2.0f, size, size, ticks);
    }

    public static void renderPlanet(ResourceLocation texture, float scale, float ticks, float relSize) {
        renderEngine.func_110577_a(texture);
        float size = relSize / 70.0f * scale;
        ticks = (float)System.nanoTime() / 5.0E7f;
        RenderPlanet.drawTexturedRectUV(-size / 2.0f, -size / 2.0f, size, size, ticks);
    }

    public static void renderID(int id, float scale, float ticks) {
        ResourceLocation texture;
        switch (id) {
            case 0: {
                texture = textureEuropa;
                break;
            }
            case 1: {
                texture = textureGanymede;
                break;
            }
            case 2: {
                texture = textureIo;
                break;
            }
            case 3: {
                texture = textureJupiterInner;
                break;
            }
            case 4: {
                texture = textureSaturn;
                break;
            }
            default: {
                texture = textureGanymede;
            }
        }
        if (id == 3) {
            float relSize = 48.0f;
            float size = relSize / 70.0f * scale;
            renderEngine.func_110577_a(texture);
            RenderPlanet.drawTexturedRectUV(-size / 2.0f, -size / 2.0f, size, size, ticks);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.001f);
            renderEngine.func_110577_a(textureJupiterUpper);
            RenderPlanet.drawTexturedRectUV(-(size *= 1.001f) / 2.0f, -size / 2.0f, size, size, ticks * 0.85f);
        } else {
            RenderPlanet.renderPlanet(texture, scale, ticks, 8.0f);
        }
    }

    public static void drawTexturedRectUV(float x, float y, float width, float height, float ticks) {
        for (int ysect = 0; ysect < 6; ++ysect) {
            float factor = 1.0f + MathHelper.func_76134_b((float)((7.5f + 10.0f * (float)ysect) / 62.0f));
            RenderPlanet.drawTexturedRectUVSixth(x, y, width, height, ticks / 1100.0f % 1.0f - (1.0f - factor) * 0.15f, (float)ysect / 6.0f, 0.16f * factor);
        }
    }

    public static void drawTexturedRectUVSixth(float x, float y, float width, float height, float prog, float y0, float span) {
        y0 /= 2.0f;
        if (prog < 0.0f) {
            prog += 1.0f;
        }
        prog = 1.0f - prog;
        float y1 = y0 + 0.083333336f;
        float y2 = 1.0f - y1;
        float y3 = 1.0f - y0;
        float yaa = y + height * y0;
        float yab = y + height * y1;
        float yba = y + height * y2;
        float ybb = y + height * y3;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        if (prog <= 1.0f - span) {
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b((double)x, (double)yab, 0.0).func_187315_a((double)prog, (double)y1).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)yab, 0.0).func_187315_a((double)(prog + span), (double)y1).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)yaa, 0.0).func_187315_a((double)(prog + span), (double)y0).func_181675_d();
            worldRenderer.func_181662_b((double)x, (double)yaa, 0.0).func_187315_a((double)prog, (double)y0).func_181675_d();
            tessellator.func_78381_a();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b((double)x, (double)ybb, 0.0).func_187315_a((double)prog, (double)y3).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)ybb, 0.0).func_187315_a((double)(prog + span), (double)y3).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)yba, 0.0).func_187315_a((double)(prog + span), (double)y2).func_181675_d();
            worldRenderer.func_181662_b((double)x, (double)yba, 0.0).func_187315_a((double)prog, (double)y2).func_181675_d();
            tessellator.func_78381_a();
        } else {
            double xp = x + width * (1.0f - prog) / span;
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b((double)x, (double)yab, 0.0).func_187315_a((double)prog, (double)y1).func_181675_d();
            worldRenderer.func_181662_b(xp, (double)yab, 0.0).func_187315_a(1.0, (double)y1).func_181675_d();
            worldRenderer.func_181662_b(xp, (double)yaa, 0.0).func_187315_a(1.0, (double)y0).func_181675_d();
            worldRenderer.func_181662_b((double)x, (double)yaa, 0.0).func_187315_a((double)prog, (double)y0).func_181675_d();
            tessellator.func_78381_a();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b((double)x, (double)ybb, 0.0).func_187315_a((double)prog, (double)y3).func_181675_d();
            worldRenderer.func_181662_b(xp, (double)ybb, 0.0).func_187315_a(1.0, (double)y3).func_181675_d();
            worldRenderer.func_181662_b(xp, (double)yba, 0.0).func_187315_a(1.0, (double)y2).func_181675_d();
            worldRenderer.func_181662_b((double)x, (double)yba, 0.0).func_187315_a((double)prog, (double)y2).func_181675_d();
            tessellator.func_78381_a();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b(xp, (double)yab, 0.0).func_187315_a(0.0, (double)y1).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)yab, 0.0).func_187315_a((double)(prog - 1.0f + span), (double)y1).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)yaa, 0.0).func_187315_a((double)(prog - 1.0f + span), (double)y0).func_181675_d();
            worldRenderer.func_181662_b(xp, (double)yaa, 0.0).func_187315_a(0.0, (double)y0).func_181675_d();
            tessellator.func_78381_a();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b(xp, (double)ybb, 0.0).func_187315_a(0.0, (double)y3).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)ybb, 0.0).func_187315_a((double)(prog - 1.0f + span), (double)y3).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)yba, 0.0).func_187315_a((double)(prog - 1.0f + span), (double)y2).func_181675_d();
            worldRenderer.func_181662_b(xp, (double)yba, 0.0).func_187315_a(0.0, (double)y2).func_181675_d();
            tessellator.func_78381_a();
        }
    }
}

