/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.entities.IBubbleProviderColored;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class BubbleRenderer {
    private static final List<IBubbleProviderColored> bubbleProviders = Lists.newArrayList();
    private static IBakedModel sphere;

    public static void clearBubbles() {
        bubbleProviders.clear();
    }

    public static void addBubble(IBubbleProviderColored tile) {
        bubbleProviders.add(tile);
    }

    private static void updateModels() {
        try {
            sphere = ClientUtil.modelFromOBJ(new ResourceLocation("galacticraftcore", "sphere.obj"), (List<String>)ImmutableList.of((Object)"Sphere"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void renderBubbles(EntityPlayer player, float partialTicks) {
        if (bubbleProviders.isEmpty()) {
            return;
        }
        double interpPosX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double interpPosY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double interpPosZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        if (sphere == null) {
            BubbleRenderer.updateModels();
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179132_a((boolean)false);
        float lightMapSaveX = OpenGlHelper.lastBrightnessX;
        float lightMapSaveY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        for (IBubbleProviderColored provider : bubbleProviders) {
            TileEntity tile = (TileEntity)provider;
            if (!provider.getBubbleVisible()) continue;
            GL11.glPushMatrix();
            float x = (float)((double)tile.func_174877_v().func_177958_n() - interpPosX);
            float y = (float)((double)tile.func_174877_v().func_177956_o() - interpPosY);
            float z = (float)((double)tile.func_174877_v().func_177952_p() - interpPosZ);
            GL11.glTranslatef((float)(x + 0.5f), (float)(y + 1.0f), (float)(z + 0.5f));
            GL11.glScalef((float)provider.getBubbleSize(), (float)provider.getBubbleSize(), (float)provider.getBubbleSize());
            Vector3 colorVec = provider.getColor();
            int color = ColorUtil.to32BitColor(30, (int)(colorVec.z * 255.0), (int)(colorVec.y * 255.0), (int)(colorVec.x * 255.0));
            ClientUtil.drawBakedModelColored(sphere, color);
            GL11.glPopMatrix();
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightMapSaveX, (float)lightMapSaveY);
        GlStateManager.func_179121_F();
    }
}

