/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockGratingExtendedState;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.JavaUtil;
import micdoodle8.mods.galacticraft.core.util.PropertyObject;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockGrating
extends Block
implements ISortableBlock,
IPartialSealableBlock {
    public static final PropertyObject<IBlockState> BASE_STATE = new PropertyObject<IBlockState>("held_state", IBlockState.class);
    protected static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);
    public static IBlockAccess savedBlockAccess;
    public static BlockPos savedPos;
    public static List<BlockGrating> forgeBlocks;
    public static int number;
    private static Method gofd;
    private static Field fieldQuantaPerBlock;
    private final IBlockState liquidEquivalentDynamic;
    private final IBlockState liquidEquivalentStatic;
    private final ThreadLocal<Boolean> replaceWithFluidIntended;
    private int adjacentSourceBlocks;
    private boolean forgeFluid;
    private BlockFluidBase forgeBlock;

    public BlockGrating(String assetName, Material material) {
        super(material);
        new ThreadLocal();
        this.replaceWithFluidIntended = ThreadLocal.withInitial(() -> false);
        this.forgeFluid = false;
        this.forgeBlock = null;
        if (this.field_149764_J == Material.field_151587_i) {
            this.liquidEquivalentStatic = Blocks.field_150353_l.func_176223_P();
            this.liquidEquivalentDynamic = Blocks.field_150356_k.func_176223_P();
            this.func_149675_a(true);
        } else if (this.field_149764_J == Material.field_151586_h) {
            this.liquidEquivalentStatic = Blocks.field_150355_j.func_176223_P();
            this.liquidEquivalentDynamic = Blocks.field_150358_i.func_176223_P();
            this.func_149675_a(true);
        } else {
            this.liquidEquivalentStatic = null;
            this.liquidEquivalentDynamic = null;
        }
        this.func_149711_c(0.5f);
        this.field_149781_w = 15.0f;
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c(assetName);
    }

    public BlockGrating(Block forge) {
        super(forge.func_149688_o(forge.func_176223_P()));
        new ThreadLocal();
        this.replaceWithFluidIntended = ThreadLocal.withInitial(() -> false);
        this.forgeFluid = false;
        this.forgeBlock = null;
        this.forgeFluid = true;
        this.forgeBlock = (BlockFluidBase)forge;
        this.liquidEquivalentStatic = null;
        this.liquidEquivalentDynamic = null;
        this.func_149711_c(0.5f);
        this.field_149781_w = 15.0f;
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c("grating" + number);
        ++number;
    }

    public static void createForgeFluidVersion(Block b, IForgeRegistry<Block> blockRegistry) {
        if (b instanceof BlockFluidBase) {
            BlockGrating grating = new BlockGrating(b);
            grating.func_149715_a((float)b.func_149750_m(b.func_176223_P()) / 15.0f);
            forgeBlocks.add(grating);
            GCBlocks.registerBlock(grating, null, new Object[0]);
            blockRegistry.register((IForgeRegistryEntry)grating);
        }
    }

    public static void createForgeFluidVersions(IForgeRegistry<Block> blockRegistry) {
        for (Block test : Block.field_149771_c) {
            if (!(test instanceof BlockFluidBase)) continue;
            BlockGrating.createForgeFluidVersion(test, blockRegistry);
        }
    }

    public static void remapForgeVariants() {
        for (Block block : forgeBlocks) {
            BlockGrating.remapVariant(block);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void remapVariant(Block grating) {
        ModelLoader.setCustomStateMapper((Block)grating, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState ignore) {
                return new ModelResourceLocation("galacticraftcore:grating", "normal");
            }
        });
    }

    public String func_149732_F() {
        return I18n.func_74838_a((String)"tile.grating.name");
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.DECORATION;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public boolean isSealed(World world, BlockPos pos, EnumFacing direction) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (JavaUtil.instance.isCalledBy(BlockDynamicLiquid.class, BlockFluidBase.class)) {
            return Item.func_150898_a((Block)Blocks.field_150350_a);
        }
        Thread.dumpStack();
        return Item.func_150898_a((Block)GCBlocks.grating);
    }

    @Nullable
    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)GCBlocks.grating), 1, 0);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)GCBlocks.grating), 1, 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockGratingExtendedState(this, new IProperty[]{BlockLiquid.field_176367_b, BlockFluidBase.LEVEL}, new IUnlistedProperty[]{BASE_STATE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(meta)).func_177226_a((IProperty)BlockFluidBase.LEVEL, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        savedBlockAccess = world;
        savedPos = pos;
        return ((IExtendedBlockState)state).withProperty(BASE_STATE, (Object)this.getLiquidBlock(state));
    }

    public IBlockState getLiquidBlock(IBlockState state) {
        if (this.forgeFluid && state.func_177227_a().contains(BlockFluidBase.LEVEL)) {
            int level = (Integer)state.func_177229_b((IProperty)BlockFluidBase.LEVEL);
            return this.forgeBlock.func_176223_P().func_177226_a((IProperty)BlockFluidBase.LEVEL, (Comparable)Integer.valueOf(level));
        }
        if (this.field_149764_J == Material.field_151586_h || this.field_149764_J == Material.field_151587_i) {
            int level = (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b);
            return this.liquidEquivalentStatic.func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(level));
        }
        return null;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        IBlockState newBlock = world.func_180495_p(pos);
        if (newBlock.func_177230_c() instanceof BlockGrating) {
            return;
        }
        if (Blocks.field_150350_a == newBlock.func_177230_c() && this != GCBlocks.grating) {
            world.func_175656_a(pos, this.getLiquidBlock(state));
            this.func_176226_b(world, pos, state, 0);
        }
        if (this.replaceWithFluidIntended.get().booleanValue()) {
            this.replaceWithFluidIntended.set(false);
            return;
        }
        if (newBlock.func_177230_c() instanceof BlockFluidBase) {
            for (BlockGrating b : forgeBlocks) {
                if (newBlock.func_177230_c() != b.forgeBlock) continue;
                int level = (Integer)newBlock.func_177229_b((IProperty)BlockFluidBase.LEVEL);
                IBlockState bs = b.func_176223_P().func_177226_a((IProperty)BlockFluidBase.LEVEL, (Comparable)Integer.valueOf(level)).func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(level));
                world.func_175656_a(pos, bs);
                return;
            }
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(GCBlocks.grating));
            return;
        }
        if (newBlock.func_177230_c() instanceof BlockLiquid) {
            if (newBlock.func_185904_a() == Material.field_151586_h) {
                int level = (Integer)newBlock.func_177229_b((IProperty)BlockLiquid.field_176367_b);
                IBlockState bs = GCBlocks.gratingWater.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(level));
                world.func_175656_a(pos, bs);
            } else if (newBlock.func_185904_a() == Material.field_151587_i) {
                int level = (Integer)newBlock.func_177229_b((IProperty)BlockLiquid.field_176367_b);
                IBlockState bs = GCBlocks.gratingLava.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(level));
                world.func_175656_a(pos, bs);
            }
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        if (this == GCBlocks.grating) {
            return world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
        }
        this.replaceWithFluidIntended.set(true);
        return world.func_180501_a(pos, this.getLiquidBlock(state), world.field_72995_K ? 11 : 3);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState oldBlock = world.func_180495_p(pos);
        if (oldBlock.func_177230_c() instanceof BlockGrating) {
            return this.func_176203_a(meta);
        }
        if (oldBlock.func_177230_c() instanceof BlockFluidBase) {
            for (BlockGrating b : forgeBlocks) {
                if (oldBlock.func_177230_c() != b.forgeBlock) continue;
                int level = (Integer)oldBlock.func_177229_b((IProperty)BlockFluidBase.LEVEL);
                return b.func_176223_P().func_177226_a((IProperty)BlockFluidBase.LEVEL, (Comparable)Integer.valueOf(level)).func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(level));
            }
        } else if (oldBlock.func_177230_c() instanceof BlockLiquid) {
            if (oldBlock.func_185904_a() == Material.field_151586_h) {
                int level = (Integer)oldBlock.func_177229_b((IProperty)BlockLiquid.field_176367_b);
                return GCBlocks.gratingWater.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(level));
            }
            if (oldBlock.func_185904_a() == Material.field_151587_i) {
                int level = (Integer)oldBlock.func_177229_b((IProperty)BlockLiquid.field_176367_b);
                return GCBlocks.gratingLava.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(level));
            }
        }
        return this.func_176203_a(meta);
    }

    public Material func_149688_o(IBlockState state) {
        int found = JavaUtil.instance.isCalledBySecond(BlockDynamicLiquid.class, EntityLivingBase.class, World.class);
        if (found > 0 && (found > 1 || JavaUtil.instance.isCalledByThird(WorldServer.class))) {
            return Material.field_151573_f;
        }
        return this.field_149764_J;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_176209_a(IBlockState state, boolean hitIfLiquid) {
        return true;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        IBlockState iblockstate1;
        BlockPos down;
        if (!this.field_149764_J.func_76224_d()) {
            return;
        }
        if (this.forgeFluid) {
            if (this.forgeBlock instanceof BlockFluidClassic) {
                this.updateTickForge(worldIn, pos, state, rand);
            }
            return;
        }
        int i = (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b);
        int j = 1;
        if (this.field_149764_J == Material.field_151587_i && !worldIn.field_73011_w.func_177500_n()) {
            j = 2;
        }
        int k = this.func_149738_a(worldIn);
        if (i > 0) {
            int j1;
            int l = -100;
            this.adjacentSourceBlocks = 0;
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                l = this.checkAdjacentBlock(worldIn, pos.func_177972_a(enumfacing), l);
            }
            int i1 = l + j;
            if (i1 >= 8 || l < 0) {
                i1 = -1;
            }
            if ((j1 = this.getDepth(worldIn.func_180495_p(pos.func_177984_a()))) >= 0) {
                i1 = j1 >= 8 ? j1 : j1 + 8;
            }
            if (this.adjacentSourceBlocks >= 2 && ForgeEventFactory.canCreateFluidSource((World)worldIn, (BlockPos)pos, (IBlockState)state, (this.field_149764_J == Material.field_151586_h ? 1 : 0) != 0)) {
                IBlockState iblockstate = worldIn.func_180495_p(pos.func_177977_b());
                if (iblockstate.func_185904_a().func_76220_a()) {
                    i1 = 0;
                } else if (iblockstate.func_185904_a() == this.field_149764_J && (Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                    i1 = 0;
                }
            }
            if (this.field_149764_J == Material.field_151587_i && i < 8 && i1 < 8 && i1 > i && rand.nextInt(4) != 0) {
                k *= 4;
            }
            if (i1 != i) {
                i = i1;
                if (i1 < 0) {
                    worldIn.func_180501_a(pos, GCBlocks.grating.func_176223_P(), 3);
                } else {
                    state = state.func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(i1));
                    worldIn.func_180501_a(pos, state, 2);
                    worldIn.func_175684_a(pos, (Block)this, k);
                    worldIn.func_175685_c(pos, (Block)this, false);
                }
            }
        }
        if (this.canFlowInto(worldIn, down = pos.func_177977_b(), iblockstate1 = worldIn.func_180495_p(down))) {
            if (this.field_149764_J == Material.field_151587_i && iblockstate1.func_185904_a() == Material.field_151586_h && !(iblockstate1.func_177230_c() instanceof BlockGrating)) {
                worldIn.func_175656_a(down, Blocks.field_150348_b.func_176223_P());
                return;
            }
            if (i >= 8) {
                this.tryFlowInto(worldIn, down, iblockstate1, i);
            } else {
                this.tryFlowInto(worldIn, down, iblockstate1, i + 8);
            }
        } else if (i >= 0 && (i == 0 || this.isBlocked(worldIn, down, iblockstate1))) {
            Set<EnumFacing> set = this.getPossibleFlowDirections(worldIn, pos);
            int k1 = i + j;
            if (i >= 8) {
                k1 = 1;
            }
            if (k1 >= 8) {
                return;
            }
            for (EnumFacing enumfacing1 : set) {
                this.tryFlowInto(worldIn, pos.func_177972_a(enumfacing1), worldIn.func_180495_p(pos.func_177972_a(enumfacing1)), k1);
            }
        }
    }

    private void tryFlowInto(World worldIn, BlockPos pos, IBlockState state, int level) {
        if (this.canFlowInto(worldIn, pos, state)) {
            if (state.func_185904_a() != Material.field_151579_a && !(state.func_177230_c() instanceof BlockGrating) && this.field_149764_J != Material.field_151587_i && state.func_177230_c() != Blocks.field_150431_aC) {
                state.func_177230_c().func_176226_b(worldIn, pos, state, 0);
            }
            worldIn.func_180501_a(pos, this.liquidEquivalentDynamic.func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(level)), 3);
        }
    }

    private int getSlopeDistance(World worldIn, BlockPos pos, int distance, EnumFacing calculateFlowCost) {
        int i = 1000;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            int j;
            IBlockState iblockstate;
            BlockPos blockpos;
            if (enumfacing == calculateFlowCost || this.isBlocked(worldIn, blockpos = pos.func_177972_a(enumfacing), iblockstate = worldIn.func_180495_p(blockpos)) || iblockstate.func_185904_a() == this.field_149764_J && (Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b) <= 0) continue;
            if (!this.isBlocked(worldIn, blockpos.func_177977_b(), iblockstate)) {
                return distance;
            }
            if (distance >= this.getSlopeFindDistance(worldIn) || (j = this.getSlopeDistance(worldIn, blockpos, distance + 1, enumfacing.func_176734_d())) >= i) continue;
            i = j;
        }
        return i;
    }

    private int getSlopeFindDistance(World worldIn) {
        return this.field_149764_J == Material.field_151587_i && !worldIn.field_73011_w.func_177500_n() ? 2 : 4;
    }

    private Set<EnumFacing> getPossibleFlowDirections(World worldIn, BlockPos pos) {
        int i = 1000;
        EnumSet<EnumFacing> set = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate;
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            if (this.isBlocked(worldIn, blockpos, iblockstate = worldIn.func_180495_p(blockpos)) || iblockstate.func_185904_a() == this.field_149764_J && (Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b) <= 0) continue;
            int j = this.isBlocked(worldIn, blockpos.func_177977_b(), worldIn.func_180495_p(blockpos.func_177977_b())) ? this.getSlopeDistance(worldIn, blockpos, 1, enumfacing.func_176734_d()) : 0;
            if (j < i) {
                set.clear();
            }
            if (j > i) continue;
            set.add(enumfacing);
            i = j;
        }
        return set;
    }

    private boolean isBlocked(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState bs = worldIn.func_180495_p(pos);
        Block block = bs.func_177230_c();
        return block instanceof BlockDoor || block == Blocks.field_150472_an || block == Blocks.field_150468_ap || block == Blocks.field_150436_aH || block.func_149688_o(bs) == Material.field_151567_E || block.func_149688_o(bs) == Material.field_189963_J || block.func_149688_o(bs).func_76230_c();
    }

    protected int checkAdjacentBlock(World worldIn, BlockPos pos, int currentMinLevel) {
        int i = this.getDepth(worldIn.func_180495_p(pos));
        if (i < 0) {
            return currentMinLevel;
        }
        if (i == 0) {
            ++this.adjacentSourceBlocks;
        }
        if (i >= 8) {
            i = 0;
        }
        return currentMinLevel >= 0 && i >= currentMinLevel ? currentMinLevel : i;
    }

    private boolean canFlowInto(World worldIn, BlockPos pos, IBlockState state) {
        Material material = state.func_185904_a();
        return material != this.field_149764_J && material != Material.field_151587_i && !this.isBlocked(worldIn, pos, state);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (this.field_149764_J.func_76224_d()) {
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.field_149764_J.func_76224_d()) {
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        }
    }

    public int func_149738_a(World worldIn) {
        if (this.forgeFluid) {
            return this.forgeBlock.func_149738_a(worldIn);
        }
        return this.field_149764_J == Material.field_151586_h ? 5 : (this.field_149764_J == Material.field_151587_i ? (worldIn.field_73011_w.func_177495_o() ? 10 : 30) : 0);
    }

    protected int getDepth(IBlockState p_189542_1_) {
        return p_189542_1_.func_185904_a() == this.field_149764_J ? (Integer)p_189542_1_.func_177229_b((IProperty)BlockLiquid.field_176367_b) : -1;
    }

    public void updateTickForge(World world, BlockPos pos, IBlockState state, Random rand) {
        int quantaPerBlock = 8;
        try {
            quantaPerBlock = fieldQuantaPerBlock.getInt(this.forgeBlock);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int tickRate = this.forgeBlock.func_149738_a(world);
        int quantaRemaining = quantaPerBlock - (Integer)state.func_177229_b((IProperty)BlockFluidBase.LEVEL);
        int expQuanta = -101;
        if (quantaRemaining < quantaPerBlock) {
            if (this.testSame(world, pos.func_177982_a(0, 1, 0)) || this.testSame(world, pos.func_177982_a(-1, 1, 0)) || this.testSame(world, pos.func_177982_a(1, 1, 0)) || this.testSame(world, pos.func_177982_a(0, 1, -1)) || this.testSame(world, pos.func_177982_a(0, 1, 1))) {
                expQuanta = quantaPerBlock - 1;
            } else {
                int maxQuanta = -100;
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177982_a(-1, 0, 0), maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177982_a(1, 0, 0), maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177982_a(0, 0, -1), maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177982_a(0, 0, 1), maxQuanta);
                expQuanta = maxQuanta - 1;
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                if (expQuanta <= 0) {
                    world.func_180501_a(pos, GCBlocks.grating.func_176223_P(), 3);
                } else {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)BlockFluidBase.LEVEL, (Comparable)Integer.valueOf(quantaPerBlock - expQuanta)), 2);
                    world.func_175684_a(pos, (Block)this, tickRate);
                    world.func_175685_c(pos, (Block)this.forgeBlock, false);
                }
            }
        } else if (quantaRemaining >= quantaPerBlock) {
            world.func_180501_a(pos, this.func_176223_P(), 2);
        }
        if (this.forgeBlock.canDisplace((IBlockAccess)world, pos.func_177979_c(1))) {
            this.flowIntoBlock(world, pos.func_177979_c(1), 1);
            return;
        }
        int flowMeta = quantaPerBlock - quantaRemaining + 1;
        if (flowMeta >= quantaPerBlock) {
            return;
        }
        if (this.isSourceBlock((IBlockAccess)world, pos) || !((BlockFluidClassic)this.forgeBlock).isFlowingVertically((IBlockAccess)world, pos)) {
            Block test = world.func_180495_p(pos.func_177981_b(1)).func_177230_c();
            if (test == this || test == this.forgeBlock) {
                flowMeta = 1;
            }
            try {
                boolean[] flowTo = (boolean[])gofd.invoke((Object)this.forgeBlock, world, pos);
                if (flowTo[0]) {
                    this.flowIntoBlock(world, pos.func_177982_a(-1, 0, 0), flowMeta);
                }
                if (flowTo[1]) {
                    this.flowIntoBlock(world, pos.func_177982_a(1, 0, 0), flowMeta);
                }
                if (flowTo[2]) {
                    this.flowIntoBlock(world, pos.func_177982_a(0, 0, -1), flowMeta);
                }
                if (flowTo[3]) {
                    this.flowIntoBlock(world, pos.func_177982_a(0, 0, 1), flowMeta);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean testSame(World world, BlockPos pos) {
        Block test = world.func_180495_p(pos).func_177230_c();
        return test == this || test == this.forgeBlock;
    }

    private boolean isSourceBlock(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() instanceof BlockFluidBase && (Integer)state.func_177229_b((IProperty)BlockFluidBase.LEVEL) == 0;
    }

    protected int getLargerQuanta(IBlockAccess world, BlockPos pos, int compare) {
        int quantaRemaining = this.forgeBlock.getQuantaValue(world, pos);
        if (quantaRemaining <= 0) {
            return compare;
        }
        return quantaRemaining >= compare ? quantaRemaining : compare;
    }

    protected void flowIntoBlock(World world, BlockPos pos, int meta) {
        if (meta < 0) {
            return;
        }
        if (this.forgeBlock.displaceIfPossible(world, pos)) {
            world.func_180501_a(pos, this.forgeBlock.func_176194_O().func_177621_b().func_177226_a((IProperty)BlockFluidBase.LEVEL, (Comparable)Integer.valueOf(meta)), 3);
        }
    }

    static {
        forgeBlocks = new ArrayList<BlockGrating>();
        number = 3;
        try {
            gofd = BlockFluidClassic.class.getDeclaredMethod("getOptimalFlowDirections", World.class, BlockPos.class);
            gofd.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            fieldQuantaPerBlock = BlockFluidBase.class.getDeclaredField("quantaPerBlock");
            fieldQuantaPerBlock.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

