/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockConcealedRedstone
extends Block
implements ISortableBlock {
    public static final PropertyInteger POWER = PropertyInteger.func_177719_a((String)"power", (int)0, (int)15);
    private final Set<BlockPos> blocksNeedingUpdate = Sets.newHashSet();
    private boolean canProvidePower = true;

    public BlockConcealedRedstone(String assetName) {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.field_149781_w = 15.0f;
        this.func_149663_c(assetName);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(0)));
    }

    protected static boolean canRedstoneConnect(IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150488_af || state.func_177230_c() == GCBlocks.concealedRedstone) {
            return true;
        }
        if (Blocks.field_150413_aR.func_149667_c(state.func_177230_c())) {
            EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)BlockRedstoneRepeater.field_185512_D);
            return direction == side || direction.func_176734_d() == side;
        }
        return state.func_177230_c().canConnectRedstone(state, world, pos, side);
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.DECORATION;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)POWER);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWER});
    }

    private IBlockState updateSurroundingRedstone(World worldIn, BlockPos pos, IBlockState state) {
        state = this.calculateCurrentChanges(worldIn, pos, pos, state);
        ArrayList list = Lists.newArrayList(this.blocksNeedingUpdate);
        this.blocksNeedingUpdate.clear();
        for (BlockPos blockpos : list) {
            worldIn.func_175685_c(blockpos, (Block)this, false);
        }
        return state;
    }

    private IBlockState calculateCurrentChanges(World worldIn, BlockPos pos1, BlockPos pos2, IBlockState state) {
        IBlockState iblockstate = state;
        int currentPower = (Integer)state.func_177229_b((IProperty)POWER);
        int maxPower = 0;
        maxPower = this.getMaxCurrentStrength(worldIn, pos2, maxPower);
        this.canProvidePower = false;
        int k = worldIn.func_175687_A(pos1);
        this.canProvidePower = true;
        if (k > 0 && k > maxPower - 1) {
            maxPower = k;
        }
        int l = 0;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            boolean flag;
            BlockPos blockpos = pos1.func_177972_a(enumfacing);
            boolean bl = flag = blockpos.func_177958_n() != pos2.func_177958_n() || blockpos.func_177952_p() != pos2.func_177952_p();
            if (flag) {
                l = this.getMaxCurrentStrength(worldIn, blockpos, l);
            }
            IBlockState bs = worldIn.func_180495_p(blockpos);
            IBlockState bsUp = worldIn.func_180495_p(pos1.func_177984_a());
            if (bs.func_177230_c().func_149721_r(bs) && !bsUp.func_177230_c().func_149721_r(bsUp)) {
                if (!flag || pos1.func_177956_o() < pos2.func_177956_o()) continue;
                l = this.getMaxCurrentStrength(worldIn, blockpos.func_177984_a(), l);
                continue;
            }
            if (bs.func_177230_c().func_149721_r(bs) || !flag || pos1.func_177956_o() > pos2.func_177956_o()) continue;
            l = this.getMaxCurrentStrength(worldIn, blockpos.func_177977_b(), l);
        }
        maxPower = l > maxPower ? l - 1 : (maxPower > 0 ? --maxPower : 0);
        if (k > maxPower - 1) {
            maxPower = k;
        }
        if (currentPower != maxPower) {
            state = state.func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(maxPower));
            if (worldIn.func_180495_p(pos1) == iblockstate) {
                worldIn.func_180501_a(pos1, state, 2);
            }
            this.blocksNeedingUpdate.add(pos1);
            for (EnumFacing enumfacing1 : EnumFacing.field_82609_l) {
                this.blocksNeedingUpdate.add(pos1.func_177972_a(enumfacing1));
            }
        }
        return state;
    }

    private void notifyWireNeighborsOfStateChange(World worldIn, BlockPos pos) {
        Block b = worldIn.func_180495_p(pos).func_177230_c();
        if (b == this || b == Blocks.field_150488_af) {
            worldIn.func_175685_c(pos, (Block)this, false);
            for (EnumFacing enumfacing : EnumFacing.field_82609_l) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, false);
            }
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            this.updateSurroundingRedstone(worldIn, pos, state);
            for (EnumFacing enumfacing : EnumFacing.Plane.VERTICAL) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, false);
            }
            for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(worldIn, pos.func_177972_a(enumfacing1));
            }
            this.notifyNeighbors(worldIn, pos);
        }
    }

    private void notifyNeighbors(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing2 : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.func_177972_a(enumfacing2);
            IBlockState bs = worldIn.func_180495_p(blockpos);
            if (bs.func_177230_c().func_149721_r(bs)) {
                this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177984_a());
                continue;
            }
            this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177977_b());
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        if (!worldIn.field_72995_K) {
            for (EnumFacing enumfacing : EnumFacing.field_82609_l) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, false);
            }
            this.updateSurroundingRedstone(worldIn, pos, state);
            for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(worldIn, pos.func_177972_a(enumfacing1));
            }
            this.notifyNeighbors(worldIn, pos);
        }
    }

    private int getMaxCurrentStrength(World worldIn, BlockPos pos, int strength) {
        if (worldIn.func_180495_p(pos).func_177230_c() != this) {
            return strength;
        }
        int i = (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)POWER);
        return i > strength ? i : strength;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            this.updateSurroundingRedstone(worldIn, pos, state);
        }
    }

    public int func_176211_b(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return !this.canProvidePower ? 0 : this.func_180656_a(state, worldIn, pos, side);
    }

    public int func_180656_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!this.canProvidePower) {
            return 0;
        }
        return (Integer)state.func_177229_b((IProperty)POWER);
    }

    public boolean func_149744_f(IBlockState state) {
        return this.canProvidePower;
    }

    public int func_149717_k(IBlockState state) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return true;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }
}

