/*
 * Decompiled with CFR 0.152.
 */
package c4.corpsecomplex.common.modules.spawning.capability;

import c4.corpsecomplex.common.modules.spawning.capability.IDeathLocation;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class DeathLocation
implements IDeathLocation {
    private BlockPos deathLocation;
    private int deathDimension;
    private boolean usedScroll = false;
    private boolean hasDeathLocation = false;

    @Override
    public BlockPos getDeathLocation() {
        return this.deathLocation;
    }

    @Override
    public void setDeathLocation(BlockPos pos) {
        this.deathLocation = pos;
    }

    @Override
    public boolean hasDeathLocation() {
        return this.hasDeathLocation;
    }

    @Override
    public void setHasDeathLocation(boolean hasDeathLocation) {
        this.hasDeathLocation = hasDeathLocation;
    }

    @Override
    public int getDeathDimension() {
        return this.deathDimension;
    }

    @Override
    public void setDeathDimension(int dimension) {
        this.deathDimension = dimension;
    }

    @Override
    public boolean hasUsedScroll() {
        return this.usedScroll;
    }

    @Override
    public void setUsedScroll(boolean usedScroll) {
        this.usedScroll = usedScroll;
    }

    public static class Storage
    implements Capability.IStorage<IDeathLocation> {
        public NBTBase writeNBT(Capability<IDeathLocation> capability, IDeathLocation instance, EnumFacing side) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("usedScroll", instance.hasUsedScroll());
            compound.func_74757_a("hasDeathLocation", instance.hasDeathLocation());
            if (instance.hasDeathLocation()) {
                compound.func_74768_a("dimension", instance.getDeathDimension());
                compound.func_74768_a("x", instance.getDeathLocation().func_177958_n());
                compound.func_74768_a("y", instance.getDeathLocation().func_177956_o());
                compound.func_74768_a("z", instance.getDeathLocation().func_177952_p());
            }
            return compound;
        }

        public void readNBT(Capability<IDeathLocation> capability, IDeathLocation instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound compound = (NBTTagCompound)nbt;
            instance.setUsedScroll(compound.func_74767_n("usedScroll"));
            instance.setHasDeathLocation(compound.func_74767_n("hasDeathLocation"));
            if (compound.func_74767_n("hasDeathLocation")) {
                instance.setDeathDimension(compound.func_74762_e("dimension"));
                instance.setDeathLocation(new BlockPos(compound.func_74762_e("x"), compound.func_74762_e("y"), compound.func_74762_e("z")));
            }
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTBase> {
        @CapabilityInject(value=IDeathLocation.class)
        public static final Capability<IDeathLocation> DEATH_LOC_CAP = null;
        private IDeathLocation instance = (IDeathLocation)DEATH_LOC_CAP.getDefaultInstance();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == DEATH_LOC_CAP;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(capability == DEATH_LOC_CAP ? DEATH_LOC_CAP.cast((Object)this.instance) : null);
        }

        public NBTBase serializeNBT() {
            return DEATH_LOC_CAP.getStorage().writeNBT(DEATH_LOC_CAP, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            DEATH_LOC_CAP.getStorage().readNBT(DEATH_LOC_CAP, (Object)this.instance, null, nbt);
        }
    }
}

