/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.packets;

import com.barribob.MaelstromMod.entity.animation.AnimationManager;
import com.barribob.MaelstromMod.init.ModBBAnimations;
import com.barribob.MaelstromMod.packets.PacketUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.logging.log4j.LogManager;

public class MessageBBAnimation
implements IMessage {
    private int animationId;
    private int entityId;
    private boolean remove;

    public MessageBBAnimation() {
    }

    public MessageBBAnimation(int animationId, int id, boolean remove) {
        this.animationId = animationId;
        this.entityId = id;
        this.remove = remove;
    }

    public void fromBytes(ByteBuf buf) {
        this.animationId = buf.readInt();
        this.entityId = buf.readInt();
        this.remove = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.animationId);
        buf.writeInt(this.entityId);
        buf.writeBoolean(this.remove);
    }

    public static class Handler
    implements IMessageHandler<MessageBBAnimation, IMessage> {
        public IMessage onMessage(MessageBBAnimation message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                Entity entity = PacketUtils.getWorld().func_73045_a(message.entityId);
                long time = System.currentTimeMillis();
                while (entity == null) {
                    if (System.currentTimeMillis() - time > 1000L) {
                        LogManager.getLogger().warn("Failed to recieve entity id for animation.");
                        break;
                    }
                    entity = PacketUtils.getWorld().func_73045_a(message.entityId);
                }
                if (entity != null && entity instanceof EntityLivingBase) {
                    AnimationManager.updateAnimation((EntityLivingBase)entity, ModBBAnimations.getAnimationName(message.animationId), message.remove);
                }
            });
            return null;
        }
    }
}

