/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.init;

import com.barribob.MaelstromMod.Main;
import com.barribob.MaelstromMod.entity.animation.AnimationManagerServer;
import com.barribob.MaelstromMod.packets.MessageBBAnimation;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;

public class ModBBAnimations {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<Integer, JsonObject> animations = new HashMap<Integer, JsonObject>();
    private static final Map<String, Integer> nameToId = new HashMap<String, Integer>();
    private static final Map<Integer, String> idToName = new HashMap<Integer, String>();
    private static int id = -1;

    public static void animation(EntityLivingBase entity, String animationId, boolean remove) {
        Main.network.sendToAllTracking((IMessage)new MessageBBAnimation(ModBBAnimations.getAnimationId(animationId), entity.func_145782_y(), remove), (Entity)entity);
        JsonObject animation = ModBBAnimations.getAnimation(animationId);
        if (animation.has("loop") && animation.get("loop").getAsBoolean()) {
            AnimationManagerServer.updateLooping(entity, animationId, remove);
        }
    }

    public static String getAnimationName(int id) {
        if (idToName.containsKey(id)) {
            return idToName.get(id);
        }
        return "";
    }

    public static int getAnimationId(String id) {
        if (nameToId.containsKey(id)) {
            return nameToId.get(id);
        }
        System.err.println("Could not find registered animation with id " + id);
        return -1;
    }

    public static JsonObject getAnimation(String id) {
        if (nameToId.containsKey(id)) {
            return animations.get(nameToId.get(id));
        }
        System.err.println("Could not find registered animation with id " + id);
        return new JsonObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JsonObject getAnimationUncached(String animationId) {
        JsonObject jsonObject;
        System.out.println("Warning: using the uncached version of animation loading");
        String[] s = animationId.split("(\\.)", 2);
        String filename = s[0];
        String animName = s[1];
        ResourceLocation loc = new ResourceLocation("mm", "animations/" + filename + ".json");
        JsonParser jsonparser = new JsonParser();
        IResource resource = null;
        try {
            resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(loc);
            JsonObject animationObject = jsonparser.parse(IOUtils.toString((InputStream)resource.func_110527_b(), (Charset)StandardCharsets.UTF_8)).getAsJsonObject();
            jsonObject = animationObject.getAsJsonObject("animations").getAsJsonObject(animName);
        }
        catch (IOException e) {
            try {
                System.err.println("Failed to load animation: " + filename + e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resource);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)resource);
            return new JsonObject();
        }
        IOUtils.closeQuietly((Closeable)resource);
        return jsonObject;
    }

    private static void registerAnimations(JsonObject animationFile, String filename) {
        if (!animationFile.get("format_version").getAsString().startsWith("1.8.0")) {
            System.err.println("Animation format not included for animation file: " + filename);
        }
        for (Map.Entry animation : animationFile.getAsJsonObject("animations").entrySet()) {
            nameToId.put(filename + "." + (String)animation.getKey(), ++id);
            animations.put(id, ((JsonElement)animation.getValue()).getAsJsonObject());
            idToName.put(id, filename + "." + (String)animation.getKey());
        }
    }

    public static void registerAnimations() {
        ModContainer myMod = null;
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            if (!mod.getModId().equals("mm")) continue;
            myMod = mod;
        }
        ModContainer mod = myMod;
        JsonContext ctx = new JsonContext(myMod.getModId());
        CraftingHelper.findFiles((ModContainer)myMod, (String)("assets/" + myMod.getModId() + "/animations"), root -> true, (root, file) -> {
            Loader.instance().setActiveModContainer(mod);
            String relative = root.relativize((Path)file).toString();
            if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || relative.startsWith("_")) {
                return true;
            }
            String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            ResourceLocation key = new ResourceLocation(ctx.getModId(), name);
            BufferedReader reader = null;
            try {
                reader = Files.newBufferedReader(file);
                JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
                ModBBAnimations.registerAnimations(json, name);
            }
            catch (IOException e) {
                LogManager.getLogger().error("Couldn't read animation {} from {}", (Object)key, file, (Object)e);
                Boolean bl = false;
                return bl;
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
            return true;
        }, (boolean)true, (boolean)true);
    }
}

