/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.event_handlers;

import com.barribob.MaelstromMod.config.ModConfig;
import com.barribob.MaelstromMod.renderer.CliffCloudRenderer;
import com.barribob.MaelstromMod.util.ModColors;
import com.barribob.MaelstromMod.util.ModUtils;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class FogHandler {
    public static float CLIFF_FOG_HEIGHT = 45.55f;
    public static final int SWAMP_FOG_LAYERS = 8;
    public static final int SWAMP_FOG_FADE_START = 5;
    private static final float CLOUD_FOG_HEIGHT = 239.25f;
    private static final IRenderHandler swampFogRenderer = new CliffCloudRenderer();
    private static Method setupFog;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onFogDensityRender(EntityViewRenderEvent.RenderFogEvent event) {
        if (event.getEntity().field_71093_bK == ModConfig.world.fracture_dimension_id) {
            int fogStartY = 70;
            float maxFog = 0.085f;
            float fogDensity = 0.005f;
            if (event.getEntity().field_70163_u < (double)fogStartY) {
                fogDensity += (float)((double)fogStartY - event.getEntity().field_70163_u) * (maxFog / (float)fogStartY);
            }
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            GlStateManager.func_179095_a((float)fogDensity);
        } else if (event.getEntity().field_71093_bK == ModConfig.world.cliff_dimension_id) {
            double posY = event.getEntity().func_174824_e((float)((float)event.getRenderPartialTicks())).field_72448_b;
            if (posY < (double)(CLIFF_FOG_HEIGHT + 8.0f + 5.0f)) {
                double maxFogThickness = 0.07f;
                double minFogThickness = 0.005f;
                double distanceFromMax = posY - (double)CLIFF_FOG_HEIGHT;
                double closenessToMax = distanceFromMax / 13.0;
                double fogThickness = maxFogThickness * MathHelper.func_151237_a((double)(1.0 - closenessToMax), (double)0.0, (double)1.0);
                GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
                GlStateManager.func_179095_a((float)((float)Math.max(fogThickness, minFogThickness)));
            } else {
                float fogStartY = 239.25f;
                float maxFogY = 2.0f;
                float maxFog = 0.045f;
                float fogDensity = 0.005f;
                if (event.getEntity().field_70163_u > (double)fogStartY) {
                    fogDensity = (float)((double)fogDensity + Math.min(1.0, Math.max(0.0, event.getEntity().field_70163_u - (double)fogStartY) / (double)maxFogY) * (double)maxFog);
                }
                GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
                GlStateManager.func_179095_a((float)fogDensity);
            }
        } else if (event.getEntity().field_71093_bK == ModConfig.world.dark_nexus_dimension_id) {
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            GlStateManager.func_179095_a((float)0.07f);
        }
    }

    private static Vec3d interpolateFogColor(Entity renderEntity, Vec3d fog1, Vec3d fog2, float transitionStart, float transitionLength) {
        float alpha = ModUtils.clamp((renderEntity.field_70163_u - (double)transitionStart) / (double)transitionLength, 0.0, 1.0);
        return fog1.func_186678_a((double)(1.0f - alpha)).func_178787_e(fog2.func_186678_a((double)alpha));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onFogColor(EntityViewRenderEvent.FogColors event) {
        if (event.getEntity().field_71093_bK == ModConfig.world.cliff_dimension_id) {
            Vec3d originalColor = new Vec3d((double)event.getRed(), (double)event.getGreen(), (double)event.getBlue());
            Vec3d cloudColor = new Vec3d(0.5, 0.43, 0.5);
            Vec3d color = FogHandler.interpolateFogColor(event.getEntity(), originalColor, cloudColor.func_186678_a(Math.sqrt(originalColor.func_189985_c() / cloudColor.func_189985_c())), 239.25f, 2.0f);
            Vec3d color2 = FogHandler.interpolateFogColor(event.getEntity(), ModColors.SWAMP_FOG.func_186678_a(Math.sqrt(color.func_189985_c() / ModColors.SWAMP_FOG.func_189985_c())), color, CLIFF_FOG_HEIGHT, 1.0f);
            event.setRed((float)color2.field_72450_a);
            event.setGreen((float)color2.field_72448_b);
            event.setBlue((float)color2.field_72449_c);
        }
        if (event.getEntity().field_71093_bK == ModConfig.world.dark_nexus_dimension_id) {
            event.setBlue(0.0f);
            event.setRed(0.0f);
            event.setGreen(0.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        if (ModConfig.shaders.render_fog) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.func_175606_aa().field_71093_bK == ModConfig.world.cliff_dimension_id) {
                if (setupFog == null) {
                    try {
                        setupFog = ReflectionHelper.findMethod(EntityRenderer.class, (String)"setupFog", (String)"func_78468_a", (Class[])new Class[]{Integer.TYPE, Float.TYPE});
                        setupFog.setAccessible(true);
                    }
                    catch (Exception e) {
                        System.out.println("Failed to render fog: " + e);
                    }
                }
                if (setupFog != null) {
                    try {
                        if (mc.func_175606_aa().field_70163_u > (double)CLIFF_FOG_HEIGHT) {
                            setupFog.invoke((Object)mc.field_71460_t, 0, Float.valueOf(event.getPartialTicks()));
                            swampFogRenderer.render(event.getPartialTicks(), Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x());
                            GlStateManager.func_179106_n();
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Failed to render fog: " + e);
                        GlStateManager.func_179106_n();
                    }
                }
            }
        }
    }
}

