/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.tileentity;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMegaStructure
extends TileEntityStructure {
    private String name = "";
    private String author = "";
    private String metadata = "";
    private BlockPos position = new BlockPos(0, 1, 0);
    private BlockPos size = BlockPos.field_177992_a;
    private Mirror mirror = Mirror.NONE;
    private Rotation rotation = Rotation.NONE;
    private TileEntityStructure.Mode mode = TileEntityStructure.Mode.DATA;
    private boolean ignoreEntities = true;
    private boolean powered;
    private boolean showAir;
    private boolean showBoundingBox = true;
    private float integrity = 1.0f;
    private long seed;

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("name", this.name);
        compound.func_74778_a("author", this.author);
        compound.func_74778_a("metadata", this.metadata);
        compound.func_74768_a("posX", this.position.func_177958_n());
        compound.func_74768_a("posY", this.position.func_177956_o());
        compound.func_74768_a("posZ", this.position.func_177952_p());
        compound.func_74768_a("sizeX", this.size.func_177958_n());
        compound.func_74768_a("sizeY", this.size.func_177956_o());
        compound.func_74768_a("sizeZ", this.size.func_177952_p());
        compound.func_74778_a("rotation", this.rotation.toString());
        compound.func_74778_a("mirror", this.mirror.toString());
        compound.func_74778_a("mode", this.mode.toString());
        compound.func_74757_a("ignoreEntities", this.ignoreEntities);
        compound.func_74757_a("powered", this.powered);
        compound.func_74757_a("showair", this.showAir);
        compound.func_74757_a("showboundingbox", this.showBoundingBox);
        compound.func_74776_a("integrity", this.integrity);
        compound.func_74772_a("seed", this.seed);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.func_184404_a(compound.func_74779_i("name"));
        this.author = compound.func_74779_i("author");
        this.metadata = compound.func_74779_i("metadata");
        int i = MathHelper.func_76125_a((int)compound.func_74762_e("posX"), (int)-1000, (int)1000);
        int j = MathHelper.func_76125_a((int)compound.func_74762_e("posY"), (int)-1000, (int)1000);
        int k = MathHelper.func_76125_a((int)compound.func_74762_e("posZ"), (int)-1000, (int)1000);
        this.position = new BlockPos(i, j, k);
        int l = MathHelper.func_76125_a((int)compound.func_74762_e("sizeX"), (int)0, (int)1000);
        int i1 = MathHelper.func_76125_a((int)compound.func_74762_e("sizeY"), (int)0, (int)1000);
        int j1 = MathHelper.func_76125_a((int)compound.func_74762_e("sizeZ"), (int)0, (int)1000);
        this.size = new BlockPos(l, i1, j1);
        try {
            this.rotation = Rotation.valueOf((String)compound.func_74779_i("rotation"));
        }
        catch (IllegalArgumentException var11) {
            this.rotation = Rotation.NONE;
        }
        try {
            this.mirror = Mirror.valueOf((String)compound.func_74779_i("mirror"));
        }
        catch (IllegalArgumentException var10) {
            this.mirror = Mirror.NONE;
        }
        try {
            this.mode = TileEntityStructure.Mode.valueOf((String)compound.func_74779_i("mode"));
        }
        catch (IllegalArgumentException var9) {
            this.mode = TileEntityStructure.Mode.DATA;
        }
        this.ignoreEntities = compound.func_74767_n("ignoreEntities");
        this.powered = compound.func_74767_n("powered");
        this.showAir = compound.func_74767_n("showair");
        this.showBoundingBox = compound.func_74767_n("showboundingbox");
        this.integrity = compound.func_74764_b("integrity") ? compound.func_74760_g("integrity") : 1.0f;
        this.seed = compound.func_74763_f("seed");
        this.updateBlockState();
    }

    private void updateBlockState() {
        BlockPos blockpos;
        IBlockState iblockstate;
        if (this.field_145850_b != null && (iblockstate = this.field_145850_b.func_180495_p(blockpos = this.func_174877_v())).func_177230_c() == Blocks.field_185779_df) {
            this.field_145850_b.func_180501_a(blockpos, iblockstate.func_177226_a((IProperty)BlockStructure.field_185587_a, (Comparable)this.mode), 2);
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 7, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean func_189701_a(EntityPlayer player) {
        if (!player.func_189808_dh()) {
            return false;
        }
        if (player.func_130014_f_().field_72995_K) {
            player.func_189807_a((TileEntityStructure)this);
        }
        return true;
    }

    public String func_189715_d() {
        return this.name;
    }

    public void func_184404_a(String nameIn) {
        String s = nameIn;
        for (char c0 : ChatAllowedCharacters.field_189861_b) {
            s = s.replace(c0, '_');
        }
        this.name = s;
    }

    public void func_189720_a(EntityLivingBase p_189720_1_) {
        if (!StringUtils.func_151246_b((String)p_189720_1_.func_70005_c_())) {
            this.author = p_189720_1_.func_70005_c_();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockPos func_189711_e() {
        return this.position;
    }

    public void func_184414_b(BlockPos posIn) {
        this.position = posIn;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockPos func_189717_g() {
        return this.size;
    }

    public void func_184409_c(BlockPos sizeIn) {
        this.size = new BlockPos(27, 62, 27);
    }

    @SideOnly(value=Side.CLIENT)
    public Mirror func_189716_h() {
        return this.mirror;
    }

    public void func_184411_a(Mirror mirrorIn) {
        this.mirror = mirrorIn;
    }

    public void func_184408_a(Rotation rotationIn) {
        this.rotation = rotationIn;
    }

    public void func_184410_b(String metadataIn) {
        this.metadata = metadataIn;
    }

    @SideOnly(value=Side.CLIENT)
    public Rotation func_189726_i() {
        return this.rotation;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_189708_j() {
        return this.metadata;
    }

    public TileEntityStructure.Mode func_189700_k() {
        return this.mode;
    }

    public void func_184405_a(TileEntityStructure.Mode modeIn) {
        this.mode = modeIn;
        IBlockState iblockstate = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (iblockstate.func_177230_c() == Blocks.field_185779_df) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), iblockstate.func_177226_a((IProperty)BlockStructure.field_185587_a, (Comparable)modeIn), 2);
        }
    }

    public void func_184406_a(boolean ignoreEntitiesIn) {
        this.ignoreEntities = ignoreEntitiesIn;
    }

    public void func_189718_a(float integrityIn) {
        this.integrity = integrityIn;
    }

    public void func_189725_a(long seedIn) {
        this.seed = seedIn;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_189724_l() {
        switch (this.func_189700_k()) {
            case SAVE: {
                this.func_184405_a(TileEntityStructure.Mode.LOAD);
                break;
            }
            case LOAD: {
                this.func_184405_a(TileEntityStructure.Mode.CORNER);
                break;
            }
            case CORNER: {
                this.func_184405_a(TileEntityStructure.Mode.DATA);
                break;
            }
            case DATA: {
                this.func_184405_a(TileEntityStructure.Mode.SAVE);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_189713_m() {
        return this.ignoreEntities;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_189702_n() {
        return this.integrity;
    }

    @SideOnly(value=Side.CLIENT)
    public long func_189719_o() {
        return this.seed;
    }

    public boolean func_184417_l() {
        BlockPos blockpos2;
        if (this.mode != TileEntityStructure.Mode.SAVE) {
            return false;
        }
        BlockPos blockpos = this.func_174877_v();
        int i = 80;
        BlockPos blockpos1 = new BlockPos(blockpos.func_177958_n() - 80, 0, blockpos.func_177952_p() - 80);
        List<TileEntityStructure> list = this.getNearbyCornerBlocks(blockpos1, blockpos2 = new BlockPos(blockpos.func_177958_n() + 80, 255, blockpos.func_177952_p() + 80));
        List<TileEntityStructure> list1 = this.filterRelatedCornerBlocks(list);
        if (list1.size() < 1) {
            return false;
        }
        StructureBoundingBox structureboundingbox = this.calculateEnclosingBoundingBox(blockpos, list1);
        if (structureboundingbox.field_78893_d - structureboundingbox.field_78897_a > 1 && structureboundingbox.field_78894_e - structureboundingbox.field_78895_b > 1 && structureboundingbox.field_78892_f - structureboundingbox.field_78896_c > 1) {
            this.position = new BlockPos(structureboundingbox.field_78897_a - blockpos.func_177958_n() + 1, structureboundingbox.field_78895_b - blockpos.func_177956_o() + 1, structureboundingbox.field_78896_c - blockpos.func_177952_p() + 1);
            this.size = new BlockPos(structureboundingbox.field_78893_d - structureboundingbox.field_78897_a - 1, structureboundingbox.field_78894_e - structureboundingbox.field_78895_b - 1, structureboundingbox.field_78892_f - structureboundingbox.field_78896_c - 1);
            this.func_70296_d();
            IBlockState iblockstate = this.field_145850_b.func_180495_p(blockpos);
            this.field_145850_b.func_184138_a(blockpos, iblockstate, iblockstate, 3);
            return true;
        }
        return false;
    }

    private List<TileEntityStructure> filterRelatedCornerBlocks(List<TileEntityStructure> p_184415_1_) {
        Iterable iterable = Iterables.filter(p_184415_1_, (Predicate)new Predicate<TileEntityStructure>(){

            public boolean apply(@Nullable TileEntityStructure p_apply_1_) {
                if (p_apply_1_ instanceof TileEntityMegaStructure) {
                    return ((TileEntityMegaStructure)p_apply_1_).mode == TileEntityStructure.Mode.CORNER && TileEntityMegaStructure.this.name.equals(((TileEntityMegaStructure)p_apply_1_).name);
                }
                return false;
            }
        });
        return Lists.newArrayList((Iterable)iterable);
    }

    private List<TileEntityStructure> getNearbyCornerBlocks(BlockPos p_184418_1_, BlockPos p_184418_2_) {
        ArrayList list = Lists.newArrayList();
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)p_184418_1_, (BlockPos)p_184418_2_)) {
            TileEntity tileentity;
            IBlockState iblockstate = this.field_145850_b.func_180495_p((BlockPos)blockpos$mutableblockpos);
            if (iblockstate.func_177230_c() != Blocks.field_185779_df || (tileentity = this.field_145850_b.func_175625_s((BlockPos)blockpos$mutableblockpos)) == null || !(tileentity instanceof TileEntityStructure)) continue;
            list.add((TileEntityStructure)tileentity);
        }
        return list;
    }

    private StructureBoundingBox calculateEnclosingBoundingBox(BlockPos p_184416_1_, List<TileEntityStructure> p_184416_2_) {
        StructureBoundingBox structureboundingbox;
        if (p_184416_2_.size() > 1) {
            BlockPos blockpos = p_184416_2_.get(0).func_174877_v();
            structureboundingbox = new StructureBoundingBox((Vec3i)blockpos, (Vec3i)blockpos);
        } else {
            structureboundingbox = new StructureBoundingBox((Vec3i)p_184416_1_, (Vec3i)p_184416_1_);
        }
        for (TileEntityStructure tileentitystructure : p_184416_2_) {
            BlockPos blockpos1 = tileentitystructure.func_174877_v();
            if (blockpos1.func_177958_n() < structureboundingbox.field_78897_a) {
                structureboundingbox.field_78897_a = blockpos1.func_177958_n();
            } else if (blockpos1.func_177958_n() > structureboundingbox.field_78893_d) {
                structureboundingbox.field_78893_d = blockpos1.func_177958_n();
            }
            if (blockpos1.func_177956_o() < structureboundingbox.field_78895_b) {
                structureboundingbox.field_78895_b = blockpos1.func_177956_o();
            } else if (blockpos1.func_177956_o() > structureboundingbox.field_78894_e) {
                structureboundingbox.field_78894_e = blockpos1.func_177956_o();
            }
            if (blockpos1.func_177952_p() < structureboundingbox.field_78896_c) {
                structureboundingbox.field_78896_c = blockpos1.func_177952_p();
                continue;
            }
            if (blockpos1.func_177952_p() <= structureboundingbox.field_78892_f) continue;
            structureboundingbox.field_78892_f = blockpos1.func_177952_p();
        }
        return structureboundingbox;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_189705_a(ByteBuf buf) {
        buf.writeInt(this.field_174879_c.func_177958_n());
        buf.writeInt(this.field_174879_c.func_177956_o());
        buf.writeInt(this.field_174879_c.func_177952_p());
    }

    public boolean func_184419_m() {
        return this.func_189712_b(true);
    }

    public boolean func_189712_b(boolean writeToDisk) {
        if (this.mode == TileEntityStructure.Mode.SAVE && !this.field_145850_b.field_72995_K && !StringUtils.func_151246_b((String)this.name)) {
            BlockPos blockpos = this.func_174877_v().func_177971_a((Vec3i)this.position);
            return this.saveStructure(writeToDisk, blockpos, this.size, this.name);
        }
        return false;
    }

    private boolean saveStructure(boolean writeToDisk, BlockPos startPos, BlockPos size, String structureName) {
        WorldServer worldserver = (WorldServer)this.field_145850_b;
        MinecraftServer minecraftserver = this.field_145850_b.func_73046_m();
        TemplateManager templatemanager = worldserver.func_184163_y();
        Template template = templatemanager.func_186237_a(minecraftserver, new ResourceLocation(structureName));
        template.func_186254_a(this.field_145850_b, startPos, size, !this.ignoreEntities, Blocks.field_150350_a);
        NBTTagCompound nbt = new NBTTagCompound();
        template.func_189552_a(nbt);
        NBTTagList blocks = nbt.func_150295_c("blocks", (int)nbt.func_74732_a());
        if (blocks.func_82582_d()) {
            System.out.println("Empty chunk: not saving");
            return false;
        }
        template.func_186252_a(this.author);
        return !writeToDisk || templatemanager.func_186238_c(minecraftserver, new ResourceLocation(structureName));
    }

    public boolean func_184412_n() {
        return this.func_189714_c(true);
    }

    public boolean func_189714_c(boolean requireMatchingSize) {
        if (this.mode == TileEntityStructure.Mode.LOAD && !this.field_145850_b.field_72995_K && !StringUtils.func_151246_b((String)this.name)) {
            BlockPos blockpos2;
            boolean flag;
            BlockPos blockpos = this.func_174877_v();
            BlockPos blockpos1 = blockpos.func_177971_a((Vec3i)this.position);
            WorldServer worldserver = (WorldServer)this.field_145850_b;
            MinecraftServer minecraftserver = this.field_145850_b.func_73046_m();
            TemplateManager templatemanager = worldserver.func_184163_y();
            Template template = templatemanager.func_189942_b(minecraftserver, new ResourceLocation(this.name));
            if (template == null) {
                return false;
            }
            if (!StringUtils.func_151246_b((String)template.func_186261_b())) {
                this.author = template.func_186261_b();
            }
            if (!(flag = this.size.equals((Object)(blockpos2 = template.func_186259_a())))) {
                this.size = blockpos2;
                this.func_70296_d();
                IBlockState iblockstate = this.field_145850_b.func_180495_p(blockpos);
                this.field_145850_b.func_184138_a(blockpos, iblockstate, iblockstate, 3);
            }
            if (requireMatchingSize && !flag) {
                return false;
            }
            PlacementSettings placementsettings = new PlacementSettings().func_186214_a(this.mirror).func_186220_a(this.rotation).func_186222_a(this.ignoreEntities).func_186218_a(null).func_186225_a(null).func_186226_b(false);
            if (this.integrity < 1.0f) {
                placementsettings.func_189946_a(MathHelper.func_76131_a((float)this.integrity, (float)0.0f, (float)1.0f)).func_189949_a(Long.valueOf(this.seed));
            }
            template.func_186260_a(this.field_145850_b, blockpos1, placementsettings);
            return true;
        }
        return false;
    }

    public void func_189706_E() {
        WorldServer worldserver = (WorldServer)this.field_145850_b;
        TemplateManager templatemanager = worldserver.func_184163_y();
        templatemanager.func_189941_a(new ResourceLocation(this.name));
    }

    public boolean func_189709_F() {
        if (this.mode == TileEntityStructure.Mode.LOAD && !this.field_145850_b.field_72995_K) {
            WorldServer worldserver = (WorldServer)this.field_145850_b;
            MinecraftServer minecraftserver = this.field_145850_b.func_73046_m();
            TemplateManager templatemanager = worldserver.func_184163_y();
            return templatemanager.func_189942_b(minecraftserver, new ResourceLocation(this.name)) != null;
        }
        return false;
    }

    public boolean func_189722_G() {
        return this.powered;
    }

    public void func_189723_d(boolean poweredIn) {
        this.powered = poweredIn;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_189707_H() {
        return this.showAir;
    }

    public void func_189703_e(boolean showAirIn) {
        this.showAir = showAirIn;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_189721_I() {
        return this.showBoundingBox;
    }

    public void func_189710_f(boolean showBoundingBoxIn) {
        this.showBoundingBox = showBoundingBoxIn;
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("structure_block.hover." + this.mode.func_176610_l(), new Object[]{this.mode == TileEntityStructure.Mode.DATA ? this.metadata : this.name});
    }

    public static enum Mode implements IStringSerializable
    {
        SAVE("save", 0),
        LOAD("load", 1),
        CORNER("corner", 2),
        DATA("data", 3);

        private static final Mode[] MODES;
        private final String modeName;
        private final int modeId;

        private Mode(String modeNameIn, int modeIdIn) {
            this.modeName = modeNameIn;
            this.modeId = modeIdIn;
        }

        public String func_176610_l() {
            return this.modeName;
        }

        public int getModeId() {
            return this.modeId;
        }

        public static Mode getById(int id) {
            return id >= 0 && id < MODES.length ? MODES[id] : MODES[0];
        }

        static {
            MODES = new Mode[Mode.values().length];
            Mode[] modeArray = Mode.values();
            int n = modeArray.length;
            for (int i = 0; i < n; ++i) {
                Mode tileentitystructure$mode;
                Mode.MODES[tileentitystructure$mode.getModeId()] = tileentitystructure$mode = modeArray[i];
            }
        }
    }
}

