/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.render;

import com.barribob.MaelstromMod.config.ModConfig;
import com.barribob.MaelstromMod.entity.entities.EntityLeveledMob;
import com.barribob.MaelstromMod.entity.entities.EntityMaelstromMob;
import com.barribob.MaelstromMod.renderer.ITarget;
import com.barribob.MaelstromMod.util.Element;
import com.barribob.MaelstromMod.util.IElement;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.RenderUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class RenderModEntity<T extends EntityLiving>
extends RenderLiving<T> {
    public String[] TEXTURES;
    private final ResourceLocation DEATH_TEXTURES;

    public <U extends ModelBase> RenderModEntity(RenderManager rendermanagerIn, String textures, U modelClass) {
        this(rendermanagerIn, modelClass, textures);
    }

    public <U extends ModelBase> RenderModEntity(RenderManager rendermanagerIn, U modelClass, String ... textures) {
        super(rendermanagerIn, modelClass, 0.5f);
        if (textures.length == 0) {
            throw new IllegalArgumentException("Must provide at least one texture to render an entity.");
        }
        this.TEXTURES = textures;
        this.DEATH_TEXTURES = new ResourceLocation(String.format("%s:textures/entity/disintegration_%d_%d.png", "mm", modelClass.field_78090_t, modelClass.field_78089_u));
    }

    protected ResourceLocation getEntityTexture(T entity) {
        String texture = this.TEXTURES[0];
        if (entity instanceof IElement) {
            IElement e = (IElement)entity;
            if (e.getElement().equals((Object)Element.AZURE) && this.TEXTURES.length >= 2 && this.TEXTURES[1] != null) {
                texture = this.TEXTURES[1];
            } else if (e.getElement().equals((Object)Element.GOLDEN) && this.TEXTURES.length >= 3 && this.TEXTURES[2] != null) {
                texture = this.TEXTURES[2];
            } else if (e.getElement().equals((Object)Element.CRIMSON) && this.TEXTURES.length >= 4 && this.TEXTURES[3] != null) {
                texture = this.TEXTURES[3];
            }
        }
        return new ResourceLocation("mm:textures/entity/" + texture);
    }

    protected void applyRotations(T entityLiving, float p_77043_2_, float rotationYaw, float partialTicks) {
        if (entityLiving instanceof EntityMaelstromMob && Minecraft.func_71410_x().func_147110_a().isStencilEnabled() && GL11.glGetInteger((int)3415) > 0) {
            GlStateManager.func_179114_b((float)(180.0f - rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            super.func_77043_a(entityLiving, p_77043_2_, rotationYaw, partialTicks);
        }
    }

    protected void renderModel(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        if (entity instanceof EntityMaelstromMob) {
            if (entity.func_110143_aJ() <= 0.0f && Minecraft.func_71410_x().func_147110_a().isStencilEnabled() && GL11.glGetInteger((int)3415) > 0) {
                float f = (float)((EntityLiving)entity).field_70725_aQ / 15.0f;
                int stencilVal = 42;
                int maskPass = 255;
                GL11.glEnable((int)2960);
                GlStateManager.func_179086_m((int)1024);
                GL11.glStencilOp((int)7680, (int)7680, (int)7681);
                GL11.glStencilFunc((int)519, (int)stencilVal, (int)maskPass);
                GL11.glStencilMask((int)255);
                GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179141_d();
                GlStateManager.func_179092_a((int)516, (float)f);
                this.func_110776_a(this.DEATH_TEXTURES);
                this.field_77045_g.func_78088_a(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
                GL11.glEnable((int)16384);
                GL11.glStencilOp((int)7680, (int)7680, (int)7680);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179132_a((boolean)true);
                GL11.glStencilFunc((int)517, (int)0, (int)maskPass);
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                super.func_77036_a(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
                GL11.glDisable((int)2960);
            } else {
                super.func_77036_a(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            }
        } else {
            super.func_77036_a(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
        }
    }

    public void func_76986_a(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (!entity.func_82150_aj()) {
            double maxDistance;
            double d0;
            GlStateManager.func_179108_z();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
            GlStateManager.func_179084_k();
            GlStateManager.func_179133_A();
            if (entity instanceof EntityLeveledMob) {
                ((EntityLeveledMob)entity).doRender(this.field_76990_c, x, y, z, entityYaw, partialTicks);
                if (ModConfig.entities.displayLevel) {
                    this.func_147906_a((Entity)entity, "Level: " + ((EntityLeveledMob)entity).getLevel(), x, y, z, 10);
                }
            }
            if (entity instanceof IElement && !((IElement)entity).getElement().equals((Object)Element.NONE) && !ModConfig.gui.disableElementalVisuals && (d0 = entity.func_70068_e(this.field_76990_c.field_78734_h)) <= (maxDistance = 20.0) * maxDistance) {
                boolean flag = entity.func_70093_af();
                float f = this.field_76990_c.field_78735_i;
                float f1 = this.field_76990_c.field_78732_j;
                boolean flag1 = this.field_76990_c.field_78733_k.field_74320_O == 2;
                float f2 = ((EntityLiving)entity).field_70131_O + 0.5f - (flag ? 0.25f : 0.0f);
                int verticalOffset = this.func_177070_b((EntityLiving)entity) ? -6 : 0;
                float scale = (float)entity.func_174813_aQ().func_72320_b();
                RenderUtils.drawElement(this.func_76983_a(), ((IElement)entity).getElement().textColor + ((IElement)entity).getElement().symbol, (float)x, (float)y + f2, (float)z, verticalOffset, f, f1, flag1, flag, ((EntityLiving)entity).field_70173_aa, partialTicks, scale);
            }
        } else {
            super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
        }
    }

    public boolean func_177071_a(@Nonnull T livingEntity, @Nonnull ICamera camera, double camX, double camY, double camZ) {
        Optional<Vec3d> optional;
        if (super.func_177071_a(livingEntity, camera, camX, camY, camZ)) {
            return true;
        }
        if (livingEntity instanceof ITarget && (optional = ((ITarget)livingEntity).getTarget()).isPresent()) {
            Vec3d end = optional.get();
            Vec3d start = livingEntity.func_174824_e(1.0f);
            return camera.func_78546_a(ModUtils.makeBox(start, end));
        }
        return false;
    }
}

