/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.projectile;

import com.barribob.MaelstromMod.entity.entities.EntityMaelstromMob;
import com.barribob.MaelstromMod.entity.projectile.Projectile;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ProjectileHomingFlame
extends Projectile {
    private static final int AGE = 160;

    public ProjectileHomingFlame(World worldIn, EntityLivingBase throwerIn, float baseDamage) {
        super(worldIn, throwerIn, baseDamage);
    }

    public ProjectileHomingFlame(World worldIn) {
        super(worldIn);
    }

    public ProjectileHomingFlame(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    @Override
    public void func_70071_h_() {
        Vec3d prevVel = ModUtils.getEntityVelocity(this);
        super.func_70071_h_();
        ModUtils.setEntityVelocity(this, prevVel);
        double speed = 0.04;
        if (!this.field_70170_p.field_72995_K && this.shootingEntity != null && this.shootingEntity instanceof EntityLiving && ((EntityLiving)this.shootingEntity).func_70638_az() != null) {
            ModUtils.homeToPosition(this, speed, ((EntityLiving)this.shootingEntity).func_70638_az().func_174824_e(1.0f));
        }
        if (!this.field_70170_p.field_72995_K) {
            ModUtils.avoidOtherEntities(this, speed, 4, e -> e instanceof ProjectileHomingFlame);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 160) {
            this.onHit(null);
        }
        if (this.shootingEntity != null && this.shootingEntity.field_70128_L) {
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 3 == 0) {
            this.func_184185_a(SoundEvents.field_187835_fT, 0.2f, ModRandom.getFloat(0.2f) + 0.3f);
        }
    }

    @Override
    protected void spawnImpactParticles() {
        ParticleManager.spawnColoredExplosion(this.field_70170_p, this.func_174791_d(), Vec3d.field_186680_a);
        super.spawnImpactParticles();
    }

    @Override
    protected void spawnParticles() {
        for (int i = 0; i < 4; ++i) {
            float colorAge = ModUtils.clamp((float)(160 - this.field_70173_aa) / 160.0f, 0.1, 1.0);
            ParticleManager.spawnColoredFire(this.field_70170_p, this.field_70146_Z, this.func_174791_d().func_178787_e(ModRandom.randVec().func_186678_a(0.25)), new Vec3d(0.8, 1.0, (double)this.field_70146_Z.nextFloat()).func_186678_a((double)colorAge));
        }
    }

    @Override
    protected void onHit(@Nullable RayTraceResult result) {
        if (result != null && EntityMaelstromMob.isMaelstromMob(result.field_72308_g)) {
            return;
        }
        DamageSource source = ModDamageSource.builder().type("mm:thrownMaelstrom").directEntity(this).indirectEntity((Entity)this.shootingEntity).element(this.getElement()).stoppedByArmorNotShields().build();
        ModUtils.handleAreaImpact(0.6f, e -> Float.valueOf(this.getDamage()), (Entity)this.shootingEntity, this.func_174791_d(), source, 0.0f, 0, false);
        this.func_184185_a(SoundEvents.field_187775_eP, 1.0f, 1.0f + ModRandom.getFloat(0.2f));
        super.onHit(result);
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (!this.field_70128_L && amount > 0.0f) {
            this.func_70106_y();
            this.onHit(null);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70067_L() {
        return true;
    }

    @Override
    public boolean func_70075_an() {
        return true;
    }

    public int func_70070_b() {
        float colorAge = ModUtils.clamp((float)(160 - this.field_70173_aa) / 160.0f, 0.0, 1.0) * 255.0f;
        return (int)colorAge;
    }
}

