/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.projectile;

import com.barribob.MaelstromMod.entity.projectile.ProjectileGun;
import com.barribob.MaelstromMod.util.ModColors;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ProjectileGoldenFireball
extends ProjectileGun {
    private static final int PARTICLE_AMOUNT = 15;
    private static final int IMPACT_PARTICLE_AMOUNT = 10;
    private static final int EXPOSION_AREA_FACTOR = 4;

    public ProjectileGoldenFireball(World worldIn, EntityLivingBase throwerIn, float baseDamage, ItemStack stack) {
        super(worldIn, throwerIn, baseDamage, stack);
        this.func_189654_d(true);
    }

    public ProjectileGoldenFireball(World worldIn) {
        super(worldIn);
        this.func_189654_d(true);
    }

    public ProjectileGoldenFireball(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
        this.func_189654_d(true);
    }

    @Override
    protected void spawnParticles() {
        float size = 0.5f;
        for (int i = 0; i < 15; ++i) {
            ParticleManager.spawnCustomSmoke(this.field_70170_p, this.func_174791_d().func_178787_e(ModRandom.randVec().func_186678_a((double)size)), ModColors.YELLOW, ModUtils.yVec(0.1f));
        }
    }

    @Override
    protected void spawnImpactParticles() {
        int i;
        for (i = 0; i < 1000; ++i) {
            Vec3d unit = new Vec3d(0.0, 1.0, 0.0);
            unit = unit.func_178789_a((float)(Math.PI * (double)ModRandom.getFloat(1.0f)));
            unit = unit.func_178785_b((float)(Math.PI * (double)ModRandom.getFloat(1.0f)));
            unit = unit.func_72432_b().func_186678_a(4.0);
            ParticleManager.spawnSplit(this.field_70170_p, unit.func_178787_e(this.func_174791_d()), ModColors.YELLOW, Vec3d.field_186680_a);
        }
        for (i = 0; i < 10; ++i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + (double)ModRandom.getFloat(4.0f), this.field_70163_u + (double)ModRandom.getFloat(4.0f), this.field_70161_v + (double)ModRandom.getFloat(4.0f), 0.0, 0.0, 0.0, new int[0]);
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (double)ModRandom.getFloat(4.0f), this.field_70163_u + (double)ModRandom.getFloat(4.0f), this.field_70161_v + (double)ModRandom.getFloat(4.0f), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    protected void onHit(RayTraceResult result) {
        float knockbackFactor = 1.1f + (float)this.getKnockback() * 0.4f;
        int fireFactor = this.func_70027_ad() ? 10 : 5;
        ModUtils.handleAreaImpact(4.0f, e -> Float.valueOf(this.getGunDamage((Entity)e)), (Entity)this.shootingEntity, this.func_174791_d(), ModDamageSource.causeElementalExplosionDamage(this.shootingEntity, this.getElement()), knockbackFactor, fireFactor);
        this.func_184185_a(SoundEvents.field_187539_bB, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        super.onHit(result);
    }
}

