/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.projectile;

import com.barribob.MaelstromMod.entity.projectile.Projectile;
import com.barribob.MaelstromMod.util.Element;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ProjectileBeastAttack
extends Projectile {
    private static final int PARTICLE_AMOUNT = 3;
    private static final int IMPACT_PARTICLE_AMOUNT = 20;

    public ProjectileBeastAttack(World worldIn, EntityLivingBase throwerIn, float damage) {
        super(worldIn, throwerIn, damage);
    }

    public ProjectileBeastAttack(World worldIn) {
        super(worldIn);
    }

    public ProjectileBeastAttack(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    @Override
    protected void spawnParticles() {
        for (int i = 0; i < 3; ++i) {
            ParticleManager.spawnSmoke2(this.field_70170_p, this.func_174791_d().func_178787_e(ModRandom.randVec().func_186678_a(0.5)), this.getElement().particleColor, ModUtils.yVec(0.1f));
        }
    }

    @Override
    protected void spawnImpactParticles() {
        for (int i = 0; i < 20; ++i) {
            ParticleManager.spawnSmoke2(this.field_70170_p, this.func_174791_d().func_178787_e(ModRandom.randVec()), this.getElement().particleColor, ModUtils.yVec(0.1f));
        }
    }

    @Override
    protected void onHit(RayTraceResult result) {
        ModUtils.handleBulletImpact(result.field_72308_g, this, this.getDamage(), ModDamageSource.causeElementalThrownDamage(this, (Entity)this.shootingEntity, this.getElement()), 1, (proj, entity) -> {
            if (this.getElement().equals((Object)Element.CRIMSON) && entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 100));
            }
        }, (proj, entity) -> {});
        super.onHit(result);
    }
}

