/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.projectile;

import com.barribob.MaelstromMod.entity.entities.EntityMaelstromMob;
import com.barribob.MaelstromMod.util.ModColors;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityHealerOrb
extends Entity {
    private EntityMaelstromMob owner;
    private Entity target;
    private Vec3d tempTarget;
    @Nullable
    private UUID ownerUniqueId;
    private BlockPos ownerBlockPos;
    @Nullable
    private UUID targetUniqueId;
    private BlockPos targetBlockPos;

    public EntityHealerOrb(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.3125f, 0.3125f);
        this.field_70145_X = true;
    }

    @SideOnly(value=Side.CLIENT)
    public EntityHealerOrb(World worldIn, double x, double y, double z, double motionXIn, double motionYIn, double motionZIn) {
        this(worldIn);
        this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        this.field_70159_w = motionXIn;
        this.field_70181_x = motionYIn;
        this.field_70179_y = motionZIn;
    }

    public EntityHealerOrb(World worldIn, EntityMaelstromMob ownerIn, Entity targetIn) {
        this(worldIn);
        this.owner = ownerIn;
        this.func_70012_b(ownerIn.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v, this.field_70177_z, this.field_70125_A);
        this.target = targetIn;
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.owner != null) {
            BlockPos blockpos = new BlockPos((Entity)this.owner);
            NBTTagCompound nbttagcompound = NBTUtil.func_186862_a((UUID)this.owner.func_110124_au());
            nbttagcompound.func_74768_a("X", blockpos.func_177958_n());
            nbttagcompound.func_74768_a("Y", blockpos.func_177956_o());
            nbttagcompound.func_74768_a("Z", blockpos.func_177952_p());
            compound.func_74782_a("Owner", (NBTBase)nbttagcompound);
        }
        if (this.target != null) {
            BlockPos blockpos1 = new BlockPos(this.target);
            NBTTagCompound nbttagcompound1 = NBTUtil.func_186862_a((UUID)this.target.func_110124_au());
            nbttagcompound1.func_74768_a("X", blockpos1.func_177958_n());
            nbttagcompound1.func_74768_a("Y", blockpos1.func_177956_o());
            nbttagcompound1.func_74768_a("Z", blockpos1.func_177952_p());
            compound.func_74782_a("Target", (NBTBase)nbttagcompound1);
        }
        compound.func_74780_a("TXD", this.tempTarget.field_72450_a);
        compound.func_74780_a("TYD", this.tempTarget.field_72448_b);
        compound.func_74780_a("TZD", this.tempTarget.field_72449_c);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.tempTarget = new Vec3d(compound.func_74769_h("TXD"), compound.func_74769_h("TYD"), compound.func_74769_h("TZD"));
        if (compound.func_150297_b("Owner", 10)) {
            NBTTagCompound nbttagcompound = compound.func_74775_l("Owner");
            this.ownerUniqueId = NBTUtil.func_186860_b((NBTTagCompound)nbttagcompound);
            this.ownerBlockPos = new BlockPos(nbttagcompound.func_74762_e("X"), nbttagcompound.func_74762_e("Y"), nbttagcompound.func_74762_e("Z"));
        }
        if (compound.func_150297_b("Target", 10)) {
            NBTTagCompound nbttagcompound1 = compound.func_74775_l("Target");
            this.targetUniqueId = NBTUtil.func_186860_b((NBTTagCompound)nbttagcompound1);
            this.targetBlockPos = new BlockPos(nbttagcompound1.func_74762_e("X"), nbttagcompound1.func_74762_e("Y"), nbttagcompound1.func_74762_e("Z"));
        }
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        } else {
            Vec3d direction;
            super.func_70071_h_();
            if (!this.field_70170_p.field_72995_K) {
                RayTraceResult raytraceresult;
                if (this.tempTarget == null) {
                    this.findNextTargetPosition();
                }
                if (this.target == null && this.targetUniqueId != null) {
                    for (EntityLivingBase entitylivingbase : this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.targetBlockPos.func_177982_a(-2, -2, -2), this.targetBlockPos.func_177982_a(2, 2, 2)))) {
                        if (!entitylivingbase.func_110124_au().equals(this.targetUniqueId)) continue;
                        this.target = entitylivingbase;
                        break;
                    }
                    this.targetUniqueId = null;
                }
                if (this.owner == null && this.ownerUniqueId != null) {
                    for (EntityLivingBase entity2 : this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.ownerBlockPos.func_177982_a(-2, -2, -2), this.ownerBlockPos.func_177982_a(2, 2, 2)))) {
                        if (!entity2.func_110124_au().equals(this.ownerUniqueId) || !(entity2 instanceof EntityMaelstromMob)) continue;
                        this.owner = (EntityMaelstromMob)entity2;
                        break;
                    }
                    this.ownerUniqueId = null;
                }
                if (this.target == null || !this.target.func_70089_S() || this.target instanceof EntityPlayer && ((EntityPlayer)this.target).func_175149_v()) {
                    this.target = ModUtils.closestEntityExcluding(this, this.func_174813_aQ().func_186662_g(10.0), entity -> EntityMaelstromMob.isMaelstromMob((Entity)entity) && entity != this.owner);
                    if (!this.func_189652_ae()) {
                        this.field_70181_x -= 0.04;
                        this.field_70159_w = 0.0;
                        this.field_70179_y = 0.0;
                    }
                } else {
                    direction = this.tempTarget.func_178788_d(this.func_174791_d()).func_72432_b();
                    this.field_70159_w = direction.field_72450_a * 0.3;
                    this.field_70181_x = direction.field_72448_b * 0.7;
                    this.field_70179_y = direction.field_72449_c * 0.3;
                }
                if ((raytraceresult = ProjectileHelper.func_188802_a((Entity)this, (boolean)true, (boolean)false, (Entity)this.owner)) != null && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                    this.bulletHit(raytraceresult);
                }
            }
            this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            ProjectileHelper.func_188803_a((Entity)this, (float)0.5f);
            if (this.field_70170_p.field_72995_K) {
                ParticleManager.spawnEffect(this.field_70170_p, this.func_174791_d(), ModColors.PURPLE);
            } else if (this.target != null && !this.target.field_70128_L) {
                direction = this.tempTarget.func_178788_d(this.func_174791_d()).func_72432_b();
                Vec3d lookahead = this.func_174791_d().func_178787_e(direction.func_186678_a(2.0));
                RayTraceResult res = this.field_70170_p.func_147447_a(this.func_174791_d(), lookahead, false, true, true);
                double distanceFromTarget = this.func_174791_d().func_72436_e(this.tempTarget);
                if (res != null && res.field_72313_a == RayTraceResult.Type.BLOCK || distanceFromTarget < 1.0) {
                    this.findNextTargetPosition();
                }
            }
        }
    }

    public void findNextTargetPosition() {
        double zMag;
        Vec3d targetPos = this.target.func_174791_d().func_178787_e(new Vec3d(this.target.field_70159_w, this.target.field_70181_x, this.target.field_70179_y).func_186678_a(3.0));
        Vec3d diff = targetPos.func_178788_d(this.func_174791_d());
        double xMag = Math.abs(diff.field_72450_a);
        if (xMag + (zMag = Math.abs(diff.field_72449_c)) > 0.8) {
            targetPos = this.field_70146_Z.nextDouble() * xMag > this.field_70146_Z.nextDouble() * zMag ? new Vec3d(targetPos.field_72450_a, this.field_70163_u, this.field_70161_v) : new Vec3d(this.field_70165_t, this.field_70163_u, targetPos.field_72449_c);
        }
        this.tempTarget = targetPos;
    }

    public boolean func_70027_ad() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 16384.0;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    protected void bulletHit(RayTraceResult result) {
        EntityLivingBase entity = ModUtils.getLivingEntity(result.field_72308_g);
        if (EntityMaelstromMob.isMaelstromMob((Entity)entity) && entity != null && this.owner != null) {
            this.field_70170_p.func_72960_a((Entity)this, ModUtils.PARTICLE_BYTE);
            this.func_184185_a(SoundEvents.field_193784_dd, 1.0f, 1.0f);
            entity.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 100));
            entity.func_70691_i((float)(this.owner.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 4.0));
        } else if (result.field_72308_g != null && this.owner != null) {
            result.field_72308_g.func_70097_a(ModDamageSource.causeElementalThrownDamage(this, (Entity)this.owner, this.owner.getElement()), this.owner.getAttack());
        }
        this.func_70106_y();
    }

    public void func_70103_a(byte id) {
        if (id == ModUtils.PARTICLE_BYTE) {
            for (int i = -5; i < 2; ++i) {
                float yOff = (float)i * 0.5f;
                ModUtils.circleCallback(1.0f, 20, pos -> {
                    pos = new Vec3d(pos.field_72450_a, (double)yOff, pos.field_72448_b);
                    ParticleManager.spawnDust(this.field_70170_p, pos.func_178787_e(this.func_174791_d()), ModColors.PURPLE, ModUtils.yVec(0.1f), ModRandom.range(10, 20));
                });
            }
        }
        super.func_70103_a(id);
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.CRIT, this.field_70165_t, this.field_70163_u, this.field_70161_v, 15, 0.2, 0.2, 0.2, 0.0, new int[0]);
            this.func_70106_y();
        }
        return true;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }
}

