/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities.gauntlet;

import com.barribob.MaelstromMod.entity.entities.EntityLeveledMob;
import com.barribob.MaelstromMod.entity.entities.gauntlet.IGauntletAction;
import com.barribob.MaelstromMod.init.ModBBAnimations;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModUtils;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class PunchAction
implements IGauntletAction {
    private final String animation;
    private final Supplier<Vec3d> targetSupplier;
    private final Runnable whilePunching;
    private final EntityLeveledMob entity;
    private final Entity fistHitbox;
    private boolean isPunching;
    public static final int punchStopTime = 50;

    public PunchAction(String animation, Supplier<Vec3d> targetSupplier, Runnable whilePunching, EntityLeveledMob entity, Entity fistHitbox) {
        this.animation = animation;
        this.targetSupplier = targetSupplier;
        this.whilePunching = whilePunching;
        this.entity = entity;
        this.fistHitbox = fistHitbox;
    }

    @Override
    public void doAction() {
        ModBBAnimations.animation((EntityLivingBase)this.entity, this.animation, false);
        this.entity.func_70024_g(0.0, 0.5, 0.0);
        this.entity.addEvent(() -> {
            Vec3d target = this.targetSupplier.get();
            if (target == null) {
                return;
            }
            this.isPunching = true;
            this.fistHitbox.field_70130_N = 2.5f;
            this.fistHitbox.field_70131_O = 4.5f;
            this.entity.field_70131_O = 2.0f;
            for (int i = 0; i < 10; ++i) {
                this.entity.addEvent(() -> {
                    Vec3d dir = ModUtils.direction(this.entity.func_174824_e(1.0f), target);
                    Vec3d velocityCorrection = ModUtils.planeProject(ModUtils.getEntityVelocity((Entity)this.entity), dir);
                    ModUtils.addEntityVelocity((Entity)this.entity, dir.func_178788_d(velocityCorrection).func_186678_a(0.32));
                }, i);
            }
        }, 16);
        this.entity.addEvent(() -> {
            this.isPunching = false;
        }, 40);
        this.entity.addEvent(() -> {
            this.fistHitbox.field_70130_N = 0.0f;
            this.fistHitbox.field_70131_O = 0.0f;
            this.entity.field_70131_O = 4.0f;
        }, 50);
    }

    @Override
    public void update() {
        if (this.isPunching) {
            double vel = ModUtils.getEntityVelocity((Entity)this.entity).func_72433_c();
            AxisAlignedBB box = this.entity.func_174813_aQ().func_72314_b(0.3, 0.3, 0.3);
            ModUtils.destroyBlocksInAABB(box, this.entity.field_70170_p, (Entity)this.entity);
            float punchDamage = this.entity.getAttack() * (float)vel * this.entity.getConfigFloat("punch_damage");
            DamageSource source = ModDamageSource.builder().type("mm:mobMaelstrom").directEntity((Entity)this.entity).stoppedByArmorNotShields().element(this.entity.getElement()).build();
            ModUtils.handleAreaImpact(1.3f, e -> Float.valueOf(punchDamage), (Entity)this.entity, this.entity.func_174824_e(1.0f), source, (float)vel, 0, false);
            this.whilePunching.run();
        }
    }

    @Override
    public boolean shouldExplodeUponImpact() {
        return this.isPunching;
    }

    @Override
    public boolean isImmuneToDamage() {
        return this.isPunching;
    }

    @Override
    public int attackLength() {
        return 53;
    }
}

