/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities.gauntlet;

import com.barribob.MaelstromMod.Main;
import com.barribob.MaelstromMod.entity.entities.EntityLeveledMob;
import com.barribob.MaelstromMod.entity.entities.gauntlet.IGauntletAction;
import com.barribob.MaelstromMod.init.ModBBAnimations;
import com.barribob.MaelstromMod.packets.MessageDirectionForRender;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.SoundsHandler;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class LaserAction
implements IGauntletAction {
    private final EntityLeveledMob entity;
    private boolean isShootingLazer;
    double maxLaserDistance;
    private final float laserExplosionSize;
    int beamLag;
    private final byte stopLaserByte;
    private final Consumer<Vec3d> onLaserImpact;

    public LaserAction(EntityLeveledMob entity, byte stopLaserByte, Consumer<Vec3d> onLaserImpact) {
        this.entity = entity;
        this.maxLaserDistance = entity.getMobConfig().getDouble("max_laser_distance");
        this.beamLag = entity.getMobConfig().getInt("beam_lag");
        this.laserExplosionSize = entity.getMobConfig().getInt("laser_explosion_size");
        this.stopLaserByte = stopLaserByte;
        this.onLaserImpact = onLaserImpact;
    }

    @Override
    public void doAction() {
        ModBBAnimations.animation((EntityLivingBase)this.entity, "gauntlet.lazer_eye", false);
        this.entity.func_184185_a(SoundsHandler.ENTITY_GAUNTLET_LAZER_CHARGE, 2.0f, ModRandom.getFloat(0.2f) + 1.5f);
        int chargeUpTime = 25;
        int laserEndTime = 60;
        for (int i = 0; i < chargeUpTime; ++i) {
            this.entity.addEvent(() -> this.entity.field_70170_p.func_72960_a((Entity)this.entity, ModUtils.PARTICLE_BYTE), i);
        }
        this.entity.addEvent(() -> {
            this.isShootingLazer = true;
        }, chargeUpTime);
        this.entity.addEvent(() -> {
            this.isShootingLazer = false;
            this.entity.addEvent(() -> this.entity.field_70170_p.func_72960_a((Entity)this.entity, this.stopLaserByte), this.beamLag + 1);
        }, laserEndTime);
    }

    @Override
    public void update() {
        if (this.isShootingLazer) {
            if (this.entity.func_70638_az() != null) {
                Vec3d laserShootPos = this.entity.func_70638_az().func_174791_d();
                this.entity.addEvent(() -> {
                    Vec3d laserDirection = laserShootPos.func_178788_d(this.entity.func_174824_e(1.0f)).func_72432_b();
                    Vec3d lazerPos = laserShootPos.func_178787_e(laserDirection.func_186678_a(this.maxLaserDistance));
                    RayTraceResult raytraceresult = this.entity.field_70170_p.func_147447_a(this.entity.func_174824_e(1.0f), lazerPos, false, true, false);
                    if (raytraceresult != null) {
                        lazerPos = this.onLaserImpact(raytraceresult);
                    }
                    for (Entity target : ModUtils.findEntitiesInLine(this.entity.func_174824_e(1.0f), lazerPos, this.entity.field_70170_p, (Entity)this.entity)) {
                        DamageSource source = ModDamageSource.builder().directEntity((Entity)this.entity).stoppedByArmorNotShields().element(this.entity.getElement()).type("mm:magicMaelstrom").build();
                        target.func_70097_a(source, this.entity.getAttack() * this.entity.getConfigFloat("laser_damage"));
                    }
                    ModUtils.addEntityVelocity((Entity)this.entity, laserDirection.func_186678_a((double)-0.03f));
                    Main.network.sendToAllTracking((IMessage)new MessageDirectionForRender((Entity)this.entity, lazerPos), (Entity)this.entity);
                }, this.beamLag);
            } else {
                this.isShootingLazer = false;
                this.entity.addEvent(() -> this.entity.field_70170_p.func_72960_a((Entity)this.entity, this.stopLaserByte), this.beamLag + 1);
            }
        }
    }

    private Vec3d onLaserImpact(RayTraceResult raytraceresult) {
        Vec3d hitPos = raytraceresult.field_72307_f;
        if (this.laserExplosionSize > 0.0f) {
            this.entity.field_70170_p.func_72876_a((Entity)this.entity, hitPos.field_72450_a, hitPos.field_72448_b, hitPos.field_72449_c, this.laserExplosionSize, ModUtils.mobGriefing(this.entity.field_70170_p, (Entity)this.entity));
        }
        this.onLaserImpact.accept(hitPos);
        if (this.entity.field_70173_aa % 2 == 0) {
            ModUtils.destroyBlocksInAABB(ModUtils.vecBox(hitPos, hitPos).func_186662_g(0.1), this.entity.field_70170_p, (Entity)this.entity);
        }
        return hitPos;
    }

    @Override
    public int attackLength() {
        return 60;
    }
}

