/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities.gauntlet;

import com.barribob.MaelstromMod.entity.entities.gauntlet.IGauntletAction;
import com.barribob.MaelstromMod.entity.util.IAttackInitiator;
import java.util.function.Function;
import net.minecraft.entity.EntityLivingBase;

public class GauntletAttackInitiator
implements IAttackInitiator {
    private int attackTime;
    private final int startingCooldown;
    private int attackCooldown;
    private final Function<EntityLivingBase, IGauntletAction> attack;
    private final Function<EntityLivingBase, IGauntletAction> overrideAction;

    public GauntletAttackInitiator(int startingCooldown, Function<EntityLivingBase, IGauntletAction> attack, Function<EntityLivingBase, IGauntletAction> overrideAction) {
        this.attack = attack;
        this.overrideAction = overrideAction;
        this.startingCooldown = startingCooldown;
        this.attackTime = startingCooldown;
    }

    @Override
    public void update(EntityLivingBase target) {
        IGauntletAction action;
        --this.attackTime;
        if (this.attackTime <= 0) {
            IGauntletAction action2 = this.attack.apply(target);
            this.attackTime = action2.attackLength() + action2.attackCooldown();
            this.attackCooldown = action2.attackCooldown();
        } else if (this.attackTime <= this.attackCooldown && (action = this.overrideAction.apply(target)) != null) {
            this.attackTime = action.attackLength() + action.attackCooldown();
            this.attackCooldown = action.attackCooldown();
        }
    }

    @Override
    public void resetTask() {
        this.attackTime = Math.max(this.attackTime, this.startingCooldown);
        this.attackCooldown = 0;
    }
}

