/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities.gauntlet;

import com.barribob.MaelstromMod.entity.entities.EntityLeveledMob;
import com.barribob.MaelstromMod.entity.entities.gauntlet.IGauntletAction;
import com.barribob.MaelstromMod.entity.projectile.Projectile;
import com.barribob.MaelstromMod.entity.util.IPitch;
import com.barribob.MaelstromMod.init.ModBBAnimations;
import com.barribob.MaelstromMod.util.ModUtils;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.Vec3d;

public class FireballThrowAction<T extends EntityLeveledMob>
implements IGauntletAction {
    private final Function<EntityLivingBase, Vec3d> target;
    private final Supplier<Projectile> projectileSupplier;
    private final T entity;

    public FireballThrowAction(Function<EntityLivingBase, Vec3d> target, Supplier<Projectile> projectileSupplier, T entity) {
        this.target = target;
        this.projectileSupplier = projectileSupplier;
        this.entity = entity;
    }

    @Override
    public void doAction() {
        EntityLivingBase attackTarget = this.entity.func_70638_az();
        if (attackTarget == null) {
            return;
        }
        ModBBAnimations.animation(this.entity, "gauntlet.fireball", false);
        Projectile proj = this.projectileSupplier.get();
        ((EntityLeveledMob)this.entity).addEvent(() -> ((EntityLeveledMob)this.entity).field_70170_p.func_72838_d((Entity)proj), 10);
        for (int i = 10; i < 27; ++i) {
            ((EntityLeveledMob)this.entity).addEvent(() -> {
                Vec3d fireballPos = this.entity.func_174824_e(1.0f).func_178787_e(ModUtils.getAxisOffset(ModUtils.getLookVec(((IPitch)this.entity).getPitch(), ((EntityLeveledMob)this.entity).field_70761_aq), new Vec3d(1.0, 0.0, 0.0)));
                ModUtils.setEntityPosition(proj, fireballPos);
            }, i);
        }
        ((EntityLeveledMob)this.entity).addEvent(() -> {
            Vec3d vel = this.target.apply(attackTarget).func_178788_d(ModUtils.yVec(1.0)).func_178788_d(proj.func_174791_d());
            proj.func_70186_c(vel.field_72450_a, vel.field_72448_b, vel.field_72449_c, 0.8f, 0.3f);
            ModUtils.addEntityVelocity(this.entity, vel.func_72432_b().func_186678_a(-0.8));
        }, 27);
    }

    @Override
    public int attackLength() {
        return 52;
    }
}

