/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities;

import com.barribob.MaelstromMod.entity.action.IAction;
import com.barribob.MaelstromMod.entity.ai.EntityAIRangedAttack;
import com.barribob.MaelstromMod.entity.ai.EntityAIRangedAttackNoReset;
import com.barribob.MaelstromMod.entity.animation.AnimationClip;
import com.barribob.MaelstromMod.entity.animation.AnimationOscillateArms;
import com.barribob.MaelstromMod.entity.animation.StreamAnimation;
import com.barribob.MaelstromMod.entity.entities.EntityLeveledMob;
import com.barribob.MaelstromMod.entity.entities.EntityMaelstromMob;
import com.barribob.MaelstromMod.entity.model.ModelMaelstromIllager;
import com.barribob.MaelstromMod.entity.projectile.Projectile;
import com.barribob.MaelstromMod.entity.projectile.ProjectileHorrorAttack;
import com.barribob.MaelstromMod.entity.projectile.ProjectileMaelstromWisp;
import com.barribob.MaelstromMod.entity.util.ComboAttack;
import com.barribob.MaelstromMod.util.ModColors;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.LootTableHandler;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import com.barribob.MaelstromMod.util.handlers.SoundsHandler;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;

public class EntityMaelstromIllager
extends EntityMaelstromMob {
    private final byte summonMob = (byte)4;
    private final byte magicMissile = (byte)5;
    private final byte wisp = (byte)6;
    private final byte shield = (byte)7;
    private final byte enemy = (byte)8;
    private final float shieldSize = 4.0f;
    private EntityAIRangedAttack<EntityMaelstromMob> phase1AttackAI;
    private final ComboAttack attackHandler = new ComboAttack();
    private final IAction spawnEnemy = new IAction(){

        @Override
        public void performAction(EntityLeveledMob actor, EntityLivingBase target) {
            int mobCount = EntityMaelstromIllager.this.phase2() ? EntityMaelstromIllager.this.getMobConfig().getInt("summoning_algorithm.second_phase_mobs_per_spawn") : EntityMaelstromIllager.this.getMobConfig().getInt("summoning_algorithm.first_phase_mobs_per_spawn");
            for (int i = 0; i < mobCount; ++i) {
                ModUtils.spawnMob(EntityMaelstromIllager.this.field_70170_p, EntityMaelstromIllager.this.func_180425_c(), EntityMaelstromIllager.this.getLevel(), EntityMaelstromIllager.this.getMobConfig().getConfig("summoning_algorithm"));
            }
            actor.func_184185_a(SoundEvents.field_193784_dd, 1.0f, 0.4f / (EntityMaelstromIllager.this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
        }
    };
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.NOTCHED_20);

    public EntityMaelstromIllager(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 2.5f);
        this.healthScaledAttackFactor = 0.2;
        if (!this.field_70170_p.field_72995_K) {
            this.attackHandler.setAttack((byte)5, (actor, target) -> {
                ModUtils.throwProjectile((EntityLivingBase)actor, target, (Projectile)new ProjectileHorrorAttack(this.field_70170_p, (EntityLivingBase)actor, this.getAttack() * this.getConfigFloat("maelstrom_missile_damage")), 6.0f, 1.2f, ModUtils.getRelativeOffset((EntityLivingBase)actor, new Vec3d(0.0, 0.0, 1.0)));
                actor.func_184185_a(SoundEvents.field_187606_E, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            });
            this.attackHandler.setAttack((byte)6, (actor, target) -> {
                ProjectileMaelstromWisp proj = new ProjectileMaelstromWisp(this.field_70170_p, (EntityLivingBase)actor, this.getAttack() * this.getConfigFloat("ring_damage"));
                proj.setTravelRange(15.0f);
                ModUtils.throwProjectile((EntityLivingBase)actor, target, (Projectile)proj, 1.0f, 1.0f);
                this.playSoundWithFallback(SoundsHandler.Hooks.ENTITY_ILLAGER_VORTEX, SoundEvents.field_187594_A);
            });
            this.attackHandler.setAttack((byte)7, (actor, target) -> {
                DamageSource damageSource = ModDamageSource.builder().directEntity((Entity)actor).type("mm:magicMaelstrom").element(this.getElement()).stoppedByArmorNotShields().build();
                ModUtils.handleAreaImpact(4.0f, e -> Float.valueOf(this.getAttack() * this.getConfigFloat("defensive_burst_damage")), (Entity)actor, this.func_174791_d(), damageSource);
                this.playSoundWithFallback(SoundsHandler.Hooks.ENTITY_ILLAGER_DOME, SoundEvents.field_187619_bk);
                actor.field_70170_p.func_72960_a((Entity)actor, ModUtils.THIRD_PARTICLE_BYTE);
            });
            this.attackHandler.setAttack((byte)8, this.spawnEnemy);
        }
    }

    @Override
    protected void initAnimation() {
        ArrayList animationMissile = new ArrayList();
        ArrayList<AnimationClip<ModelMaelstromIllager>> rightArm = new ArrayList<AnimationClip<ModelMaelstromIllager>>();
        ArrayList<AnimationClip<ModelMaelstromIllager>> leftArm = new ArrayList<AnimationClip<ModelMaelstromIllager>>();
        BiConsumer<ModelMaelstromIllager, Float> leftArmMover = (model, f) -> {
            model.bipedLeftArm.field_78795_f = f.floatValue();
            model.bipedLeftArm.field_78796_g = 0.0f;
            model.bipedLeftArm.field_78808_h = f.floatValue() / -6.0f;
        };
        BiConsumer<ModelMaelstromIllager, Float> rightArmMover = (model, f) -> {
            model.bipedRightArm.field_78795_f = 0.0f;
            model.bipedRightArm.field_78796_g = 0.0f;
            model.bipedRightArm.field_78808_h = 0.0f;
        };
        leftArm.add(new AnimationClip<ModelMaelstromIllager>(12, 0.0f, -180.0f, leftArmMover));
        leftArm.add(new AnimationClip<ModelMaelstromIllager>(8, -180.0f, -180.0f, leftArmMover));
        leftArm.add(new AnimationClip<ModelMaelstromIllager>(4, -180.0f, 0.0f, leftArmMover));
        rightArm.add(new AnimationClip<ModelMaelstromIllager>(12, 0.0f, -180.0f, rightArmMover));
        rightArm.add(new AnimationClip<ModelMaelstromIllager>(8, -180.0f, -180.0f, rightArmMover));
        rightArm.add(new AnimationClip<ModelMaelstromIllager>(4, -180.0f, 0.0f, rightArmMover));
        animationMissile.add(rightArm);
        animationMissile.add(leftArm);
        this.attackHandler.setAttack((byte)5, IAction.NONE, () -> new StreamAnimation(animationMissile));
        ArrayList<ArrayList<AnimationClip<ModelMaelstromIllager>>> animationWisp = new ArrayList<ArrayList<AnimationClip<ModelMaelstromIllager>>>();
        rightArm = new ArrayList();
        leftArm = new ArrayList();
        leftArmMover = (model, f) -> {
            model.bipedLeftArm.field_78795_f = (float)Math.toRadians(-90.0);
            model.bipedLeftArm.field_78796_g = f.floatValue();
            model.bipedLeftArm.field_78808_h = 0.0f;
        };
        rightArmMover = (model, f) -> {
            model.bipedRightArm.field_78795_f = (float)Math.toRadians(-90.0);
            model.bipedRightArm.field_78796_g = f.floatValue();
            model.bipedRightArm.field_78808_h = 0.0f;
        };
        leftArm.add(new AnimationClip<ModelMaelstromIllager>(10, 0.0f, -90.0f, leftArmMover));
        leftArm.add(new AnimationClip<ModelMaelstromIllager>(8, -90.0f, -90.0f, leftArmMover));
        leftArm.add(new AnimationClip<ModelMaelstromIllager>(4, -90.0f, 0.0f, leftArmMover));
        rightArm.add(new AnimationClip<ModelMaelstromIllager>(10, 0.0f, 90.0f, rightArmMover));
        rightArm.add(new AnimationClip<ModelMaelstromIllager>(8, 90.0f, 90.0f, rightArmMover));
        rightArm.add(new AnimationClip<ModelMaelstromIllager>(4, 90.0f, 0.0f, rightArmMover));
        animationWisp.add(rightArm);
        animationWisp.add(leftArm);
        this.attackHandler.setAttack((byte)6, IAction.NONE, () -> new StreamAnimation(animationWisp));
        ArrayList<ArrayList<AnimationClip<ModelMaelstromIllager>>> animationShield = new ArrayList<ArrayList<AnimationClip<ModelMaelstromIllager>>>();
        rightArm = new ArrayList();
        leftArm = new ArrayList();
        leftArmMover = (model, f) -> {
            model.bipedLeftArm.field_78795_f = f.floatValue();
            model.bipedLeftArm.field_78796_g = -f.floatValue() * 0.45f;
            model.bipedLeftArm.field_78808_h = 0.0f;
        };
        rightArmMover = (model, f) -> {
            model.bipedRightArm.field_78795_f = f.floatValue();
            model.bipedRightArm.field_78796_g = f.floatValue() * 0.45f;
            model.bipedRightArm.field_78808_h = 0.0f;
        };
        leftArm.add(new AnimationClip<ModelMaelstromIllager>(10, 0.0f, -120.0f, leftArmMover));
        leftArm.add(new AnimationClip<ModelMaelstromIllager>(8, -120.0f, -120.0f, leftArmMover));
        leftArm.add(new AnimationClip<ModelMaelstromIllager>(4, -120.0f, 0.0f, leftArmMover));
        rightArm.add(new AnimationClip<ModelMaelstromIllager>(10, 0.0f, -120.0f, rightArmMover));
        rightArm.add(new AnimationClip<ModelMaelstromIllager>(8, -120.0f, -120.0f, rightArmMover));
        rightArm.add(new AnimationClip<ModelMaelstromIllager>(4, -120.0f, 0.0f, rightArmMover));
        animationShield.add(rightArm);
        animationShield.add(leftArm);
        this.attackHandler.setAttack((byte)7, IAction.NONE, () -> new StreamAnimation(animationShield));
        this.attackHandler.setAttack((byte)8, IAction.NONE, () -> new AnimationOscillateArms(60, this));
        this.currentAnimation = new AnimationOscillateArms(60, this);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.phase1AttackAI = new EntityAIRangedAttackNoReset<EntityMaelstromIllager>(this, 1.25, 360, 60.0f, 15.0f, 0.5f);
        this.field_70714_bg.func_75776_a(4, this.phase1AttackAI);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191243_bm;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191245_bo;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_191246_bp;
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return LootTableHandler.MAELSTROM_ILLAGER;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.isSwingingArms()) {
            Entity entity;
            if (!source.func_76352_a() && (entity = source.func_76364_f()) instanceof EntityLivingBase) {
                this.func_190629_c((EntityLivingBase)entity);
            }
            this.func_184185_a(SoundsHandler.ENTITY_CHAOS_KNIGHT_BLOCK, 1.0f, 0.9f + ModRandom.getFloat(0.2f));
            return false;
        }
        float prevHealth = this.func_110143_aJ();
        double firstDialogHp = this.getMobConfig().getDouble("first_dialog_hp");
        double secondDialogHP = this.getMobConfig().getDouble("second_dialog_hp");
        double secondPhaseHp = this.getMobConfig().getDouble("second_boss_phase_hp");
        boolean flag = super.func_70097_a(source, amount);
        String message = "";
        if ((double)prevHealth > firstDialogHp && (double)this.func_110143_aJ() <= firstDialogHp) {
            message = "illager_1";
        }
        if ((double)prevHealth > secondDialogHP && (double)this.func_110143_aJ() <= secondDialogHP) {
            message = "illager_2";
        }
        if ((double)prevHealth > secondPhaseHp && (double)this.func_110143_aJ() <= secondPhaseHp) {
            message = "illager_3";
        }
        if (message != "") {
            for (EntityPlayer player : this.bossInfo.func_186757_c()) {
                player.func_145747_a(new TextComponentString(TextFormatting.DARK_PURPLE + "Maelstrom Illager: " + TextFormatting.WHITE).func_150257_a((ITextComponent)new TextComponentTranslation("mm.dialog." + message, new Object[0])));
            }
        }
        return flag;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        this.phase1AttackAI.setAttackCooldowns(this.phase2() ? 50 : 360, this.phase2() ? 20.0f : 60.0f);
        if (this.phase2() && this.attackHandler.getCurrentAttack() != 0) {
            this.attackHandler.getCurrentAttackAction().performAction(this, target);
        } else {
            this.spawnEnemy.performAction(this, target);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.phase2() || this.phase2() && this.attackHandler.getCurrentAttack() == 8) {
            this.field_70170_p.func_72960_a((Entity)this, ModUtils.PARTICLE_BYTE);
        } else if (this.attackHandler != null && this.isSwingingArms() && this.attackHandler.getCurrentAttack() == 5) {
            this.field_70170_p.func_72960_a((Entity)this, ModUtils.SECOND_PARTICLE_BYTE);
        }
    }

    @Override
    public void func_184724_a(boolean swingingArms) {
        super.func_184724_a(swingingArms);
        if (this.isSwingingArms()) {
            if (this.phase2()) {
                Byte[] attack = new Byte[]{(byte)6, (byte)5, (byte)8};
                double[] weights = new double[]{0.5, 0.5, 0.2};
                this.attackHandler.setCurrentAttack(ModRandom.choice(attack, this.func_70681_au(), weights).next());
                if (this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) < 4.0f) {
                    this.attackHandler.setCurrentAttack((byte)7);
                    this.playSoundWithFallback(SoundsHandler.Hooks.ENTITY_ILLAGER_DOME_CHARGE, SoundsHandler.NONE);
                } else {
                    this.playSoundWithFallback(SoundsHandler.Hooks.ENTITY_ILLAGER_SPELL_CHARGE, SoundsHandler.NONE);
                }
                this.field_70170_p.func_72960_a((Entity)this, this.attackHandler.getCurrentAttack());
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)4);
            }
        }
    }

    @Override
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.currentAnimation = new AnimationOscillateArms(60, this);
            this.currentAnimation.startAnimation();
        } else if (id >= 5 && id <= 8) {
            this.currentAnimation = this.attackHandler.getAnimation(id);
            this.getCurrentAnimation().startAnimation();
        } else if (id == ModUtils.THIRD_PARTICLE_BYTE) {
            for (int i = 0; i < 1000; ++i) {
                Vec3d unit = new Vec3d(0.0, 1.0, 0.0);
                unit = unit.func_178789_a((float)(Math.PI * (double)ModRandom.getFloat(1.0f)));
                unit = unit.func_178785_b((float)(Math.PI * (double)ModRandom.getFloat(1.0f)));
                unit = unit.func_72432_b().func_186678_a(4.0);
                ParticleManager.spawnEffect(this.field_70170_p, unit.func_178787_e(this.func_174791_d()), ModColors.PURPLE);
            }
        } else if (id == ModUtils.SECOND_PARTICLE_BYTE) {
            ParticleManager.spawnMaelstromPotionParticle(this.field_70170_p, this.field_70146_Z, ModUtils.getRelativeOffset((EntityLivingBase)this, new Vec3d(0.0, (double)this.func_70047_e(), 1.0)).func_178787_e(this.func_174791_d()), true);
        } else if (id == ModUtils.PARTICLE_BYTE && this.isSwingingArms()) {
            float f = this.field_70761_aq * ((float)Math.PI / 180) + MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.6662f)) * 0.25f;
            float f1 = MathHelper.func_76134_b((float)f);
            float f2 = MathHelper.func_76126_a((float)f);
            ParticleManager.spawnMaelstromPotionParticle(this.field_70170_p, this.field_70146_Z, new Vec3d(this.field_70165_t + (double)f1 * 0.6, this.field_70163_u + 1.8, this.field_70161_v + (double)f2 * 0.6), true);
            ParticleManager.spawnMaelstromPotionParticle(this.field_70170_p, this.field_70146_Z, new Vec3d(this.field_70165_t - (double)f1 * 0.6, this.field_70163_u + 1.8, this.field_70161_v - (double)f2 * 0.6), true);
        }
        super.func_70103_a(id);
    }

    private boolean phase2() {
        return this.func_110143_aJ() < (float)this.getMobConfig().getInt("second_boss_phase_hp");
    }

    public void func_70037_a(NBTTagCompound compound) {
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
        super.func_70037_a(compound);
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    protected void func_70619_bc() {
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        super.func_70619_bc();
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }
}

