/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities;

import com.barribob.MaelstromMod.entity.ai.AIFlyingSupport;
import com.barribob.MaelstromMod.entity.ai.FlyingMoveHelper;
import com.barribob.MaelstromMod.entity.entities.EntityMaelstromMob;
import com.barribob.MaelstromMod.entity.projectile.EntityHealerOrb;
import com.barribob.MaelstromMod.entity.util.IAcceleration;
import com.barribob.MaelstromMod.init.ModBBAnimations;
import com.barribob.MaelstromMod.util.Element;
import com.barribob.MaelstromMod.util.ModColors;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import com.barribob.MaelstromMod.util.handlers.SoundsHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMaelstromHealer
extends EntityMaelstromMob
implements IAcceleration {
    Vec3d acceleration = Vec3d.field_186680_a;
    protected static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntityMaelstromHealer.class, (DataSerializer)DataSerializers.field_187198_h);
    private final EntityAIBase flyingAI = new AIFlyingSupport(this, 1.2f, 3.5, 10.0, 60.0);
    private float timeSinceNoTarget = 0.0f;

    public EntityMaelstromHealer(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 2.0f);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        Vec3d motion = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.acceleration = motion.func_186678_a(0.1).func_178787_e(this.acceleration.func_186678_a(0.9));
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isFlying() && (!this.field_70122_E && ModUtils.isAirBelow(this.field_70170_p, this.func_180425_c(), 4) || this.func_70638_az() != null)) {
            this.setFlying(true);
            this.field_70714_bg.func_75776_a(4, this.flyingAI);
            this.field_70765_h = new FlyingMoveHelper((EntityLiving)this);
            this.field_70699_by = new PathNavigateFlying((EntityLiving)this, this.field_70170_p);
            ModBBAnimations.animation((EntityLivingBase)this, "healer.fly", false);
        }
        if (this.isFlying() && !ModUtils.isAirBelow(this.field_70170_p, this.func_180425_c(), 4) && this.timeSinceNoTarget > 200.0f) {
            this.setFlying(false);
            this.field_70714_bg.func_85156_a(this.flyingAI);
            this.field_70765_h = new EntityMoveHelper((EntityLiving)this);
            this.field_70699_by = new PathNavigateGround((EntityLiving)this, this.field_70170_p);
            ModBBAnimations.animation((EntityLivingBase)this, "healer.fly", true);
            ModBBAnimations.animation((EntityLivingBase)this, "healer.fold_wing", false);
        }
        if (this.func_70638_az() == null) {
            this.timeSinceNoTarget += 1.0f;
        }
        if (this.field_70146_Z.nextInt(20) == 0) {
            this.field_70170_p.func_72960_a((Entity)this, ModUtils.PARTICLE_BYTE);
        }
    }

    public void func_70624_b(EntityLivingBase entity) {
        super.func_70624_b(entity);
        if (entity != null) {
            this.timeSinceNoTarget = 0.0f;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == ModUtils.PARTICLE_BYTE) {
            if (this.getElement().equals((Object)Element.NONE)) {
                ParticleManager.spawnMaelstromPotionParticle(this.field_70170_p, this.field_70146_Z, this.func_174791_d().func_178787_e(ModRandom.randVec()).func_178787_e(ModUtils.yVec(1.0)), false);
            }
            ParticleManager.spawnEffect(this.field_70170_p, this.func_174791_d().func_178787_e(ModRandom.randVec()).func_178787_e(ModUtils.yVec(1.0)), this.getElement().particleColor);
        } else if (id == ModUtils.SECOND_PARTICLE_BYTE) {
            ParticleManager.spawnSwirl2(this.field_70170_p, this.func_174791_d(), ModColors.PURPLE, Vec3d.field_186680_a);
        }
        super.func_70103_a(id);
    }

    @Override
    public Vec3d getAcceleration() {
        return this.isFlying() ? this.acceleration : Vec3d.field_186680_a;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.isFlying()) {
            if (this.func_70090_H()) {
                this.func_191958_b(strafe, vertical, forward, 0.02f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)0.8f;
                this.field_70181_x *= (double)0.8f;
                this.field_70179_y *= (double)0.8f;
            } else if (this.func_180799_ab()) {
                this.func_191958_b(strafe, vertical, forward, 0.02f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= 0.5;
                this.field_70181_x *= 0.5;
                this.field_70179_y *= 0.5;
            } else {
                float f = 0.91f;
                if (this.field_70122_E) {
                    BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                    IBlockState underState = this.field_70170_p.func_180495_p(underPos);
                    f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.91f;
                }
                float f1 = 0.16277136f / (f * f * f);
                this.func_191958_b(strafe, vertical, forward, this.field_70122_E ? 0.1f * f1 : 0.02f);
                f = 0.91f;
                if (this.field_70122_E) {
                    BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                    IBlockState underState = this.field_70170_p.func_180495_p(underPos);
                    f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.91f;
                }
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)f;
                this.field_70181_x *= (double)f;
                this.field_70179_y *= (double)f;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    public boolean isFlying() {
        return this.field_70180_af != null && (Boolean)this.field_70180_af.func_187225_a(FLYING) != false;
    }

    protected void setFlying(boolean immovable) {
        this.field_70180_af.func_187227_b(FLYING, (Object)immovable);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        ModBBAnimations.animation((EntityLivingBase)this, "healer.summon_orb", false);
        this.addEvent(() -> {
            EntityHealerOrb orb = new EntityHealerOrb(this.field_70170_p, this, (Entity)target);
            this.field_70170_p.func_72838_d((Entity)orb);
            this.field_70170_p.func_72960_a((Entity)this, ModUtils.SECOND_PARTICLE_BYTE);
        }, 10);
    }

    protected SoundEvent func_184639_G() {
        return SoundsHandler.ENTITY_SHADE_AMBIENT;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundsHandler.ENTITY_SHADE_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundsHandler.ENTITY_SHADE_DEATH;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_70617_f_() {
        return false;
    }
}

