/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities;

import com.barribob.MaelstromMod.entity.action.ActionSpinSlash;
import com.barribob.MaelstromMod.entity.action.IAction;
import com.barribob.MaelstromMod.entity.ai.AIJumpAtTarget;
import com.barribob.MaelstromMod.entity.ai.EntityAIRangedAttack;
import com.barribob.MaelstromMod.entity.animation.AnimationClip;
import com.barribob.MaelstromMod.entity.animation.StreamAnimation;
import com.barribob.MaelstromMod.entity.entities.EntityMaelstromMob;
import com.barribob.MaelstromMod.entity.model.ModelIronShade;
import com.barribob.MaelstromMod.entity.util.ComboAttack;
import com.barribob.MaelstromMod.util.Element;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.LootTableHandler;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import com.barribob.MaelstromMod.util.handlers.SoundsHandler;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;

public class EntityIronShade
extends EntityMaelstromMob {
    private final ComboAttack attackHandler = new ComboAttack();
    private final byte frontFlip = (byte)4;
    private final byte spin = (byte)5;
    private int spinDuration = 30;
    private final int maxSpinDuration = 30;
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.NOTCHED_6);

    public EntityIronShade(World worldIn) {
        super(worldIn);
        this.healthScaledAttackFactor = 0.2;
        this.func_70105_a(0.9f, 2.2f);
        if (!worldIn.field_72995_K) {
            this.attackHandler.setAttack((byte)4, (actor, target) -> {
                DamageSource source = ModDamageSource.builder().directEntity((Entity)this).element(this.getElement()).type("mm:mobMaelstrom").disablesShields().build();
                Vec3d pos = this.func_174791_d().func_178787_e(ModUtils.yVec(1.0)).func_178787_e(this.func_70040_Z().func_186678_a(2.0));
                this.func_184185_a(SoundEvents.field_187730_dW, 1.0f, 0.8f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                ModUtils.handleAreaImpact(1.0f, e -> Float.valueOf(this.getAttack() * this.getConfigFloat("flip_damage")), (Entity)this, pos, source, 0.2f, this.getElement() == Element.CRIMSON ? 3 : 0, false);
                actor.field_70170_p.func_72960_a((Entity)actor, ModUtils.SECOND_PARTICLE_BYTE);
            });
            this.attackHandler.setAttack((byte)5, new ActionSpinSlash(3.0f));
        }
    }

    @Override
    public void func_70071_h_() {
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (!this.field_70170_p.field_72995_K && this.spinDuration < 30 && this.attackHandler.getCurrentAttack() == 5) {
            ++this.spinDuration;
            if (this.field_70173_aa % 5 == 0) {
                this.attackHandler.getCurrentAttackAction().performAction(this, null);
            }
        } else if (!this.field_70170_p.field_72995_K && !this.isSwingingArms()) {
            this.field_70170_p.func_72960_a((Entity)this, ModUtils.PARTICLE_BYTE);
        }
        super.func_70071_h_();
    }

    @Override
    protected void initAnimation() {
        ArrayList flipAnimations = new ArrayList();
        ArrayList<AnimationClip<ModelIronShade>> wisps = new ArrayList<AnimationClip<ModelIronShade>>();
        ArrayList<AnimationClip<ModelIronShade>> arms = new ArrayList<AnimationClip<ModelIronShade>>();
        ArrayList<AnimationClip<ModelIronShade>> body = new ArrayList<AnimationClip<ModelIronShade>>();
        ArrayList<AnimationClip<ModelIronShade>> lowerChains = new ArrayList<AnimationClip<ModelIronShade>>();
        ArrayList<AnimationClip<ModelIronShade>> upperChains = new ArrayList<AnimationClip<ModelIronShade>>();
        BiConsumer<ModelIronShade, Float> bodyFlipper = (model, f) -> {
            model.wisps.field_78795_f = f.floatValue();
            model.wisps.field_78796_g = 0.0f;
        };
        BiConsumer<ModelIronShade, Float> bodyBender = (model, f) -> {
            model.body.field_78795_f = f.floatValue();
        };
        BiConsumer<ModelIronShade, Float> armMover = (model, f) -> {
            model.rightArm.field_78795_f = f.floatValue();
            model.leftArm.field_78795_f = f.floatValue();
        };
        BiConsumer<ModelIronShade, Float> lowerChainMover = (model, f) -> {
            model.chainLink1.field_78795_f = f.floatValue() / 8.0f;
            model.chainLink2.field_78795_f = f.floatValue() / 4.0f;
            model.chainLink3.field_78795_f = f.floatValue() / 2.0f;
            model.chainLink4.field_78795_f = f.floatValue();
            model.chainLink1_1.field_78795_f = f.floatValue() / 8.0f;
            model.chainLink2_1.field_78795_f = f.floatValue() / 4.0f;
            model.chainLink3_1.field_78795_f = f.floatValue() / 2.0f;
            model.chainLink4_1.field_78795_f = f.floatValue();
        };
        BiConsumer<ModelIronShade, Float> ballAndChainMover = (model, f) -> {
            model.chainLink5.field_78795_f = f.floatValue();
            model.chainLink6.field_78795_f = f.floatValue();
            model.ball.field_78795_f = f.floatValue();
            model.chainLink5_1.field_78795_f = f.floatValue();
            model.chainLink6_1.field_78795_f = f.floatValue();
            model.ball_1.field_78795_f = f.floatValue();
        };
        int flipLength = 10;
        int swingDownLength = 4;
        int stopLength = 8;
        int resetLength = 8;
        wisps.add(new AnimationClip<ModelIronShade>(flipLength, 0.0f, 360.0f, bodyFlipper));
        wisps.add(new AnimationClip<ModelIronShade>(swingDownLength + stopLength + resetLength, 360.0f, 360.0f, bodyFlipper));
        body.add(new AnimationClip<ModelIronShade>(flipLength, 0.0f, 0.0f, bodyBender));
        body.add(new AnimationClip<ModelIronShade>(swingDownLength, 0.0f, 50.0f, bodyBender));
        body.add(new AnimationClip<ModelIronShade>(stopLength, 50.0f, 50.0f, bodyBender));
        body.add(new AnimationClip<ModelIronShade>(resetLength, 50.0f, 0.0f, bodyBender));
        arms.add(new AnimationClip<ModelIronShade>(flipLength - 4, 0.0f, -210.0f, armMover));
        arms.add(new AnimationClip<ModelIronShade>(4, -210.0f, -210.0f, armMover));
        arms.add(new AnimationClip<ModelIronShade>(swingDownLength, -210.0f, -90.0f, armMover));
        arms.add(new AnimationClip<ModelIronShade>(stopLength, -90.0f, -90.0f, armMover));
        arms.add(new AnimationClip<ModelIronShade>(resetLength, -90.0f, 0.0f, armMover));
        lowerChains.add(new AnimationClip<ModelIronShade>(flipLength, 48.0f, -16.0f, lowerChainMover));
        lowerChains.add(new AnimationClip<ModelIronShade>(swingDownLength + stopLength, -16.0f, -16.0f, lowerChainMover));
        lowerChains.add(new AnimationClip<ModelIronShade>(resetLength, -16.0f, 48.0f, lowerChainMover));
        upperChains.add(new AnimationClip<ModelIronShade>(flipLength, 0.0f, -32.0f, ballAndChainMover));
        upperChains.add(new AnimationClip<ModelIronShade>(swingDownLength, -32.0f, -32.0f, ballAndChainMover));
        upperChains.add(new AnimationClip<ModelIronShade>(stopLength - 6, -32.0f, -10.0f, ballAndChainMover));
        upperChains.add(new AnimationClip<ModelIronShade>(6, -10.0f, -10.0f, ballAndChainMover));
        upperChains.add(new AnimationClip<ModelIronShade>(resetLength, -10.0f, 0.0f, ballAndChainMover));
        flipAnimations.add(wisps);
        flipAnimations.add(arms);
        flipAnimations.add(body);
        flipAnimations.add(lowerChains);
        flipAnimations.add(upperChains);
        this.attackHandler.setAttack((byte)4, IAction.NONE, () -> new StreamAnimation(flipAnimations));
        ArrayList<ArrayList<AnimationClip<ModelIronShade>>> spinAnimations = new ArrayList<ArrayList<AnimationClip<ModelIronShade>>>();
        wisps = new ArrayList();
        arms = new ArrayList();
        body = new ArrayList();
        lowerChains = new ArrayList();
        upperChains = new ArrayList();
        BiConsumer<ModelIronShade, Float> bodySpinner = (model, f) -> {
            model.wisps.field_78795_f = 0.0f;
            model.wisps.field_78796_g = f.floatValue();
        };
        int chargeLength = 5;
        int speedUpLength = 5;
        int speedUpFasterLength = 5;
        wisps.add(new AnimationClip<ModelIronShade>(chargeLength, 0.0f, -60.0f, bodySpinner));
        wisps.add(new AnimationClip<ModelIronShade>(speedUpLength, 0.0f, 180.0f, bodySpinner));
        wisps.add(new AnimationClip<ModelIronShade>(speedUpFasterLength, 180.0f, 540.0f, bodySpinner));
        wisps.add(new AnimationClip<ModelIronShade>(30, 540.0f, 3240.0f, bodySpinner));
        wisps.add(new AnimationClip<ModelIronShade>(speedUpFasterLength, 3240.0f, 3780.0f, bodySpinner));
        wisps.add(new AnimationClip<ModelIronShade>(10, 3780.0f, 4140.0f, bodySpinner));
        body.add(new AnimationClip<ModelIronShade>(15, 0.0f, -20.0f, bodyBender));
        body.add(new AnimationClip<ModelIronShade>(30, -20.0f, -20.0f, bodyBender));
        body.add(new AnimationClip<ModelIronShade>(15, -20.0f, 0.0f, bodyBender));
        arms.add(new AnimationClip<ModelIronShade>(15, 0.0f, -70.0f, armMover));
        arms.add(new AnimationClip<ModelIronShade>(30, -70.0f, -70.0f, armMover));
        arms.add(new AnimationClip<ModelIronShade>(15, -70.0f, 0.0f, armMover));
        lowerChains.add(new AnimationClip<ModelIronShade>(15, -48.0f, 0.0f, lowerChainMover));
        lowerChains.add(new AnimationClip<ModelIronShade>(30, 0.0f, 0.0f, lowerChainMover));
        lowerChains.add(new AnimationClip<ModelIronShade>(15, 0.0f, -48.0f, lowerChainMover));
        upperChains.add(new AnimationClip<ModelIronShade>(60, 0.0f, 0.0f, ballAndChainMover));
        spinAnimations.add(wisps);
        spinAnimations.add(arms);
        spinAnimations.add(body);
        spinAnimations.add(lowerChains);
        spinAnimations.add(upperChains);
        this.attackHandler.setAttack((byte)5, new ActionSpinSlash(3.0f), () -> new StreamAnimation(spinAnimations));
        this.currentAnimation = new StreamAnimation(flipAnimations);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, new EntityAIRangedAttack<EntityIronShade>(this, 1.3f, 60, 10.0f, 4.5f, 0.4f));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIJumpAtTarget((EntityLiving)this, 0.4f, 0.5f));
    }

    @Override
    public void func_184724_a(boolean swingingArms) {
        super.func_184724_a(swingingArms);
        if (swingingArms) {
            Byte[] attack = new Byte[]{(byte)5, (byte)4};
            this.attackHandler.setCurrentAttack(ModRandom.choice(attack));
            this.field_70170_p.func_72960_a((Entity)this, this.attackHandler.getCurrentAttack());
            if (this.attackHandler.getCurrentAttack() == 4) {
                ModUtils.leapTowards((EntityLivingBase)this, this.func_70638_az().func_174791_d(), 0.2f, 0.5f);
            }
        }
    }

    @Override
    public void func_70103_a(byte id) {
        Vec3d flameColor;
        Vec3d vec3d = flameColor = this.getElement() == Element.NONE ? new Vec3d((double)0.1f, 0.0, (double)0.1f) : this.getElement().sweepColor;
        if (id >= 4 && id <= 6) {
            this.currentAnimation = this.attackHandler.getAnimation(id);
            this.getCurrentAnimation().startAnimation();
        } else if (id == 9) {
            ModUtils.performNTimes(4, i -> ModUtils.circleCallback(i.intValue(), 15, pos -> ParticleManager.spawnColoredFire(this.field_70170_p, this.field_70146_Z, this.func_174791_d().func_178787_e(new Vec3d(pos.field_72450_a, (double)(this.func_70047_e() - 0.3f + ModRandom.getFloat(0.2f)), pos.field_72448_b)), flameColor)));
        } else if (id == ModUtils.PARTICLE_BYTE) {
            Vec3d look = this.func_174806_f(this.field_70125_A, this.field_70759_as);
            Vec3d side = look.func_178785_b(-1.5707964f);
            Vec3d offset = this.func_174791_d().func_178787_e(side.func_186678_a((double)(0.5f * (float)ModRandom.randSign()))).func_178787_e(ModUtils.yVec(this.field_70146_Z.nextFloat()));
            ParticleManager.spawnColoredFire(this.field_70170_p, this.field_70146_Z, offset, flameColor);
            offset = this.func_174791_d().func_178787_e(side.func_186678_a((double)(0.5f * (float)ModRandom.randSign()))).func_178787_e(look.func_186678_a((double)(-this.field_70146_Z.nextFloat()))).func_178787_e(ModUtils.yVec(0.1f));
            ParticleManager.spawnColoredFire(this.field_70170_p, this.field_70146_Z, offset, flameColor);
        } else if (id == ModUtils.SECOND_PARTICLE_BYTE) {
            Vec3d pos = this.func_174791_d().func_178787_e(ModUtils.yVec(1.0)).func_178787_e(this.func_70040_Z().func_186678_a(2.0));
            for (int i2 = 0; i2 < 30; ++i2) {
                ParticleManager.spawnColoredFire(this.field_70170_p, this.field_70146_Z, pos.func_178787_e(ModRandom.randVec().func_178787_e(ModUtils.yVec(ModRandom.getFloat(1.5f)))), flameColor);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundsHandler.ENTITY_SHADE_AMBIENT;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundsHandler.ENTITY_SHADE_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundsHandler.ENTITY_SHADE_DEATH;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        if (this.getElement() == Element.CRIMSON) {
            return LootTableHandler.CRIMSON_MINIBOSS;
        }
        return LootTableHandler.IRON_SHADE;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (this.attackHandler.getCurrentAttack() == 5) {
            this.spinDuration = 0;
        } else {
            this.attackHandler.getCurrentAttackAction().performAction(this, target);
        }
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }
}

