/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities;

import com.barribob.MaelstromMod.Main;
import com.barribob.MaelstromMod.entity.action.ActionAerialTeleport;
import com.barribob.MaelstromMod.entity.action.ActionRayAttack;
import com.barribob.MaelstromMod.entity.action.ActionRingAttack;
import com.barribob.MaelstromMod.entity.action.ActionRuneAttack;
import com.barribob.MaelstromMod.entity.action.ActionVolley;
import com.barribob.MaelstromMod.entity.action.IAction;
import com.barribob.MaelstromMod.entity.adjustment.MovingRuneAdjustment;
import com.barribob.MaelstromMod.entity.adjustment.RandomRuneAdjustment;
import com.barribob.MaelstromMod.entity.ai.AIAerialTimedAttack;
import com.barribob.MaelstromMod.entity.ai.EntityAIWanderWithGroup;
import com.barribob.MaelstromMod.entity.ai.FlyingMoveHelper;
import com.barribob.MaelstromMod.entity.entities.EntityGoldenPillar;
import com.barribob.MaelstromMod.entity.entities.EntityLeveledMob;
import com.barribob.MaelstromMod.entity.entities.EntityMaelstromMob;
import com.barribob.MaelstromMod.entity.entities.EntityMaelstromStatueOfNirvana;
import com.barribob.MaelstromMod.entity.projectile.EntityLargeGoldenRune;
import com.barribob.MaelstromMod.entity.projectile.Projectile;
import com.barribob.MaelstromMod.entity.projectile.ProjectileGoldenMissile;
import com.barribob.MaelstromMod.entity.projectile.ProjectileMaelstromRune;
import com.barribob.MaelstromMod.entity.projectile.ProjectileStatueMaelstromMissile;
import com.barribob.MaelstromMod.entity.util.IAttack;
import com.barribob.MaelstromMod.entity.util.TimedAttackInitiator;
import com.barribob.MaelstromMod.init.ModBBAnimations;
import com.barribob.MaelstromMod.packets.MessageModParticles;
import com.barribob.MaelstromMod.particle.EnumModParticles;
import com.barribob.MaelstromMod.util.ModColors;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.RenderUtils;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGoldenBoss
extends EntityMaelstromMob
implements IAttack {
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.YELLOW, BossInfo.Overlay.NOTCHED_6);
    protected static final DataParameter<Integer> ATTACK_COUNT = EntityDataManager.func_187226_a(EntityLeveledMob.class, (DataSerializer)DataSerializers.field_187192_b);
    private static boolean doSummonNext;
    private static boolean doTeleportNext;
    Supplier<Projectile> goldenMissile = () -> new ProjectileGoldenMissile(this.field_70170_p, (EntityLivingBase)this, this.getAttack() * this.getConfigFloat("golden_missile_damage"));
    Supplier<Projectile> maelstromMissile = () -> new ProjectileStatueMaelstromMissile(this.field_70170_p, (EntityLivingBase)this, this.getAttack() * this.getConfigFloat("maelstrom_missile_damage"));
    Supplier<Projectile> goldenRune = () -> new EntityLargeGoldenRune(this.field_70170_p, (EntityLivingBase)this, this.getAttack() * this.getConfigFloat("golden_rune_damage"));
    Supplier<Projectile> maelstromRune = () -> new ProjectileMaelstromRune(this.field_70170_p, (EntityLivingBase)this, this.getAttack() * this.getConfigFloat("maelstrom_rune_damage"));
    Supplier<Projectile> maelstromOrGoldenMissile = () -> this.field_70146_Z.nextInt(2) == 0 ? this.goldenMissile.get() : this.maelstromMissile.get();
    IAction goldenRayAction = new ActionRayAttack(this.goldenMissile, 1.1f);
    IAction maelstromRayAction = new ActionRayAttack(this.maelstromMissile, 1.1f);
    private final Consumer<EntityLivingBase> rayAttack = target -> {
        ModBBAnimations.animation((EntityLivingBase)this, "statue.fireball", false);
        this.addEvent(() -> {
            this.goldenRayAction.performAction(this, (EntityLivingBase)target);
            this.func_184185_a(SoundEvents.field_187606_E, 1.0f, ModRandom.getFloat(0.2f) + 1.3f);
        }, 22);
    };
    private final Consumer<EntityLivingBase> secondPhaseRayAttack = target -> {
        ModBBAnimations.animation((EntityLivingBase)this, "statue.fireball", false);
        this.addEvent(() -> {
            this.goldenRayAction.performAction(this, (EntityLivingBase)target);
            this.maelstromRayAction.performAction(this, (EntityLivingBase)target);
            this.func_184185_a(SoundEvents.field_187606_E, 1.0f, ModRandom.getFloat(0.2f) + 1.3f);
        }, 22);
    };
    private final Consumer<EntityLivingBase> runeAttack = target -> {
        ModBBAnimations.animation((EntityLivingBase)this, "statue.runes", false);
        this.addEvent(() -> new ActionRuneAttack(this.goldenRune, new RandomRuneAdjustment((Entity)target)).performAction(this, (EntityLivingBase)target), 12);
    };
    private final Consumer<EntityLivingBase> secondPhaseRuneAttack = target -> {
        ModBBAnimations.animation((EntityLivingBase)this, "statue.runes", false);
        this.addEvent(() -> new ActionRuneAttack(this.maelstromRune, new MovingRuneAdjustment((Entity)target)).performAction(this, (EntityLivingBase)target), 12);
    };
    private final Consumer<EntityLivingBase> spawnPillarAttack = target -> {
        ModBBAnimations.animation((EntityLivingBase)this, "statue.summon", false);
        this.addEvent(() -> {
            for (int i = 0; i < this.getMobConfig().getInt("summoning_algorithm.mobs_per_spawn"); ++i) {
                boolean findGround = !this.getMobConfig().getBoolean("pillar_can_be_summoned_in_air");
                BlockPos spawnCenter = findGround ? ModUtils.findGroundBelow(this.field_70170_p, this.func_180425_c()) : this.func_180425_c();
                EntityLeveledMob mob = ModUtils.spawnMob(this.field_70170_p, spawnCenter, this.getLevel(), this.getMobConfig().getConfig("summoning_algorithm"), findGround);
                if (mob == null) continue;
                mob.func_70624_b((EntityLivingBase)target);
                ModUtils.lineCallback(this.func_174824_e(1.0f), mob.func_174791_d(), 20, (pos, j) -> Main.network.sendToAllTracking((IMessage)new MessageModParticles(EnumModParticles.EFFECT, (Vec3d)pos, Vec3d.field_186680_a, mob.getElement().particleColor), (Entity)this));
            }
        }, 15);
    };
    private final Consumer<EntityLivingBase> volleyAttack = target -> {
        ModBBAnimations.animation((EntityLivingBase)this, "statue.volley", false);
        Supplier<Projectile> projectileSupplier = this.isSecondPhase() ? this.maelstromOrGoldenMissile : this.goldenMissile;
        new ActionVolley(projectileSupplier, 1.6f).performAction(this, (EntityLivingBase)target);
    };
    private final Consumer<EntityLivingBase> teleportAttack = target -> new ActionAerialTeleport(ModColors.YELLOW).performAction(this, (EntityLivingBase)target);

    public EntityGoldenBoss(World worldIn) {
        super(worldIn);
        this.field_70765_h = new FlyingMoveHelper((EntityLiving)this);
        this.field_70699_by = new PathNavigateFlying((EntityLiving)this, worldIn);
        this.func_70105_a(1.6f, 3.6f);
        this.healthScaledAttackFactor = 0.2;
        if (!this.field_70170_p.field_72995_K) {
            this.initNirvanaAI();
        }
    }

    @Override
    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.func_174813_aQ().func_186662_g(targetDistance);
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        EntityMaelstromStatueOfNirvana boss = new EntityMaelstromStatueOfNirvana(this.field_70170_p);
        boss.func_82149_j((Entity)this);
        boss.func_70034_d(this.field_70759_as);
        if (!this.field_70170_p.field_72995_K) {
            boss.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), null);
            boss.setLevel(this.getLevel());
            boss.setElement(this.getElement());
            this.field_70170_p.func_72838_d((Entity)boss);
            EntityLivingBase attackTarget = this.func_70638_az();
            if (attackTarget != null) {
                boss.func_70624_b(attackTarget);
                this.func_184185_a(SoundEvents.field_193790_di, 2.5f, 1.0f + ModRandom.getFloat(0.2f));
                new ActionRingAttack(boss.maelstromFlame).performAction(boss, attackTarget);
            }
        }
        this.func_70107_b(0.0, 0.0, 0.0);
        super.func_70645_a(cause);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        ModUtils.removeTaskOfType(this.field_70714_bg, EntityAIWanderWithGroup.class);
    }

    private void initNirvanaAI() {
        float attackDistance = (float)this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIAerialTimedAttack((EntityLiving)this, attackDistance, 20.0f, 30.0f, new TimedAttackInitiator<EntityGoldenBoss>(this, 40)));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, ModUtils.PARTICLE_BYTE);
        }
    }

    public boolean func_180431_b(@Nonnull DamageSource source) {
        long pillars = this.goldenPillars().size();
        return super.func_180431_b(source) || pillars > 0L;
    }

    public List<EntityGoldenPillar> goldenPillars() {
        return ModUtils.getEntitiesInBox((Entity)this, this.func_174813_aQ().func_186662_g(this.getMobConfig().getDouble("pillar_protection_range"))).stream().filter(e -> e instanceof EntityGoldenPillar).filter(e -> this.field_70170_p.func_147447_a(e.func_174824_e(1.0f), this.func_174824_e(1.0f), false, true, false) == null).map(e -> (EntityGoldenPillar)e).collect(Collectors.toList());
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70146_Z.nextInt(8) == 0 && amount > 1.0f) {
            doTeleportNext = true;
        }
        double firstSummonHp = this.getMobConfig().getDouble("first_summon_hp");
        double secondSummonHp = this.getMobConfig().getDouble("second_summon_hp");
        double thirdSummonHp = this.getMobConfig().getDouble("third_summon_hp");
        double fourthSummonHp = this.getMobConfig().getDouble("fourth_summon_hp");
        float prevHealth = this.func_110143_aJ();
        boolean flag = super.func_70097_a(source, amount);
        if ((double)prevHealth > firstSummonHp && (double)this.func_110143_aJ() <= firstSummonHp || (double)prevHealth > secondSummonHp && (double)this.func_110143_aJ() <= secondSummonHp || (double)prevHealth > thirdSummonHp && (double)this.func_110143_aJ() <= thirdSummonHp || (double)prevHealth > fourthSummonHp && (double)this.func_110143_aJ() <= fourthSummonHp) {
            doSummonNext = true;
        }
        return flag;
    }

    @Override
    public int startAttack(EntityLivingBase target, float distanceSq, boolean strafingBackwards) {
        if (doSummonNext) {
            doSummonNext = false;
            this.spawnPillarAttack.accept(target);
            this.addEvent(() -> this.setAttackCount(0), 25);
            return 40;
        }
        return this.doNormalAttack(target);
    }

    public int doNormalAttack(EntityLivingBase target) {
        if (this.getAttackCount() == 0) {
            this.setAttackCount(ModRandom.range(4, 7));
        }
        boolean canSee = this.field_70170_p.func_147447_a(target.func_174824_e(1.0f), this.func_174824_e(1.0f), false, true, false) == null;
        ArrayList<Consumer> attacks = new ArrayList<Consumer>(Arrays.asList(this.volleyAttack, this.isSecondPhase() ? this.secondPhaseRayAttack : this.rayAttack, this.isSecondPhase() ? this.secondPhaseRuneAttack : this.runeAttack, this.teleportAttack));
        double[] weights = new double[]{1.0, 1.0, 1.0, canSee ? 0.0 : 2.0};
        Consumer<EntityLivingBase> nextAttack = ModRandom.choice(attacks, this.field_70146_Z, weights).next();
        if (doTeleportNext) {
            nextAttack = this.teleportAttack;
            doTeleportNext = false;
        }
        nextAttack.accept(target);
        int cooldown = this.getAttackCount() == 1 ? 120 : 40;
        this.addEvent(() -> this.setAttackCount(this.getAttackCount() - 1), 25);
        return cooldown;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == ModUtils.PARTICLE_BYTE) {
            Vec3d particleColor = this.isSecondPhase() && (double)this.field_70146_Z.nextFloat() < 0.5 ? ModColors.PURPLE : ModColors.YELLOW;
            ParticleManager.spawnEffect(this.field_70170_p, ModRandom.randVec().func_178787_e(this.func_174791_d()), particleColor);
        } else if (id == ModUtils.SECOND_PARTICLE_BYTE) {
            ModUtils.performNTimes(3, i -> ModUtils.circleCallback((float)i.intValue() * 0.5f + 1.0f, 30, pos -> {
                ParticleManager.spawnSwirl(this.field_70170_p, this.func_174791_d().func_178787_e(pos), ModColors.YELLOW, Vec3d.field_186680_a, ModRandom.range(10, 15));
                ParticleManager.spawnSwirl(this.field_70170_p, this.func_174791_d().func_178787_e(ModUtils.rotateVector2(pos, ModUtils.yVec(1.0), 90.0)), ModColors.YELLOW, Vec3d.field_186680_a, ModRandom.range(10, 15));
            }));
        }
        super.func_70103_a(id);
    }

    @Override
    public void doRender(RenderManager renderManager, double x, double y, double z, float entityYaw, float partialTicks) {
        for (EntityGoldenPillar e : this.goldenPillars()) {
            RenderUtils.drawLazer(renderManager, this.func_174791_d(), e.func_174791_d(), new Vec3d(x, y - 1.0, z), ModColors.YELLOW, (EntityLiving)this, partialTicks);
        }
    }

    public boolean isSecondPhase() {
        return (double)this.func_110143_aJ() < this.getMobConfig().getDouble("second_phase_hp");
    }

    public void func_96094_a(@Nonnull String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(@Nonnull EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(@Nonnull EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_COUNT, (Object)0);
    }

    public int getAttackCount() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_COUNT);
    }

    protected void setAttackCount(int i) {
        this.field_70180_af.func_187227_b(ATTACK_COUNT, (Object)i);
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187772_dn;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187766_dk;
    }

    @Override
    protected float getManaExp() {
        return 0.0f;
    }

    public void func_82196_d(@Nonnull EntityLivingBase target, float distanceFactor) {
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        ModUtils.aerialTravel((EntityLivingBase)this, strafe, vertical, forward);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, @Nonnull IBlockState state, @Nonnull BlockPos pos) {
    }

    public boolean func_70617_f_() {
        return false;
    }
}

