/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities;

import com.barribob.MaelstromMod.entity.action.IAction;
import com.barribob.MaelstromMod.entity.ai.EntityAIRangedAttackNoReset;
import com.barribob.MaelstromMod.entity.animation.AnimationClip;
import com.barribob.MaelstromMod.entity.animation.StreamAnimation;
import com.barribob.MaelstromMod.entity.entities.EntityMaelstromMob;
import com.barribob.MaelstromMod.entity.model.ModelBeast;
import com.barribob.MaelstromMod.entity.projectile.ProjectileBeastAttack;
import com.barribob.MaelstromMod.entity.util.ComboAttack;
import com.barribob.MaelstromMod.util.Element;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.LootTableHandler;
import com.barribob.MaelstromMod.util.handlers.SoundsHandler;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBeast
extends EntityMaelstromMob {
    private final ComboAttack attackHandler = new ComboAttack();
    private final byte leap = (byte)4;
    private final byte spit = (byte)5;
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.NOTCHED_20);

    public EntityBeast(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.8f, 2.2f);
        this.healthScaledAttackFactor = 0.2;
        if (!worldIn.field_72995_K) {
            this.attackHandler.setAttack((byte)4, (actor, target) -> ModUtils.leapTowards((EntityLivingBase)actor, target.func_174791_d(), 1.0f, 0.5f));
            this.attackHandler.setAttack((byte)5, (actor, target) -> {
                for (int i = 0; i < 5; ++i) {
                    ProjectileBeastAttack projectile = new ProjectileBeastAttack(actor.field_70170_p, (EntityLivingBase)actor, actor.getAttack() * this.getConfigFloat("spit_damage"));
                    double d0 = target.field_70163_u + (double)target.func_70047_e();
                    double d1 = target.field_70165_t - actor.field_70165_t;
                    double d2 = d0 - projectile.field_70163_u;
                    double d3 = target.field_70161_v - actor.field_70161_v;
                    float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
                    projectile.setElement(this.getElement());
                    projectile.func_70186_c(d1, d2 + (double)f, d3, 1.0f, 8.0f);
                    actor.func_184185_a(SoundEvents.field_187606_E, 1.0f, 1.0f / (actor.func_70681_au().nextFloat() * 0.4f + 0.8f));
                    actor.field_70170_p.func_72838_d((Entity)projectile);
                }
            });
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void initAnimation() {
        ArrayList animationLeap = new ArrayList();
        ArrayList<AnimationClip<ModelBeast>> head = new ArrayList<AnimationClip<ModelBeast>>();
        BiConsumer<ModelBeast, Float> headZ = (model, f) -> {
            model.head.field_78808_h = f.floatValue();
            model.jaw.field_78795_f = f.floatValue() / 2.0f;
        };
        head.add(new AnimationClip<ModelBeast>(20, 0.0f, 40.0f, headZ));
        head.add(new AnimationClip<ModelBeast>(8, 40.0f, 40.0f, headZ));
        head.add(new AnimationClip<ModelBeast>(12, 40.0f, 0.0f, headZ));
        animationLeap.add(head);
        ArrayList animationSpit = new ArrayList();
        ArrayList<AnimationClip<ModelBeast>> jaw = new ArrayList<AnimationClip<ModelBeast>>();
        BiConsumer<ModelBeast, Float> jawX = (model, f) -> {
            model.head.field_78808_h = 0.0f;
            model.jaw.field_78795_f = f.floatValue();
        };
        jaw.add(new AnimationClip<ModelBeast>(20, 0.0f, 20.0f, jawX));
        jaw.add(new AnimationClip<ModelBeast>(8, 20.0f, 20.0f, jawX));
        jaw.add(new AnimationClip<ModelBeast>(12, 20.0f, 0.0f, jawX));
        animationSpit.add(jaw);
        this.attackHandler.setAttack((byte)4, IAction.NONE, () -> new StreamAnimation(animationLeap));
        this.attackHandler.setAttack((byte)5, IAction.NONE, () -> new StreamAnimation(animationSpit));
        this.currentAnimation = new StreamAnimation(animationSpit);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, new EntityAIRangedAttackNoReset<EntityBeast>(this, 1.0, 40, 24.0f, 8.0f, 0.5f));
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SWIM_SPEED).func_111128_a(1.0);
    }

    protected float func_189749_co() {
        return 0.95f;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        this.attackHandler.getCurrentAttackAction().performAction(this, target);
        if (this.attackHandler.getCurrentAttack() == 4) {
            this.setLeaping(true);
        }
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.isLeaping()) {
            ModUtils.handleAreaImpact(2.5f, e -> Float.valueOf(this.getAttack() * this.getConfigFloat("leap_damage")), (Entity)this, this.func_174791_d(), ModDamageSource.causeElementalMeleeDamage((EntityLivingBase)this, this.getElement()), 0.3f, 0, false);
        }
        super.func_70636_d();
    }

    public void func_70037_a(NBTTagCompound compound) {
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
        super.func_70037_a(compound);
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    protected void func_70619_bc() {
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        super.func_70619_bc();
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    protected SoundEvent func_184639_G() {
        return SoundsHandler.ENTITY_BEAST_AMBIENT;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundsHandler.ENTITY_BEAST_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundsHandler.ENTITY_BEAST_HURT;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        if (this.getElement() == Element.CRIMSON) {
            return LootTableHandler.CRIMSON_MINIBOSS;
        }
        return LootTableHandler.SWAMP_BOSS;
    }

    protected float func_70599_aP() {
        return 0.5f;
    }

    @Override
    public void func_184724_a(boolean swingingArms) {
        super.func_184724_a(swingingArms);
        if (this.isSwingingArms()) {
            this.attackHandler.setCurrentAttack(ModRandom.choice(new Byte[]{(byte)4, (byte)5}));
            this.field_70170_p.func_72960_a((Entity)this, this.attackHandler.getCurrentAttack());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4 || id == 5) {
            this.currentAnimation = this.attackHandler.getAnimation(id);
            this.getCurrentAnimation().startAnimation();
        }
        super.func_70103_a(id);
    }

    @Override
    public void onStopLeaping() {
    }
}

