/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.animation;

import com.barribob.MaelstromMod.entity.animation.ArrayAnimation;
import java.util.function.BiConsumer;
import net.minecraft.client.model.ModelBase;

public class AnimationClip<T extends ModelBase>
extends ArrayAnimation<T> {
    private final float startValue;
    private final float endValue;
    private final BiConsumer<T, Float> setModelRotationsImpl;
    boolean isEnded = false;

    public AnimationClip(int animationLength, float startValue, float endValue, BiConsumer<T, Float> setModelRotationsImpl) {
        super(animationLength);
        this.startValue = startValue;
        this.endValue = endValue;
        this.setModelRotationsImpl = setModelRotationsImpl;
    }

    @Override
    public void startAnimation() {
        this.attackTimer = 0;
        this.isEnded = false;
    }

    @Override
    public void update() {
        super.update();
        if (this.animationLength - 1 == this.attackTimer) {
            this.isEnded = true;
        }
    }

    @Override
    public final void setModelRotations(T model, float limbSwing, float limbSwingAmount, float partialTicks) {
        float progress = 0.0f;
        if (this.animationLength > 1) {
            progress = Math.max(0.0f, Math.min(1.0f, ((float)this.attackTimer + partialTicks) / (float)(this.animationLength - 1)));
        }
        float degrees = (this.endValue - this.startValue) * progress + this.startValue;
        this.setModelRotationsImpl.accept(model, Float.valueOf((float)Math.toRadians(degrees)));
    }

    public boolean isEnded() {
        return this.isEnded;
    }
}

