/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="mm", name="Maelstrom Mod/config")
@Mod.EventBusSubscriber
public class ModConfig {
    @Config.Ignore
    private static final String config = "mm.config.";
    @Config.LangKey(value="mm.config.shaders")
    @Config.Comment(value={"Options to turn off features that are known to conflict visually with shaders."})
    public static ShaderCat shaders = new ShaderCat();
    @Config.LangKey(value="mm.config.world")
    public static WorldCat world = new WorldCat();
    @Config.LangKey(value="mm.config.gui")
    public static GuiCat gui = new GuiCat(0, 0, 0, 0, true, true);
    @Config.LangKey(value="mm.config.balancing")
    public static BalanceCat balance = new BalanceCat();
    @Config.LangKey(value="mm.config.entities")
    public static EntityCat entities = new EntityCat();
    @Config.LangKey(value="mm.config.server")
    public static ServerCat server = new ServerCat();

    @SubscribeEvent
    public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("mm")) {
            ConfigManager.sync((String)"mm", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class ShaderCat {
        @Config.LangKey(value="mm.config.render_cliff_fog")
        @Config.Comment(value={"Whether to render the cliff fog that rests above the swamp. Does not change the ambient fog, but just the rendered plane."})
        public boolean render_fog = true;
        @Config.LangKey(value="mm.config.render_custom_sky")
        @Config.Comment(value={"Whether to render a custom sky for the Azure and Nexus Dimensions. This is known to glitch out for certain shaders."})
        public boolean render_custom_sky = true;
    }

    public static class ServerCat {
        @Config.LangKey(value="mm.config.sync_config_on_login")
        @Config.Comment(value={"Whether to make configs of the players that login match the server config (to keep stuff like item stats consistent)."})
        public boolean sync_on_login = true;
    }

    public static class EntityCat {
        @Config.LangKey(value="mm.config.use_vanilla_pathfinding")
        @Config.Comment(value={"If there is another mod that improves the vanilla pathfinding ai, then set this to true. Takes effect after reloading the world."})
        public boolean useVanillaPathfinding = false;
        @Config.LangKey(value="mm.config.attack_all")
        @Config.Comment(value={"Whether maelstrom mobs should attack any living entity they see. Takes effect after reloading the world."})
        public boolean attackAll = true;
        @Config.LangKey(value="mm.config.display_mob_level")
        @Config.Comment(value={"Display the level of most mobs above their nametag."})
        public boolean displayLevel = false;
    }

    public static class WorldCat {
        @Config.RequiresMcRestart
        @Config.LangKey(value="mm.config.fracture_dimension_id")
        public int fracture_dimension_id = 125;
        @Config.RequiresMcRestart
        @Config.LangKey(value="mm.config.nexus_dimension_id")
        public int nexus_dimension_id = 126;
        @Config.RequiresMcRestart
        @Config.LangKey(value="mm.config.cliff_dimension_id")
        public int cliff_dimension_id = 127;
        @Config.RequiresMcRestart
        @Config.LangKey(value="mm.config.dark_nexus_dimension_id")
        public int dark_nexus_dimension_id = 128;
        @Config.RequiresMcRestart
        @Config.LangKey(value="mm.config.crimson_kingdom_dimension_id")
        public int crimson_kingdom_dimension_id = 129;
        @Config.RequiresMcRestart
        @Config.LangKey(value="mm.config.disable_dimensions")
        public boolean disableDimensions = false;
        @Config.LangKey(value="mm.config.invasion_time")
        @Config.Comment(value={"How many minutes before attempting to spawn the invasion tower. Cannot be changed after the world is loaded."})
        @Config.RangeInt(min=0, max=1200)
        public int invasionTime = 180;
        @Config.LangKey(value="mm.config.invasion_warning_time")
        @Config.Comment(value={"The number of minutes before the invasion when a warning message is sent to the players."})
        @Config.RangeInt(min=0, max=1200)
        public int warningInvasionTime = 10;
    }

    public static class BalanceCat {
        @Config.LangKey(value="mm.config.scale")
        @Config.RangeDouble(min=1.0, max=3.0)
        @Config.Comment(value={"Determines how rapidly the weapons, armor, and mobs grow in difficulty. (To remove the leveling system, set the progression scale to 1 and disable maelstrom tooltips in the gui category.)"})
        public float progression_scale = 1.3f;
        @Config.LangKey(value="mm.config.mob_damage")
        @Config.RangeDouble(min=0.5, max=3.0)
        @Config.Comment(value={"Scales the base damage of mobs in this mod."})
        public float mob_damage = 1.2f;
        @Config.LangKey(value="mm.config.mob_armor")
        @Config.RangeDouble(min=0.1, max=1.0)
        @Config.Comment(value={"Amount of additional damage reduction on mobs."})
        public float mob_armor = 1.0f;
        @Config.LangKey(value="mm.config.weapon_damage")
        @Config.RangeDouble(min=1.0, max=3.0)
        @Config.Comment(value={"Base damage multiplier for weapons in this mod."})
        public float weapon_damage = 1.0f;
        @Config.LangKey(value="mm.config.armor_toughness")
        @Config.RangeDouble(min=0.5, max=5.0)
        @Config.Comment(value={"Specifies the strength of the mod's base armor material."})
        public float armor_toughness = 3.0f;
        @Config.LangKey(value="mm.config.elemental_factor")
        @Config.RangeDouble(min=1.0, max=3.0)
        @Config.Comment(value={"Represents how important using the correct color (or element) is. To disable entirely, set to 1.0, and in the gui category disable elemental visuals."})
        public float elemental_factor = 1.6f;
    }

    public static class GuiCat {
        @Config.LangKey(value="mm.config.armor_bar_x")
        public int maelstrom_armor_bar_offset_x;
        @Config.LangKey(value="mm.config.armor_bar_y")
        public int maelstrom_armor_bar_offset_y;
        @Config.LangKey(value="mm.config.mana_bar_x")
        public int maelstrom_mana_bar_offset_x;
        @Config.LangKey(value="mm.config.mana_bar_y")
        public int maelstrom_mana_bar_offset_y;
        @Config.LangKey(value="mm.config.show_cooldown_bar")
        public boolean showGunCooldownBar;
        @Config.LangKey(value="mm.config.show_mana_bar")
        public boolean showManaBar;
        @Config.LangKey(value="mm.config.show_armor_bar")
        public boolean showArmorBar = true;
        @Config.LangKey(value="mm.config.disable_maelstrom_item_tooltips")
        @Config.Comment(value={"Option to visually remove Maelstrom Level and Maelstrom Armor. (To remove the leveling system, set the progression scale to 1). "})
        public boolean disableMaelstromArmorItemTooltips = false;
        @Config.LangKey(value="mm.config.disable_elemental_visuals")
        @Config.Comment(value={"Disables elemental system visuals (tooltips/entity badges)"})
        public boolean disableElementalVisuals = false;

        public GuiCat(int x, int y, int mana_x, int mana_y, boolean showCooldown, boolean showMana) {
            this.maelstrom_armor_bar_offset_x = x;
            this.maelstrom_armor_bar_offset_y = y;
            this.maelstrom_mana_bar_offset_x = mana_x;
            this.maelstrom_mana_bar_offset_y = mana_y;
            this.showGunCooldownBar = showCooldown;
            this.showManaBar = showMana;
        }
    }
}

