/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements;

import com.brandon3055.brandonscore.client.gui.modulargui_old.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui_old.MGuiElementBase;
import com.brandon3055.brandonscore.lib.StackReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class MGuiStackIcon
extends MGuiElementBase {
    public static Map<Integer, ItemStack> stackCache = new HashMap<Integer, ItemStack>();
    public boolean drawCount = true;
    public boolean drawToolTip = true;
    public boolean drawHoverHighlight = false;
    private MGuiElementBase background = null;
    protected List<String> toolTipOverride = null;
    private StackReference stackReference;
    public int xOffset = 0;
    public int yOffset = 0;

    public MGuiStackIcon(IModularGui modularGui, int xPos, int yPos, int xSize, int ySize, StackReference stackReference) {
        super(modularGui, xPos, yPos, xSize, ySize);
        this.stackReference = stackReference;
    }

    public MGuiStackIcon(IModularGui modularGui, int xPos, int yPos, StackReference stackReference) {
        super(modularGui, xPos, yPos);
        this.stackReference = stackReference;
        this.ySize = 18;
        this.xSize = 18;
    }

    @Override
    public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
        if (this.drawHoverHighlight && this.isMouseOver(mouseX, mouseY)) {
            this.drawColouredRect(this.xPos, this.yPos, this.xSize, this.ySize, -2130706433);
        }
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        double scaledWidth = (double)this.xSize / 18.0;
        double scaledHeight = (double)this.ySize / 18.0;
        GlStateManager.func_179137_b((double)((double)this.xPos + scaledWidth + (double)this.xOffset), (double)((double)this.yPos + scaledHeight + (double)this.yOffset), (double)(this.getRenderZLevel() - 80.0));
        GlStateManager.func_179139_a((double)scaledWidth, (double)scaledHeight, (double)1.0);
        minecraft.func_175599_af().func_175042_a(this.getStack(), 0, 0);
        if (this.drawCount && this.getStack().func_190916_E() > 1) {
            String s = this.getStack().func_190916_E() + "";
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-(this.getRenderZLevel() - 80.0)));
            this.zOffset = 45.0;
            this.drawString(minecraft.field_71466_p, s, this.xSize - minecraft.field_71466_p.func_78256_a(s) - 1, minecraft.field_71466_p.field_78288_b, 0xFFFFFF, true);
            this.zOffset = 0.0;
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.isMouseOver(mouseX - this.xOffset, mouseY - this.yOffset) && (this.drawToolTip || this.toolTipOverride != null)) {
            List list = this.toolTipOverride != null ? this.toolTipOverride : this.getStack().func_82840_a((EntityPlayer)minecraft.field_71439_g, (ITooltipFlag)(minecraft.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
            this.drawHoveringText(list, mouseX, mouseY, minecraft.field_71466_p, this.modularGui.screenWidth(), this.modularGui.screenHeight());
            return true;
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    public MGuiStackIcon setStack(StackReference stackReference) {
        this.stackReference = stackReference;
        return this;
    }

    public MGuiStackIcon setBackground(MGuiElementBase background) {
        if (background == null) {
            if (this.background != null) {
                this.removeChild(this.background);
                this.background = null;
            }
        } else {
            if (this.background != null) {
                this.removeChild(this.background);
            }
            this.background = background;
            background.xPos = this.xPos;
            background.yPos = this.yPos;
            background.xSize = this.xSize;
            background.ySize = this.ySize;
            this.addChild(background);
        }
        return this;
    }

    public MGuiStackIcon setToolTip(boolean drawToolTip) {
        this.drawToolTip = drawToolTip;
        return this;
    }

    public ItemStack getStack() {
        ItemStack stack;
        int hash = this.stackReference.hashCode();
        if (!stackCache.containsKey(hash)) {
            stack = this.stackReference.createStack();
            if (stack.func_190926_b()) {
                stack = new ItemStack(Blocks.field_180401_cv);
                this.toolTipOverride = new ArrayList<String>();
                this.toolTipOverride.add("Failed to load Item Stack");
                this.toolTipOverride.add("This may mean the mod the stack belongs to is not installed");
                this.toolTipOverride.add("Or its just broken...");
            }
            stackCache.put(hash, stack);
        }
        if ((stack = stackCache.get(hash)).func_190926_b()) {
            stack = new ItemStack(Blocks.field_180401_cv);
            stackCache.remove(hash);
        }
        return stack;
    }

    public MGuiStackIcon setDrawHoverHighlight(boolean drawHoverHighlight) {
        this.drawHoverHighlight = drawHoverHighlight;
        return this;
    }
}

