/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils.java.io.win32;

import com.zeitheron.hammercore.utils.java.io.win32.ZoneIdentifierFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZoneIdentifier {
    public int zoneId;
    public String referrerUrl;
    public String hostUrl;

    public String toString() {
        return "ZoneIdentifier{\"ZoneId\":" + this.zoneId + ",\"ReferrerUrl\":\"" + this.referrerUrl + "\",\"HostUrl\":\"" + this.hostUrl + "\"}";
    }

    public void read(BufferedReader reader) throws IOException {
        HashMap<String, String> strs = new HashMap<String, String>(3);
        String ln = reader.readLine();
        if (ln != null && !ln.equals("[ZoneTransfer]")) {
            throw new IllegalArgumentException("Invalid format");
        }
        while ((ln = reader.readLine()) != null) {
            if (!ln.contains("=")) continue;
            String[] ln0 = ln.split("=", 2);
            strs.put(ln0[0], ln0[1]);
        }
        this.zoneId = Integer.parseInt(strs.getOrDefault("ZoneId", "3"));
        this.referrerUrl = (String)strs.get("ReferrerUrl");
        this.hostUrl = (String)strs.get("HostUrl");
    }

    public void write(BufferedWriter writer) throws IOException {
        HashMap<String, String> strs = new HashMap<String, String>(3);
        strs.put("ZoneId", Integer.toString(this.zoneId));
        strs.put("ReferrerUrl", this.referrerUrl);
        strs.put("HostUrl", this.hostUrl);
        writer.write("[ZoneTransfer]");
        writer.newLine();
        int written = strs.size();
        for (String key : strs.keySet()) {
            writer.write(key + "=" + (String)strs.get(key));
            if (--written <= 0) continue;
            writer.newLine();
        }
    }

    public static ZoneIdentifierFile getZoneIdentifierFile(File file) {
        if (file instanceof ZoneIdentifierFile) {
            return (ZoneIdentifierFile)file;
        }
        String f = file.getAbsolutePath();
        if (f.indexOf(58, 3) != -1) {
            f = f.substring(0, f.lastIndexOf(58));
        }
        return new ZoneIdentifierFile(file, f + ":Zone.Identifier");
    }

    public static boolean createInternetDownloadFor(File file, String referrerUrl, String hostUrl) throws IOException {
        ZoneIdentifierFile zif;
        if (file.isFile() && (zif = ZoneIdentifier.getZoneIdentifierFile(file)) != null) {
            ZoneIdentifier id = new ZoneIdentifier();
            return zif.set(id);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<ZoneIdentifier> forFile(File file) throws IOException {
        ZoneIdentifierFile zif = ZoneIdentifier.getZoneIdentifierFile(file);
        if (zif.isFile()) {
            try (BufferedReader bf2222 = new BufferedReader(new FileReader(zif));){
                ZoneIdentifier zi = new ZoneIdentifier();
                zi.read(bf2222);
                Optional<ZoneIdentifier> optional = Optional.of(zi);
                return optional;
            }
            catch (FileNotFoundException bf2222) {
                // empty catch block
            }
        }
        if (!file.isFile()) return Optional.empty();
        if (!ZoneIdentifier.isWindows()) return Optional.empty();
        try (BufferedReader bf = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(String.join((CharSequence)"\n", ZoneIdentifier.readADS(file.toPath(), "Zone.Identifier")).getBytes(StandardCharsets.UTF_8))));){
            ZoneIdentifier zi = new ZoneIdentifier();
            zi.read(bf);
            Optional<ZoneIdentifier> optional = Optional.of(zi);
            return optional;
        }
    }

    public static Optional<ZoneIdentifier> forFileSafe(File file) {
        try {
            return ZoneIdentifier.forFile(file);
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows");
    }

    public static ArrayList<String> readADS(Path toParse, String ads) {
        ArrayList<String> parsedADS = new ArrayList<String>();
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "more", "<", toParse.toFile() + ":" + ads});
            process.waitFor();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = br.readLine()) != null) {
                    parsedADS.add(line);
                }
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return parsedADS;
    }

    public static ArrayList<String> listADS(Path toParse) {
        String path = toParse.toString();
        ArrayList<String> parsedADS = new ArrayList<String>();
        String command = "cmd.exe /c dir " + path + " /r";
        Pattern pattern = Pattern.compile("\\s*[0123456789,]+\\s*([^:]+:[^:]+:.+)");
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "dir", path, "/r"});
            process.waitFor();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = br.readLine()) != null) {
                    Matcher matcher = pattern.matcher(line);
                    if (!matcher.matches()) continue;
                    parsedADS.add(matcher.group(1));
                }
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return parsedADS;
    }
}

