/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils.java.io.win32;

import com.zeitheron.hammercore.lib.zlib.json.JSONObject;
import com.zeitheron.hammercore.lib.zlib.json.JSONTokener;
import com.zeitheron.hammercore.lib.zlib.web.HttpRequest;
import com.zeitheron.hammercore.utils.java.StreamHelper;
import com.zeitheron.hammercore.utils.java.io.win32.ZoneIdentifier;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;

public class ModSourceAdapter {
    public static final List<IllegalSite> ILLEGAL_SITES;

    public static Optional<ModSource> getModSource(String modId) {
        Map mods = Loader.instance().getIndexedModList();
        return StreamHelper.optionalStream(Optional.ofNullable(mods.get(modId))).map(ModContainer::getSource).map(ZoneIdentifier::forFileSafe).flatMap(StreamHelper::optionalStream).map(ModSource::new).findFirst();
    }

    public static Optional<ModSource> getModSource(Class<?> modClass) {
        try {
            File modFile = null;
            Mod mod = modClass.getDeclaredAnnotation(Mod.class);
            Map mods = Loader.instance().getIndexedModList();
            if (mod != null) {
                ModContainer mc = (ModContainer)mods.get(mod.modid());
                modFile = mc.getSource();
            }
            if (modFile == null) {
                modFile = new File(modClass.getProtectionDomain().getCodeSource().getLocation().toURI());
            }
            return ZoneIdentifier.forFile(modFile).map(ModSource::new);
        }
        catch (Throwable err) {
            err.printStackTrace();
            return Optional.empty();
        }
    }

    static {
        List illegalSites = Collections.emptyList();
        try {
            illegalSites = StreamHelper.optionalStream(new JSONTokener(HttpRequest.get("https://api.stopmodreposts.org/minecraft/sites.json").userAgent("HammerLib").body()).nextValueARR()).flatMap(array -> IntStream.range(0, array.size()).mapToObj(array::getJSONObject).map(IllegalSite::new)).collect(Collectors.toList());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        ILLEGAL_SITES = illegalSites;
    }

    public static class IllegalSite
    implements Predicate<URL> {
        public final String domain;
        public final String notes;
        public final String path;
        public final String reason;

        public IllegalSite(String domain, String notes, String path, String reason) {
            this.domain = domain;
            this.notes = notes;
            this.path = path;
            this.reason = reason;
        }

        public IllegalSite(JSONObject object) {
            this(object.getString("domain"), object.optString("notes"), object.optString("path"), object.optString("reason"));
        }

        @Override
        public boolean test(URL url) {
            return (url.getHost().equalsIgnoreCase(this.domain) || url.getHost().endsWith("." + this.domain)) && url.getPath().startsWith(this.path);
        }
    }

    public static class ModSource {
        public final String referrerUrl;
        public final String hostUrl;

        public ModSource(String referrerUrl, String hostUrl) {
            this.referrerUrl = referrerUrl;
            this.hostUrl = hostUrl;
        }

        public ModSource(ZoneIdentifier id) {
            this(id.referrerUrl, id.hostUrl);
        }

        public boolean wasDownloadedIllegally() {
            try {
                List<URL> urls = Arrays.asList(new URL(this.referrerUrl), new URL(this.hostUrl));
                return ILLEGAL_SITES.stream().anyMatch(site -> urls.stream().anyMatch(site));
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        public String referrerDomain() {
            try {
                return new URL(this.referrerUrl).getHost();
            }
            catch (MalformedURLException malformedURLException) {
                return this.referrerUrl;
            }
        }
    }
}

