/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils.java;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ResettableLazy<T> {
    private final Object lock = new Object();
    private T value;
    private Boolean initialized;
    private final Supplier<T> provider;

    public static <T> ResettableLazy<T> of() {
        return new ResettableLazy<T>((Supplier)null);
    }

    public static <T> ResettableLazy<T> of(T value) {
        return new ResettableLazy<T>(value);
    }

    public static <T> ResettableLazy<T> of(Supplier<T> provider) {
        return new ResettableLazy<T>(provider);
    }

    private ResettableLazy(T value) {
        this.value = value;
        this.initialized = true;
        this.provider = () -> value;
    }

    private ResettableLazy(Supplier<T> provider) {
        this.value = null;
        this.initialized = false;
        this.provider = provider;
    }

    public void reset() {
        this.value = null;
        this.initialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.initialized.booleanValue() && this.provider != null) {
                this.initialized = true;
                this.value = this.provider.get();
            }
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ifPresent(Consumer<T> consumer) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.initialized.booleanValue()) {
                return;
            }
            consumer.accept(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> ResettableLazy<R> map(Function<T, R> mapper) {
        Object object = this.lock;
        synchronized (object) {
            return ResettableLazy.of(() -> mapper.apply(this.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T orElse(T elseValue) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.initialized.booleanValue()) {
                return elseValue;
            }
            return this.value;
        }
    }
}

