/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CharacterFilteringUtil {
    private static final Set<Character> allowedchars = new HashSet<Character>();
    public static final char[] NUM_FILTER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char[] SYMBOL_FILTER = new char[]{'!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '-', '=', '/', '+', '\'', '\\', '\"', ';', '.', ',', ' ', ':', '<', '>', '[', ']', '{', '}', '_'};
    public static final char[] EN_FILTER = new char[]{'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', 'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'z', 'x', 'c', 'v', 'b', 'n', 'm'};

    private static List<Character> chars() {
        ArrayList<Character> c = new ArrayList<Character>();
        try {
            Field[] fs;
            for (Field f : fs = CharacterFilteringUtil.class.getFields()) {
                char[] charArr;
                if (!f.getType().isAssignableFrom(char[].class)) continue;
                for (char cs : charArr = (char[])f.get(null)) {
                    c.add(Character.valueOf(cs));
                }
            }
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
        return c;
    }

    public static boolean charRetained(char in) {
        return allowedchars.contains(Character.valueOf(Character.toLowerCase(in))) || allowedchars.contains(Character.valueOf(Character.toUpperCase(in)));
    }

    public static String filter(String input) {
        String otp = "";
        for (int i = 0; i < input.length(); ++i) {
            if (!CharacterFilteringUtil.charRetained(input.charAt(i))) continue;
            otp = otp + input.charAt(i);
        }
        return otp;
    }

    static {
        allowedchars.addAll(CharacterFilteringUtil.chars());
    }
}

