/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.net.props;

import com.zeitheron.hammercore.net.props.IPropertyChangeHandler;
import com.zeitheron.hammercore.net.props.NetPropertyAbstract;
import com.zeitheron.hammercore.utils.NPEUtils;
import java.lang.reflect.Constructor;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class NetPropertyNBTSerializable<T extends NBTBase, N extends INBTSerializable<T>>
extends NetPropertyAbstract<N> {
    public NetPropertyNBTSerializable(IPropertyChangeHandler handler, @Nonnull N initialValue) {
        super(handler, initialValue);
        NPEUtils.checkNotNull(initialValue, "initialValue");
        try {
            initialValue.getClass().getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new NullPointerException("initialValue doesn't have an empty constructor!");
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        try {
            Constructor<?> nc = Class.forName(nbt.func_74779_i("Class")).getConstructor(new Class[0]);
            nc.setAccessible(true);
            this.value = nc.newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ((INBTSerializable)this.value).deserializeNBT(nbt.func_74781_a("Tag"));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("Class", ((INBTSerializable)this.value).getClass().getName());
        nbt.func_74782_a("Tag", ((INBTSerializable)this.value).serializeNBT());
        return nbt;
    }
}

