/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.lib.zlib.database;

import java.security.SecureRandom;
import java.util.Arrays;

public class SafeStore {
    private final byte[] store;

    public SafeStore(byte[] store) {
        this.store = store;
    }

    public boolean matches(byte[] contents) {
        return this.equals(SafeStore.of(contents, this.store.length));
    }

    public boolean matches(CharSequence contents) {
        return this.matches((contents + "").getBytes());
    }

    public boolean equals(Object a) {
        return a instanceof SafeStore && Arrays.equals(((SafeStore)a).store, this.store);
    }

    public static SafeStore of(CharSequence contents) {
        return SafeStore.of((contents + "").getBytes());
    }

    public static SafeStore of(byte[] contents) {
        return SafeStore.of(contents, 32);
    }

    public static SafeStore of(CharSequence contents, int storeLen) {
        return SafeStore.of((contents + "").getBytes(), storeLen);
    }

    public static SafeStore of(byte[] contents, int storeLen) {
        SecureRandom rand = new SecureRandom(contents);
        byte[] data = new byte[storeLen];
        rand.nextBytes(data);
        return new SafeStore(data);
    }
}

